/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.ecmal4.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSNamespaceImpl;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSImportStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSPackageWrapper;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSStubbedStatementImpl;
import com.intellij.lang.javascript.psi.resolve.JSImportHandlingUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.stubs.JSPackageStatementStub;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveState;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.util.IncorrectOperationException;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSPackageStatementImpl
extends JSStubbedStatementImpl<JSPackageStatementStub>
implements JSPackageStatement {
    public JSPackageStatementImpl(ASTNode node) {
        super(node);
    }

    public JSPackageStatementImpl(JSPackageStatementStub stub) {
        super(stub, (IStubElementType)JSStubElementTypes.PACKAGE_STATEMENT);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/lang/javascript/psi/ecmal4/impl/JSPackageStatementImpl", "accept"));
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSPackageStatement((JSPackageStatement)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public String getName() {
        JSPackageStatementStub stub = (JSPackageStatementStub)this.getStub();
        if (stub != null) {
            return stub.getName();
        }
        ASTNode node = this.findNameIdentifier();
        if (node != null) {
            return ((JSReferenceExpression)node.getPsi()).getReferencedName();
        }
        return "";
    }

    public String getQualifiedName() {
        JSPackageStatementStub stub = (JSPackageStatementStub)this.getStub();
        if (stub != null) {
            return stub.getQualifiedName();
        }
        ASTNode node = this.findNameIdentifier();
        if (node != null) {
            return node.getText();
        }
        return null;
    }

    public JSSourceElement[] getStatements() {
        return (JSSourceElement[])this.getStubOrPsiChildren(JSExtendedLanguagesTokenSetProvider.SOURCE_ELEMENTS, (PsiElement[])JSSourceElement.EMPTY_ARRAY);
    }

    public void setQualifiedName(String expectedPackageNameFromFile) {
        JSPackageStatementImpl.doChangeName(this.getProject(), this, expectedPackageNameFromFile);
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        JSReferenceExpression expr;
        PsiElement element;
        ASTNode child;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/ecmal4/impl/JSPackageStatementImpl", "setName"));
        }
        VirtualFile virtualFile = this.getContainingFile().getVirtualFile();
        String expectedPackageNameFromFile = JSResolveUtil.getExpectedPackageNameFromFile(virtualFile, this.getProject());
        if (expectedPackageNameFromFile != null && expectedPackageNameFromFile.equals(this.getQualifiedName())) {
            try {
                JSPsiImplUtils.doRenameParentDirectoryIfNeeded(virtualFile, name, (Object)this);
            }
            catch (IOException e) {
                throw new IncorrectOperationException((Throwable)e);
            }
        }
        if ((child = this.findNameIdentifier()) != null && (element = (expr = (JSReferenceExpression)child.getPsi()).getReferenceNameElement()) != null) {
            JSChangeUtil.doIdentifierReplacement((PsiElement)expr, element, name);
        }
        return this;
    }

    public ASTNode findNameIdentifier() {
        return this.getNode().findChildByType(JSElementTypes.REFERENCE_EXPRESSION);
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState substitutor, PsiElement lastParent, @NotNull PsiElement place) {
        boolean b;
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/psi/ecmal4/impl/JSPackageStatementImpl", "processDeclarations"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/lang/javascript/psi/ecmal4/impl/JSPackageStatementImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/javascript/psi/ecmal4/impl/JSPackageStatementImpl", "processDeclarations"));
        }
        ResolveProcessor.ProcessingOptions packageProcessingOptions = processor instanceof ResolveProcessor ? ((ResolveProcessor)processor).getProcessingOptions() : ResolveProcessor.DEFAULT_RESOLVE;
        if (packageProcessingOptions.toProcessPackageContent(lastParent, this) && !(b = JSResolveUtil.processDeclarationsInScope(this, processor, ResolveState.initial(), lastParent, place))) {
            return false;
        }
        if (packageProcessingOptions.toProcessPackageImports(lastParent, this)) {
            processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, (Object)this);
            return JSImportHandlingUtil.tryResolveImports(processor, (PsiNamedElement)this, place);
        }
        return true;
    }

    public PsiElement getNameIdentifier() {
        ASTNode node = this.findNameIdentifier();
        return node != null ? node.getPsi() : null;
    }

    @Override
    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/ecmal4/impl/JSPackageStatementImpl", "addBefore"));
        }
        if (JSChangeUtil.isStatementOrComment(element)) {
            PsiElement insertedElement = JSChangeUtil.doAddBefore((PsiElement)this, element, anchor);
            CodeStyleManager.getInstance((Project)this.getProject()).reformatNewlyAddedElement(this.getNode(), insertedElement.getNode());
            return insertedElement;
        }
        return super.addBefore(element, anchor);
    }

    @Override
    public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/ecmal4/impl/JSPackageStatementImpl", "addAfter"));
        }
        if (JSChangeUtil.isStatementOrComment(element)) {
            PsiElement insertedElement = JSChangeUtil.doAddAfter((PsiElement)this, element, anchor);
            CodeStyleManager.getInstance((Project)this.getProject()).reformatNewlyAddedElement(this.getNode(), insertedElement.getNode());
            return insertedElement;
        }
        return super.addAfter(element, anchor);
    }

    public static void doChangeName(Project project, JSPackageStatement packageStatement, String expected) {
        if (expected == null) {
            return;
        }
        ASTNode node = packageStatement.findNameIdentifier();
        ASTNode parent = packageStatement.getNode();
        if (expected.length() == 0) {
            if (node != null) {
                ASTNode treeNext = node.getTreeNext();
                parent.removeChild(node);
                if (treeNext.getPsi() instanceof PsiWhiteSpace) {
                    parent.removeChild(treeNext);
                }
            }
        } else {
            ASTNode newNode = JSChangeUtil.createExpressionFromText(project, expected);
            if (node != null) {
                parent.replaceChild(node, newNode);
            } else {
                ASTNode packageNode = parent.findChildByType(JSTokenTypes.PACKAGE_KEYWORD);
                parent.addChild(newNode, packageNode.getTreeNext());
                parent.addChild(JSChangeUtil.createJSTreeFromText(project, " "), packageNode.getTreeNext());
            }
        }
    }

    public boolean isEquivalentTo(PsiElement another) {
        return JSPackageWrapper.isPackageReferenceOfSomeForm(this.getQualifiedName(), this.getProject(), this.getResolveScope(), another);
    }

    public void deleteChildInternal(@NotNull ASTNode child) {
        PsiElement parent;
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/lang/javascript/psi/ecmal4/impl/JSPackageStatementImpl", "deleteChildInternal"));
        }
        JSSourceElement[] statements = this.getStatements();
        boolean onlyImportStatementsLeftInPackage = true;
        for (JSSourceElement statement : statements) {
            if (statement instanceof JSImportStatement || statement.getNode() == child) continue;
            onlyImportStatementsLeftInPackage = false;
            break;
        }
        if (onlyImportStatementsLeftInPackage && (parent = this.getParent()) instanceof JSFile) {
            parent.delete();
            return;
        }
        super.deleteChildInternal(child);
    }

    @Nullable
    public JSQualifiedName getNamespace() {
        return JSPsiImplUtils.buildNamespaceFromQualifiedName((JSQualifiedNamedElement)this);
    }

    public boolean isNamespaceExplicitlyDeclared() {
        return true;
    }

    @NotNull
    public JSAttributeList.AccessType getAccessType() {
        JSAttributeList.AccessType accessType = JSAttributeList.AccessType.PACKAGE_LOCAL;
        if (accessType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecmal4/impl/JSPackageStatementImpl", "getAccessType"));
        }
        return accessType;
    }

    public boolean isExported() {
        return false;
    }

    public boolean isDeprecated() {
        return false;
    }

    @NotNull
    public JSContext getJSContext() {
        JSContext jSContext = JSContext.UNKNOWN;
        if (jSContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecmal4/impl/JSPackageStatementImpl", "getJSContext"));
        }
        return jSContext;
    }

    @NotNull
    public JSNamespace getJSNamespace() {
        JSNamespaceImpl jSNamespaceImpl = new JSNamespaceImpl(this.getNamespace(), this.getJSContext(), this.isNamespaceExplicitlyDeclared());
        if (jSNamespaceImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecmal4/impl/JSPackageStatementImpl", "getJSNamespace"));
        }
        return jSNamespaceImpl;
    }
}

