/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.stubs.impl;

import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingDataStructure;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.impl.JSElementIndexingDataStructureImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.util.SmartList;
import gnu.trove.THashMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSElementIndexingDataImpl
implements JSElementIndexingData {
    @Nullable
    private Collection<JSImplicitElement> myElements;
    @Nullable
    private Collection<Pair<String, String>> myTypedefs;
    @Nullable
    private Collection<Pair<String, String>> myBaseTypes;
    private boolean myIsClassExplicitly;
    private boolean myIsInterfaceExplicitly;
    private Map<String, String> myUserStrings;

    public JSElementIndexingDataImpl() {
    }

    public JSElementIndexingDataImpl(@NotNull JSElementIndexingDataStructure structure, @Nullable PsiElement provider) {
        if (structure == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "structure", "com/intellij/lang/javascript/psi/stubs/impl/JSElementIndexingDataImpl", "<init>"));
        }
        Collection elements = structure.getImplicitElements();
        this.myElements = elements == null ? null : (Collection)elements.stream().map(s -> s.toImplicitElement(provider)).collect(Collectors.toList());
        this.myTypedefs = structure.getTypedefs();
        this.myBaseTypes = structure.getBaseTypes();
        this.myIsClassExplicitly = structure.isClassExplicitly();
        this.myIsInterfaceExplicitly = structure.isInterfaceExplicitly();
        this.myUserStrings = structure.getUserStrings();
    }

    public void addImplicitElement(@NotNull JSImplicitElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/stubs/impl/JSElementIndexingDataImpl", "addImplicitElement"));
        }
        if (this.myElements == null) {
            this.myElements = new SmartList();
        }
        this.myElements.add(element);
    }

    public void addImplicitElements(@NotNull Collection<JSImplicitElement> elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/lang/javascript/psi/stubs/impl/JSElementIndexingDataImpl", "addImplicitElements"));
        }
        if (this.myElements == null) {
            this.myElements = new SmartList();
        }
        this.myElements.addAll(elements);
    }

    @Nullable
    public Collection<JSImplicitElement> getImplicitElements() {
        return this.myElements;
    }

    public void setImplicitElements(@Nullable Collection<JSImplicitElement> elements) {
        this.myElements = elements;
    }

    public void addAccessorsFromObjectLiteral(@NotNull JSObjectLiteralExpression objectLiteral) {
        if (objectLiteral == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objectLiteral", "com/intellij/lang/javascript/psi/stubs/impl/JSElementIndexingDataImpl", "addAccessorsFromObjectLiteral"));
        }
        JSSymbolUtil.forEachIdentifierProperty(objectLiteral, new JSSymbolUtil.PropertyProcessor(){

            @Override
            public void process(String titleCasedPropName, JSProperty property) {
                JSImplicitElementImpl.Builder getterBuilder = new JSImplicitElementImpl.Builder(JSSymbolUtil.suggestGetterName(titleCasedPropName), (PsiElement)property).setProperties(JSImplicitElement.Property.GetFunction);
                JSElementIndexingDataImpl.this.addImplicitElement(getterBuilder.toImplicitElement());
                JSImplicitElementImpl.Builder setterBuilder = new JSImplicitElementImpl.Builder(JSSymbolUtil.suggestSetterName(titleCasedPropName), (PsiElement)property).setProperties(JSImplicitElement.Property.SetFunction);
                JSElementIndexingDataImpl.this.addImplicitElement(setterBuilder.toImplicitElement());
            }
        });
    }

    @Nullable
    public Collection<Pair<String, String>> getTypedefs() {
        return this.myTypedefs;
    }

    public void addTypedef(String name, String type) {
        if (this.myTypedefs == null) {
            this.myTypedefs = new SmartList();
        }
        this.myTypedefs.add((Pair<String, String>)Pair.create((Object)name, (Object)type));
    }

    public void setTypedefs(@Nullable Collection<Pair<String, String>> typedefs) {
        this.myTypedefs = typedefs;
    }

    @Nullable
    public Collection<Pair<String, String>> getBaseTypes() {
        return this.myBaseTypes;
    }

    public void addBaseType(@NotNull String qualifiedName, @NotNull String baseType) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/intellij/lang/javascript/psi/stubs/impl/JSElementIndexingDataImpl", "addBaseType"));
        }
        if (baseType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseType", "com/intellij/lang/javascript/psi/stubs/impl/JSElementIndexingDataImpl", "addBaseType"));
        }
        if (this.myBaseTypes == null) {
            this.myBaseTypes = new SmartList();
        }
        this.myBaseTypes.add((Pair<String, String>)Pair.create((Object)qualifiedName, (Object)baseType));
    }

    public void setBaseTypes(@Nullable Collection<Pair<String, String>> baseTypes) {
        this.myBaseTypes = baseTypes;
    }

    public boolean isClassExplicitly() {
        return this.myIsClassExplicitly;
    }

    public void setIsClassExplicitly() {
        this.myIsClassExplicitly = true;
    }

    public boolean isInterfaceExplicitly() {
        return this.myIsInterfaceExplicitly;
    }

    public void setIsInterfaceExplicitly() {
        this.myIsInterfaceExplicitly = true;
    }

    @Nullable
    public Map<String, String> getUserStrings() {
        return this.myUserStrings;
    }

    public void putUserString(@NotNull String key, @NotNull String value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/lang/javascript/psi/stubs/impl/JSElementIndexingDataImpl", "putUserString"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/lang/javascript/psi/stubs/impl/JSElementIndexingDataImpl", "putUserString"));
        }
        ourUserStringKeysRegisty.checkRegistered(key);
        if (this.myUserStrings == null) {
            this.myUserStrings = new THashMap(1);
        }
        this.myUserStrings.put(key, value);
    }

    public void setUserStrings(@Nullable Map<String, String> userStrings) {
        this.myUserStrings = userStrings;
    }

    public boolean isEmpty() {
        boolean hasImplicitElements = this.getImplicitElements() != null && !this.getImplicitElements().isEmpty();
        boolean hasTypedefs = this.getTypedefs() != null && !this.getTypedefs().isEmpty();
        boolean hasBaseTypes = this.getBaseTypes() != null && !this.getBaseTypes().isEmpty();
        boolean hasUserStrings = this.getUserStrings() != null && !this.getUserStrings().isEmpty();
        return !hasImplicitElements && !hasTypedefs && !hasBaseTypes && !hasUserStrings && !this.isClassExplicitly() && !this.isInterfaceExplicitly();
    }

    public JSElementIndexingDataStructureImpl toStructure() {
        List elements = this.myElements != null ? this.myElements.stream().map(JSImplicitElement::getStructure).collect(Collectors.toList()) : null;
        return new JSElementIndexingDataStructureImpl(elements, this.myTypedefs, this.myBaseTypes, this.myIsClassExplicitly, this.myIsInterfaceExplicitly, this.myUserStrings);
    }
}

