/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.convertToClass;

import com.intellij.lang.ecmascript6.psi.ES6Class;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamedElementBase;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSStatementExpressionOwner;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.refactoring.convertToClass.ClassInheritanceNode;
import com.intellij.lang.javascript.refactoring.convertToClass.JSConvertToClassProcessor;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.ContainerUtil;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class InheritanceBuilder {
    public static final String CALL = "call";
    public static final String APPLY = "apply";
    private String myExtendsTarget;
    private JSFunction myAncestor;
    private JSExpression myExtendsDeclaringExpression;
    private boolean myUsedAsError;
    @NotNull
    private final Set<JSFunction> myDescendants = new HashSet<JSFunction>();
    @NotNull
    private final Set<JSExpression> myInheritanceAssignments = new HashSet<JSExpression>();
    private final Map<JSExpression, JSNamedElementBase> myAllAncestors = new HashMap<JSExpression, JSNamedElementBase>();

    InheritanceBuilder() {
    }

    void extendFromDefaultsIfApplicable() {
        if (this.myExtendsTarget == null && this.myUsedAsError) {
            this.myExtendsTarget = "Error";
        }
    }

    public boolean hasBase() {
        return this.myUsedAsError || this.myExtendsTarget != null;
    }

    @NotNull
    public Set<JSExpression> getInheritanceAssignments() {
        Set<JSExpression> set = this.myInheritanceAssignments;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/refactoring/convertToClass/InheritanceBuilder", "getInheritanceAssignments"));
        }
        return set;
    }

    boolean tryToParseProtoAssignment(JSAssignmentExpression assignment) {
        PsiElement child;
        JSExpression initializer = InheritanceBuilder.getInitializer(assignment);
        return initializer instanceof JSReferenceExpression && "prototype".equals(((JSReferenceExpression)initializer).getReferenceName()) && (child = initializer.getFirstChild()) instanceof JSReferenceExpression && this.tryResolveBaseClass((JSReferenceExpression)child, (JSExpression)assignment);
    }

    private static JSExpression getInitializer(JSAssignmentExpression assignment) {
        return assignment.getDefinitionExpression().getInitializer();
    }

    private boolean tryToParseNewBaseInAssignment(@NotNull JSAssignmentExpression assignment) {
        JSExpression expression;
        if (assignment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "assignment", "com/intellij/lang/javascript/refactoring/convertToClass/InheritanceBuilder", "tryToParseNewBaseInAssignment"));
        }
        JSExpression initializer = InheritanceBuilder.getInitializer(assignment);
        return initializer instanceof JSNewExpression && (expression = ((JSNewExpression)initializer).getMethodExpression()) instanceof JSReferenceExpression && this.tryResolveBaseClass((JSReferenceExpression)expression, (JSExpression)assignment);
    }

    private boolean parseObjectCreate(@NotNull JSAssignmentExpression assignment, @NotNull PairConsumer<String, JSObjectLiteralExpression> propertyConsumer) {
        JSExpression methodExpression;
        if (assignment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "assignment", "com/intellij/lang/javascript/refactoring/convertToClass/InheritanceBuilder", "parseObjectCreate"));
        }
        if (propertyConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyConsumer", "com/intellij/lang/javascript/refactoring/convertToClass/InheritanceBuilder", "parseObjectCreate"));
        }
        JSExpression initializer = InheritanceBuilder.getInitializer(assignment);
        if (initializer instanceof JSCallExpression && JSConvertToClassProcessor.checkForObjectMethod(methodExpression = ((JSCallExpression)initializer).getMethodExpression(), "create")) {
            JSExpression child;
            JSExpression[] arguments = ((JSCallExpression)initializer).getArguments();
            if (arguments.length > 2) {
                return false;
            }
            ArrayList<Pair> definedProperties = new ArrayList<Pair>();
            if (arguments.length > 1) {
                JSProperty[] properties;
                if (!(arguments[0] instanceof JSReferenceExpression)) {
                    return false;
                }
                if (!(arguments[1] instanceof JSObjectLiteralExpression)) {
                    return false;
                }
                JSObjectLiteralExpression literal = (JSObjectLiteralExpression)arguments[1];
                for (JSProperty property : properties = literal.getProperties()) {
                    if (property.getValue() == null || !(property.getValue() instanceof JSObjectLiteralExpression)) {
                        return false;
                    }
                    definedProperties.add(Pair.create((Object)property.getName(), (Object)((JSObjectLiteralExpression)property.getValue())));
                }
            }
            if (!((child = ((JSReferenceExpression)arguments[0]).getQualifier()) instanceof JSReferenceExpression) || !this.tryResolveBaseClass((JSReferenceExpression)child, (JSExpression)assignment)) {
                return false;
            }
            if (!definedProperties.isEmpty()) {
                for (Pair property : definedProperties) {
                    propertyConsumer.consume(property.getFirst(), property.getSecond());
                }
            }
            return true;
        }
        return false;
    }

    private static boolean functionOrClass(@Nullable PsiElement resolved) {
        return resolved instanceof JSFunction || resolved instanceof ES6Class;
    }

    private boolean tryResolveBaseClass(JSReferenceExpression expression, @NotNull JSExpression assignment) {
        if (assignment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "assignment", "com/intellij/lang/javascript/refactoring/convertToClass/InheritanceBuilder", "tryResolveBaseClass"));
        }
        PsiElement resolved = JSChangeUtil.deepResolve(expression);
        if (InheritanceBuilder.functionOrClass(resolved)) {
            this.myAllAncestors.put(assignment, (JSNamedElementBase)resolved);
            this.myExtendsTarget = expression.getText();
            if (resolved instanceof JSFunction) {
                this.myAncestor = (JSFunction)resolved;
            }
            this.myExtendsDeclaringExpression = assignment;
            this.myInheritanceAssignments.add((JSExpression)expression);
            return true;
        }
        return false;
    }

    public Map<JSExpression, JSNamedElementBase> getAllAncestors() {
        return this.myAllAncestors;
    }

    public String getExtendsTarget() {
        return this.myExtendsTarget;
    }

    public JSFunction getAncestor() {
        return this.myAncestor;
    }

    public JSExpression getExtendsDeclaringExpression() {
        return this.myExtendsDeclaringExpression;
    }

    @NotNull
    public Set<JSFunction> getDescendants() {
        Set<JSFunction> set = this.myDescendants;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/refactoring/convertToClass/InheritanceBuilder", "getDescendants"));
        }
        return set;
    }

    public boolean tryToParsePrototypeAssignment(@NotNull JSAssignmentExpression assignment, @NotNull PairConsumer<String, JSObjectLiteralExpression> propertyConsumer) {
        if (assignment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "assignment", "com/intellij/lang/javascript/refactoring/convertToClass/InheritanceBuilder", "tryToParsePrototypeAssignment"));
        }
        if (propertyConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyConsumer", "com/intellij/lang/javascript/refactoring/convertToClass/InheritanceBuilder", "tryToParsePrototypeAssignment"));
        }
        if (this.tryToParseNewBaseInAssignment(assignment)) {
            return true;
        }
        return this.parseObjectCreate(assignment, propertyConsumer);
    }

    public boolean parseSetPrototype(@NotNull PsiReference topReference) {
        if (topReference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topReference", "com/intellij/lang/javascript/refactoring/convertToClass/InheritanceBuilder", "parseSetPrototype"));
        }
        if (!(topReference.getElement().getParent() instanceof JSArgumentList)) {
            return false;
        }
        JSArgumentList argumentList = (JSArgumentList)topReference.getElement().getParent();
        if (!(argumentList.getParent() instanceof JSCallExpression)) {
            return false;
        }
        JSCallExpression call = (JSCallExpression)argumentList.getParent();
        JSExpression methodExpression = call.getMethodExpression();
        if (JSConvertToClassProcessor.checkForObjectMethod(methodExpression, "setPrototypeOf")) {
            return this.checkPrototypeAssignmentHelperMethodParameters(topReference, call, true, true);
        }
        return false;
    }

    public boolean parseInheritsCall(@NotNull PsiReference topReference) {
        if (topReference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topReference", "com/intellij/lang/javascript/refactoring/convertToClass/InheritanceBuilder", "parseInheritsCall"));
        }
        return this.parseInheritsCall(topReference, true);
    }

    public boolean parseInheritsCall(@NotNull PsiReference topReference, boolean isDescendant) {
        if (topReference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topReference", "com/intellij/lang/javascript/refactoring/convertToClass/InheritanceBuilder", "parseInheritsCall"));
        }
        if (!(topReference.getElement().getParent() instanceof JSArgumentList)) {
            return false;
        }
        JSArgumentList argumentList = (JSArgumentList)topReference.getElement().getParent();
        if (!(argumentList.getParent() instanceof JSCallExpression)) {
            return false;
        }
        JSCallExpression call = (JSCallExpression)argumentList.getParent();
        if (ClassInheritanceNode.isNodeJSInheritsCall(call)) {
            return this.checkPrototypeAssignmentHelperMethodParameters(topReference, call, false, isDescendant);
        }
        return false;
    }

    private boolean checkPrototypeAssignmentHelperMethodParameters(@NotNull PsiReference topReference, @NotNull JSCallExpression call, boolean basePrototype, boolean isDescendant) {
        if (topReference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topReference", "com/intellij/lang/javascript/refactoring/convertToClass/InheritanceBuilder", "checkPrototypeAssignmentHelperMethodParameters"));
        }
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", CALL, "com/intellij/lang/javascript/refactoring/convertToClass/InheritanceBuilder", "checkPrototypeAssignmentHelperMethodParameters"));
        }
        JSExpression[] arguments = call.getArguments();
        if (arguments.length == 2) {
            int otherIdx;
            int ourIdx = isDescendant ? 0 : 1;
            int n = otherIdx = isDescendant ? 1 : 0;
            if (!topReference.equals(arguments[ourIdx])) {
                return false;
            }
            if (!(arguments[otherIdx] instanceof JSReferenceExpression)) {
                return false;
            }
            JSReferenceExpression secondReference = (JSReferenceExpression)arguments[otherIdx];
            String referenceName = secondReference.getReferenceName();
            if (basePrototype) {
                if (!"prototype".equals(referenceName)) {
                    return false;
                }
                JSExpression qualifier = secondReference.getQualifier();
                return qualifier instanceof JSReferenceExpression && this.tryResolveBaseClass((JSReferenceExpression)qualifier, (JSExpression)call);
            }
            return isDescendant ? this.tryResolveBaseClass(secondReference, (JSExpression)call) : this.resolveDescendantConstructorReference(secondReference);
        }
        return false;
    }

    public void findAndConvertSuperCalls(@NotNull JSFunction function, @NotNull Map<String, JSAssignmentExpression> declarations) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/lang/javascript/refactoring/convertToClass/InheritanceBuilder", "findAndConvertSuperCalls"));
        }
        if (declarations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarations", "com/intellij/lang/javascript/refactoring/convertToClass/InheritanceBuilder", "findAndConvertSuperCalls"));
        }
        this.extendFromDefaultsIfApplicable();
        if (StringUtil.isEmptyOrSpaces((String)this.myExtendsTarget)) {
            return;
        }
        this.convertSuperCallInConstructor(function);
        for (JSAssignmentExpression expression : declarations.values()) {
            if (expression.getDefinitionExpression() == null || !(InheritanceBuilder.getInitializer(expression) instanceof JSFunction)) continue;
            this.convertSuperCallsInFunction((JSFunction)InheritanceBuilder.getInitializer(expression));
        }
    }

    private void convertSuperCallsInFunction(@NotNull JSFunction function) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/lang/javascript/refactoring/convertToClass/InheritanceBuilder", "convertSuperCallsInFunction"));
        }
        Collection calls = PsiTreeUtil.findChildrenOfType((PsiElement)function, JSCallExpression.class);
        for (JSCallExpression call : calls) {
            List<String> parts;
            JSExpression methodExpression = call.getMethodExpression();
            if (!(methodExpression instanceof JSReferenceExpression) || (parts = InheritanceBuilder.rollDownReference((JSReferenceExpression)methodExpression)).size() != 4 || !this.myExtendsTarget.equals(parts.get(0)) || !"prototype".equals(parts.get(1))) continue;
            InheritanceBuilder.replaceWithSuperCall(function, call, parts.get(3), parts.get(2));
        }
    }

    public void usedAsError() {
        this.myUsedAsError = true;
    }

    private static List<String> rollDownReference(@NotNull JSReferenceExpression reference) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/lang/javascript/refactoring/convertToClass/InheritanceBuilder", "rollDownReference"));
        }
        ArrayList<String> list = new ArrayList<String>();
        JSReferenceExpression current = reference;
        while (current != null) {
            if (StringUtil.isEmptyOrSpaces((String)current.getReferenceName())) {
                return Collections.emptyList();
            }
            list.add(current.getReferenceName());
            current = current.getQualifier() instanceof JSReferenceExpression ? (JSReferenceExpression)current.getQualifier() : null;
        }
        Collections.reverse(list);
        return list;
    }

    private void convertSuperCallInConstructor(@NotNull JSFunction function) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/lang/javascript/refactoring/convertToClass/InheritanceBuilder", "convertSuperCallInConstructor"));
        }
        JSBlockStatement constructorBlock = (JSBlockStatement)PsiTreeUtil.getChildOfType((PsiElement)function, JSBlockStatement.class);
        if (constructorBlock != null) {
            Collection statements = PsiTreeUtil.findChildrenOfType((PsiElement)constructorBlock, JSStatementExpressionOwner.class);
            for (JSStatementExpressionOwner statement : statements) {
                String name;
                JSCallExpression call;
                JSExpression methodExpression;
                if (!(statement.getExpression() instanceof JSCallExpression) || !((methodExpression = (call = (JSCallExpression)statement.getExpression()).getMethodExpression()) instanceof JSReferenceExpression) || ((JSReferenceExpression)methodExpression).getQualifier() == null || !this.myExtendsTarget.equals(((JSReferenceExpression)methodExpression).getQualifier().getText()) || !InheritanceBuilder.replaceWithSuperCall(function, call, name = ((JSReferenceExpression)methodExpression).getReferenceName(), null)) continue;
                return;
            }
            JSStatement statement = (JSStatement)JSChangeUtil.createStatementFromText(function.getProject(), "super();").getPsi(JSStatement.class);
            if (statements.isEmpty()) {
                constructorBlock.add((PsiElement)statement);
            } else {
                constructorBlock.addBefore((PsiElement)statement, (PsiElement)statements.iterator().next());
            }
        }
    }

    private static boolean replaceWithSuperCall(@NotNull JSFunction function, @NotNull JSCallExpression call, @Nullable String callOrApplyName, @Nullable String methodName) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/lang/javascript/refactoring/convertToClass/InheritanceBuilder", "replaceWithSuperCall"));
        }
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", CALL, "com/intellij/lang/javascript/refactoring/convertToClass/InheritanceBuilder", "replaceWithSuperCall"));
        }
        Object[] arguments = call.getArguments();
        if (arguments.length == 0) {
            return false;
        }
        if (!(arguments[0] instanceof JSThisExpression)) {
            return false;
        }
        String newArguments = null;
        if (CALL.equals(callOrApplyName)) {
            newArguments = StringUtil.join(ContainerUtil.map((Object[])arguments, arg -> arg.getText()).subList(1, arguments.length), (String)", ");
        } else if (APPLY.equals(callOrApplyName)) {
            if (arguments.length == 2 && "arguments".equals(arguments[1].getText())) {
                newArguments = StringUtil.join((Collection)ContainerUtil.mapNotNull((Object[])function.getParameterVariables(), parameter -> parameter.getName()), (String)", ");
            } else if (arguments.length == 2 && arguments[1] instanceof JSArrayLiteralExpression) {
                JSArrayLiteralExpression array = (JSArrayLiteralExpression)arguments[1];
                newArguments = StringUtil.join((Collection)ContainerUtil.map((Object[])array.getExpressions(), arg -> arg.getText()), (String)", ");
            } else if (arguments.length == 1) {
                newArguments = "";
            }
        }
        if (newArguments != null) {
            JSExpressionStatement superStatement = (JSExpressionStatement)JSChangeUtil.createStatementFromText(function.getProject(), "super" + (methodName == null ? "" : "." + methodName) + "(" + newArguments + ");").getPsi(JSExpressionStatement.class);
            call.replace(superStatement.getExpression());
            return true;
        }
        return false;
    }

    public boolean usedAsBasePrototypeConstructor(@NotNull JSReferenceExpression reference) {
        JSExpression definition;
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/lang/javascript/refactoring/convertToClass/InheritanceBuilder", "usedAsBasePrototypeConstructor"));
        }
        JSNewExpression newExpression = (JSNewExpression)ObjectUtils.tryCast((Object)reference.getParent(), JSNewExpression.class);
        if (newExpression == null) {
            return false;
        }
        JSAssignmentExpression assignment = (JSAssignmentExpression)ObjectUtils.tryCast((Object)newExpression.getParent(), JSAssignmentExpression.class);
        return assignment != null && assignment.getDefinitionExpression() != null && newExpression.equals(assignment.getDefinitionExpression().getInitializer()) && this.resolveDescendantPrototypeReference(definition = assignment.getDefinitionExpression().getExpression());
    }

    private boolean resolveDescendantPrototypeReference(@Nullable JSExpression definition) {
        JSReferenceExpression expression;
        return definition instanceof JSReferenceExpression && "prototype".equals(((JSReferenceExpression)definition).getReferenceName()) && ((JSReferenceExpression)definition).getQualifier() instanceof JSReferenceExpression && this.resolveDescendantConstructorReference(expression = (JSReferenceExpression)((JSReferenceExpression)definition).getQualifier());
    }

    private boolean resolveDescendantConstructorReference(JSReferenceExpression expression) {
        PsiElement resolved = JSChangeUtil.deepResolve(expression);
        if (resolved instanceof JSFunction) {
            this.myDescendants.add((JSFunction)resolved);
            this.myInheritanceAssignments.add((JSExpression)expression);
            return true;
        }
        return false;
    }

    public boolean usedAsBaseInInheritsCall(@NotNull JSReferenceExpression reference) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/lang/javascript/refactoring/convertToClass/InheritanceBuilder", "usedAsBaseInInheritsCall"));
        }
        return this.parseInheritsCall((PsiReference)reference, false);
    }

    public boolean usedAsBaseInPrototypeAssignmentMethods(@NotNull JSReferenceExpression reference) {
        JSExpression expression;
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/lang/javascript/refactoring/convertToClass/InheritanceBuilder", "usedAsBaseInPrototypeAssignmentMethods"));
        }
        JSArgumentList argumentList = (JSArgumentList)ObjectUtils.tryCast((Object)reference.getParent(), JSArgumentList.class);
        if (argumentList == null) {
            return false;
        }
        int argLength = argumentList.getArguments().length;
        if (argLength == 0 || argLength > 2) {
            return false;
        }
        boolean isFirstArgument = argumentList.getArguments()[0].equals(reference);
        JSCallExpression call = (JSCallExpression)ObjectUtils.tryCast((Object)argumentList.getParent(), JSCallExpression.class);
        if (call == null) {
            return false;
        }
        JSExpression methodExpression = call.getMethodExpression();
        if (JSConvertToClassProcessor.checkForObjectMethod(methodExpression, "create") && isFirstArgument) {
            if (argLength == 2 && !(argumentList.getArguments()[1] instanceof JSObjectLiteralExpression)) {
                return false;
            }
            JSAssignmentExpression assignment = (JSAssignmentExpression)ObjectUtils.tryCast((Object)call.getParent(), JSAssignmentExpression.class);
            if (assignment == null) {
                return false;
            }
            if (assignment.getDefinitionExpression() == null || !call.equals(assignment.getDefinitionExpression().getInitializer())) {
                return false;
            }
            JSExpression expression2 = assignment.getDefinitionExpression().getExpression();
            if (this.resolveDescendantPrototypeReference(expression2)) {
                return true;
            }
        } else if (JSConvertToClassProcessor.checkForObjectMethod(methodExpression, "setPrototypeOf") && !isFirstArgument && argLength == 2 && this.resolveDescendantPrototypeReference(expression = argumentList.getArguments()[0])) {
            return true;
        }
        return false;
    }

    public boolean usedAsBaseInAssignment(@NotNull JSReferenceExpression reference) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/lang/javascript/refactoring/convertToClass/InheritanceBuilder", "usedAsBaseInAssignment"));
        }
        JSAssignmentExpression assignment = (JSAssignmentExpression)ObjectUtils.tryCast((Object)reference.getParent(), JSAssignmentExpression.class);
        if (assignment == null) {
            return false;
        }
        if (assignment.getDefinitionExpression() == null || !reference.equals(assignment.getDefinitionExpression().getInitializer())) {
            return false;
        }
        JSExpression expression = assignment.getDefinitionExpression().getExpression();
        if (expression instanceof JSReferenceExpression && "__proto__".equals(((JSReferenceExpression)expression).getReferenceName())) {
            return this.resolveDescendantPrototypeReference(((JSReferenceExpression)expression).getQualifier());
        }
        return false;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.METHOD})
    private static @interface UsedAsBase {
    }
}

