/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.convertToClass;

import com.intellij.find.findUsages.PsiElement2UsageTargetAdapter;
import com.intellij.icons.AllIcons;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSCommaExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.refactoring.convertToClass.ClassInheritanceNode;
import com.intellij.lang.javascript.refactoring.convertToClass.JSConvertToClassUsageViewDescriptor;
import com.intellij.lang.javascript.refactoring.convertToClass.JSItemToClassConvertor;
import com.intellij.lang.javascript.refactoring.convertToClass.JSItemToClassDataProcessor;
import com.intellij.lang.javascript.refactoring.convertToClass.SelectTargetsToConvertToClass;
import com.intellij.lang.javascript.ui.JSFormatUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.ui.ConflictsDialog;
import com.intellij.ui.components.JBLabel;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSConvertToClassProcessor
extends BaseRefactoringProcessor {
    public static final Logger LOG = Logger.getInstance((String)JSConvertToClassProcessor.class.getName());
    public static final String DEFINE_PROPERTY = "defineProperty";
    public static final String DEFINE_PROPERTIES = "defineProperties";
    public static final String CREATE = "create";
    public static final String SET_PROTOTYPE = "setPrototypeOf";
    public static final Set<String> OBJECT_METHODS = ContainerUtil.set((Object[])new String[]{"defineProperties", "defineProperty", "create", "setPrototypeOf"});
    private final ClassInheritanceNode myRoot;
    private ClassInheritanceNode[] mySelectedNodes;
    private boolean myGenerateTheWholeTree;
    private Map<PsiElement, Integer> myConflictsOrder;

    public JSConvertToClassProcessor(@NotNull Project project, @Nullable Runnable prepareSuccessfulCallback, @NotNull JSFunction function) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/refactoring/convertToClass/JSConvertToClassProcessor", "<init>"));
        }
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/lang/javascript/refactoring/convertToClass/JSConvertToClassProcessor", "<init>"));
        }
        super(project, prepareSuccessfulCallback);
        this.myRoot = new ClassInheritanceNode(function);
        this.myConflictsOrder = new HashMap<PsiElement, Integer>();
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/lang/javascript/refactoring/convertToClass/JSConvertToClassProcessor", "createUsageViewDescriptor"));
        }
        JSConvertToClassUsageViewDescriptor jSConvertToClassUsageViewDescriptor = new JSConvertToClassUsageViewDescriptor(this.mySelectedNodes);
        if (jSConvertToClassUsageViewDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/refactoring/convertToClass/JSConvertToClassProcessor", "createUsageViewDescriptor"));
        }
        return jSConvertToClassUsageViewDescriptor;
    }

    @NotNull
    protected UsageInfo[] findUsages() {
        this.myRoot.findUsages();
        UsageInfo[] usageInfoArray = this.myRoot.getInfos();
        if (usageInfoArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/refactoring/convertToClass/JSConvertToClassProcessor", "findUsages"));
        }
        return usageInfoArray;
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refUsages", "com/intellij/lang/javascript/refactoring/convertToClass/JSConvertToClassProcessor", "preprocessUsages"));
        }
        MultiMap conflicts = new MultiMap();
        this.myRoot.process(null, true, new HashSet<JSFunction>());
        if (!this.selectNodes(refUsages)) {
            return false;
        }
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            Arrays.sort(this.mySelectedNodes, Comparator.comparing(o -> o.getFunction().getQualifiedName()));
            for (ClassInheritanceNode node : this.mySelectedNodes) {
                conflicts.putAllValues(node.getConflicts());
                for (PsiElement element : node.getConflictShowOrder()) {
                    this.myConflictsOrder.put(element, this.myConflictsOrder.size());
                }
            }
        }
        return this.showConflicts(conflicts, (UsageInfo[])refUsages.get());
    }

    @NotNull
    protected ConflictsDialog createConflictsDialog(@NotNull MultiMap<PsiElement, String> conflicts, @Nullable UsageInfo[] usages) {
        if (conflicts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conflicts", "com/intellij/lang/javascript/refactoring/convertToClass/JSConvertToClassProcessor", "createConflictsDialog"));
        }
        ConflictsDialog conflictsDialog = new ConflictsDialog(this.myProject, conflicts, usages == null ? null : () -> this.execute(usages), false, true){

            protected void init() {
                HashMap map = new HashMap();
                for (Map.Entry entry : this.myElementConflictDescription.entrySet()) {
                    for (String s : (Collection)entry.getValue()) {
                        map.put(s, entry.getKey());
                    }
                }
                Arrays.sort(this.myConflictDescriptions, Comparator.comparing(o -> {
                    PsiElement key = (PsiElement)map.get(o);
                    return key == null ? Integer.valueOf(0) : (JSConvertToClassProcessor.this.myConflictsOrder.containsKey(key) ? (Integer)JSConvertToClassProcessor.this.myConflictsOrder.get(key) : Integer.valueOf(0));
                }));
                super.init();
            }
        };
        if (conflictsDialog == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/refactoring/convertToClass/JSConvertToClassProcessor", "createConflictsDialog"));
        }
        return conflictsDialog;
    }

    private boolean selectNodes(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refUsages", "com/intellij/lang/javascript/refactoring/convertToClass/JSConvertToClassProcessor", "selectNodes"));
        }
        if (ApplicationManager.getApplication().isUnitTestMode() && !this.myGenerateTheWholeTree) {
            this.mySelectedNodes = new ClassInheritanceNode[]{this.myRoot};
            return true;
        }
        if (this.myRoot.getParent() != null || !this.myRoot.getDescendants().isEmpty()) {
            SelectTargetsToConvertToClass selector = new SelectTargetsToConvertToClass(this.myRoot);
            selector.setSelectAll(this.myRoot.hasInheritanceConflicts());
            selector.process();
            this.mySelectedNodes = selector.getCheckedNodes();
            if (this.mySelectedNodes == null) {
                return false;
            }
        } else {
            this.mySelectedNodes = new ClassInheritanceNode[]{this.myRoot};
        }
        this.filterUsages(refUsages);
        return true;
    }

    private void filterUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refUsages", "com/intellij/lang/javascript/refactoring/convertToClass/JSConvertToClassProcessor", "filterUsages"));
        }
        ArrayList filteredUsages = new ArrayList();
        for (ClassInheritanceNode node : this.mySelectedNodes) {
            Set<JSExpression> assignments = node.getDataProcessor().getInheritanceBuilder().getInheritanceAssignments();
            List<UsageInfo> notConvertedWithoutDuplicates = node.getDataProcessor().getConversionResults().getNotConvertedWithoutDuplicates();
            List list = ContainerUtil.filter((Object[])node.getInfos(), t -> {
                if (notConvertedWithoutDuplicates.contains(t)) {
                    return false;
                }
                JSSourceElement sourceElement = (JSSourceElement)PsiTreeUtil.getParentOfType((PsiElement)t.getElement(), JSSourceElement.class);
                if (sourceElement == null) {
                    return true;
                }
                for (JSExpression assignment : assignments) {
                    if (!PsiTreeUtil.isAncestor((PsiElement)sourceElement, (PsiElement)assignment, (boolean)false)) continue;
                    return false;
                }
                return true;
            });
            filteredUsages.addAll(list);
        }
        refUsages.set((Object)filteredUsages.toArray(UsageInfo.EMPTY_ARRAY));
    }

    protected boolean isPreviewUsages(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/lang/javascript/refactoring/convertToClass/JSConvertToClassProcessor", "isPreviewUsages"));
        }
        return usages.length > 0;
    }

    protected void customizeUsagesView(@NotNull UsageViewDescriptor viewDescriptor, @NotNull UsageView usageView) {
        if (viewDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewDescriptor", "com/intellij/lang/javascript/refactoring/convertToClass/JSConvertToClassProcessor", "customizeUsagesView"));
        }
        if (usageView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageView", "com/intellij/lang/javascript/refactoring/convertToClass/JSConvertToClassProcessor", "customizeUsagesView"));
        }
        super.customizeUsagesView(viewDescriptor, usageView);
        UsageViewPresentation presentation = usageView.getPresentation();
        presentation.setShowCancelButton(true);
        presentation.setTargetsNodeText("Function to be converted to class");
        presentation.setCodeUsagesString("Declarations of function members to be converted to class members");
        presentation.setToolwindowTitle("Convert to class");
        presentation.setTabText("refactoring preview");
        if (this.containsReflectionProperties()) {
            JPanel panel = new JPanel(new GridBagLayout());
            JTextArea area = new JTextArea(JSBundle.message((String)"javascript.refactoring.function.to.es6.class.defineProperty.warning.text", (Object[])new Object[0]));
            area.setFont(UIUtil.getLabelFont());
            area.setLineWrap(true);
            area.setOpaque(false);
            JBLabel label = new JBLabel(AllIcons.General.BalloonWarning, 2);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.ipadx = JBUI.scale((int)5);
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.gridx = 0;
            gbc.gridy = 0;
            panel.add((Component)label, gbc);
            ++gbc.gridx;
            gbc.weightx = 1.0;
            gbc.fill = 2;
            panel.add((Component)area, gbc);
            panel.setBackground(MessageType.WARNING.getPopupBackground());
            usageView.setAdditionalComponent((JComponent)panel);
        }
    }

    private boolean containsReflectionProperties() {
        for (ClassInheritanceNode node : this.mySelectedNodes) {
            for (UsageInfo info : node.getInfos()) {
                JSSourceElement sourceElement;
                PsiReference reference = info.getReference();
                if (!(reference instanceof JSReferenceExpression) || (sourceElement = (JSSourceElement)PsiTreeUtil.getParentOfType((PsiElement)((JSReferenceExpression)reference), JSSourceElement.class)) == null) continue;
                Collection expressions = PsiTreeUtil.findChildrenOfType((PsiElement)sourceElement, JSCallExpression.class);
                for (JSCallExpression expression : expressions) {
                    if (expression.getMethodExpression() == null || !JSConvertToClassProcessor.checkForObjectMethod(expression.getMethodExpression(), ContainerUtil.set((Object[])new String[]{DEFINE_PROPERTY, DEFINE_PROPERTIES, CREATE}))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/lang/javascript/refactoring/convertToClass/JSConvertToClassProcessor", "performRefactoring"));
        }
        ArrayList<PsiElement> replaced = new ArrayList<PsiElement>();
        ArrayList<UsageInfo> notConvertedUsages = new ArrayList<UsageInfo>();
        for (ClassInheritanceNode node : this.mySelectedNodes) {
            JSItemToClassDataProcessor processor = node.getDataProcessor();
            JSItemToClassConvertor convertor = new JSItemToClassConvertor(processor);
            notConvertedUsages.addAll(convertor.process(ContainerUtil.mapNotNull((Object[])usages, usage -> usage.getElement())));
            replaced.add(JSConvertToClassProcessor.replaceWithClassElement(convertor, node.getFunction()));
        }
        ApplicationManager.getApplication().invokeLater(() -> this.showNotConverted(notConvertedUsages, replaced));
    }

    public void generateTheWholeTree() {
        this.myGenerateTheWholeTree = true;
    }

    private static PsiElement replaceWithClassElement(JSItemToClassConvertor convertor, JSFunction function) {
        JSStatement statement;
        PsiElement replace = null;
        if (function.getParent() instanceof JSVariable) {
            JSStatement statement2 = (JSStatement)PsiTreeUtil.getParentOfType((PsiElement)function, JSStatement.class);
            if (statement2 != null) {
                replace = statement2.getParent().addBefore((PsiElement)convertor.getClazz(), (PsiElement)statement2);
                JSVariable parent = (JSVariable)function.getParent();
                parent.delete();
            }
        } else if (function.getParent() instanceof JSAssignmentExpression && (statement = (JSStatement)PsiTreeUtil.getParentOfType((PsiElement)function, JSStatement.class)) != null) {
            replace = statement.getParent().addBefore((PsiElement)convertor.getClazz(), (PsiElement)statement);
            JSConvertToClassProcessor.removeExpression(null, (JSExpression)((JSAssignmentExpression)function.getParent()));
        }
        if (replace == null) {
            replace = function.replace((PsiElement)convertor.getClazz());
        }
        return replace;
    }

    private void showNotConverted(List<UsageInfo> list, Collection<PsiElement> replace) {
        if (list.isEmpty()) {
            return;
        }
        UsageViewPresentation presentation = new UsageViewPresentation();
        presentation.setShowCancelButton(false);
        presentation.setTargetsNodeText("Function converted to class");
        presentation.setCodeUsagesString("Declarations that were not converted");
        presentation.setToolwindowTitle("Convert to class");
        presentation.setTabText("Refactoring Result");
        List usages = ContainerUtil.map(list, info -> new UsageInfo2UsageAdapter(info));
        UsageViewManager.getInstance((Project)this.myProject).showUsages((UsageTarget[])ContainerUtil.map2Array(replace, UsageTarget.class, item -> new PsiElement2UsageTargetAdapter(item)), usages.toArray(Usage.EMPTY_ARRAY), presentation);
    }

    public static void removeExpression(@Nullable String name, @NotNull JSExpression expression) {
        JSExpression[] arguments;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/lang/javascript/refactoring/convertToClass/JSConvertToClassProcessor", "removeExpression"));
        }
        if (expression instanceof JSCallExpression && JSConvertToClassProcessor.checkForObjectMethod(((JSCallExpression)expression).getMethodExpression(), ContainerUtil.set((Object[])new String[]{DEFINE_PROPERTIES, CREATE})) && (arguments = ((JSCallExpression)expression).getArguments()).length == 2 && arguments[1] instanceof JSObjectLiteralExpression) {
            JSObjectLiteralExpression object = (JSObjectLiteralExpression)arguments[1];
            JSProperty property = object.findProperty(name);
            if (property != null) {
                property.delete();
            }
            if (object.getProperties().length != 0) {
                return;
            }
        }
        if (expression.getParent() instanceof JSCommaExpression) {
            JSCommaExpression comma = (JSCommaExpression)expression.getParent();
            JSExpression other = comma.getLOperand() == expression ? comma.getROperand() : comma.getLOperand();
            comma.replace((PsiElement)other);
        } else if (expression.getParent() instanceof JSExpressionStatement) {
            expression.getParent().delete();
        } else {
            expression.getParent().deleteChildRange((PsiElement)expression, (PsiElement)expression);
        }
    }

    @Nullable
    protected RefactoringEventData getAfterData(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/lang/javascript/refactoring/convertToClass/JSConvertToClassProcessor", "getAfterData"));
        }
        return super.getAfterData(usages);
    }

    static PsiReference getTopReference(@NotNull PsiReference reference) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/lang/javascript/refactoring/convertToClass/JSConvertToClassProcessor", "getTopReference"));
        }
        if (!(reference instanceof PsiElement)) {
            return null;
        }
        PsiElement current = (PsiElement)reference;
        while (current instanceof JSReferenceExpression) {
            if (!(current.getParent() instanceof PsiReference)) {
                return (PsiReference)current;
            }
            current = current.getParent();
        }
        return null;
    }

    static boolean checkForObjectMethod(@NotNull JSExpression methodExpression, @NotNull String name) {
        if (methodExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodExpression", "com/intellij/lang/javascript/refactoring/convertToClass/JSConvertToClassProcessor", "checkForObjectMethod"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/refactoring/convertToClass/JSConvertToClassProcessor", "checkForObjectMethod"));
        }
        return JSConvertToClassProcessor.checkForObjectMethod(methodExpression, ContainerUtil.set((Object[])new String[]{name}));
    }

    static boolean checkForObjectMethod(@NotNull JSExpression methodExpression, @NotNull Set<String> names) {
        if (methodExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodExpression", "com/intellij/lang/javascript/refactoring/convertToClass/JSConvertToClassProcessor", "checkForObjectMethod"));
        }
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/intellij/lang/javascript/refactoring/convertToClass/JSConvertToClassProcessor", "checkForObjectMethod"));
        }
        return methodExpression instanceof JSReferenceExpression && names.contains(((JSReferenceExpression)methodExpression).getReferenceName()) && ((JSReferenceExpression)methodExpression).getQualifier() != null && "Object".equals(((JSReferenceExpression)methodExpression).getQualifier().getText());
    }

    protected String getCommandName() {
        return JSBundle.message((String)"javascript.refactoring.function.to.es6.class.command", (Object[])new Object[]{JSFormatUtil.formatMethod(this.myRoot.getFunction(), 1, 0)});
    }
}

