/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation;

import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.Function;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FunctionCollector {
    private final Map<String, Object> functions = new LinkedHashMap<String, Object>();

    public static FunctionCollector collectAllVisibleClassFunctions(JSClass jsClass, FunctionCollector _functions, final @Nullable Function<JSFunction, Boolean> filter) {
        final FunctionCollector functions = _functions != null ? _functions : new FunctionCollector();
        jsClass.processDeclarations((PsiScopeProcessor)new ResolveProcessor(null){
            {
                super(name);
                this.setToProcessHierarchy(true);
                this.setLocalResolve(true);
                this.setSkipImplicitDeclarations(true);
            }

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/validation/FunctionCollector$1", "execute"));
                }
                if (state == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/validation/FunctionCollector$1", "execute"));
                }
                if (element instanceof JSFunction) {
                    Boolean filterValue;
                    JSFunction function = (JSFunction)element;
                    if (function.isConstructor()) {
                        return true;
                    }
                    if (filter != null && (filterValue = (Boolean)filter.fun((Object)function)) != null && !filterValue.booleanValue()) {
                        return true;
                    }
                    if (function instanceof TypeScriptFunction && ((TypeScriptFunction)function).isOverloadDeclaration()) {
                        return true;
                    }
                    functions.add(function);
                }
                return true;
            }
        }, ResolveState.initial(), (PsiElement)jsClass, (PsiElement)jsClass);
        return functions;
    }

    public JSFunction findFunctionWithTheSameKind(String name, JSFunction.FunctionKind kind) {
        Object o = this.functions.get(name);
        if (o instanceof JSFunction && ((JSFunction)o).getKind() != kind) {
            o = null;
        } else if (o instanceof JSFunction[]) {
            JSFunction[] jsFunctions = (JSFunction[])o;
            o = null;
            for (JSFunction fun : jsFunctions) {
                if (fun.getKind() != kind) continue;
                o = fun;
                break;
            }
        }
        return (JSFunction)o;
    }

    public void add(JSFunction function) {
        String s = function.getName();
        Object function1 = this.functions.get(s);
        if (function1 == null) {
            this.functions.put(s, function);
        } else if (function1 instanceof JSFunction) {
            JSFunction function2 = (JSFunction)function1;
            if (this.findFunctionWithTheSameKind(s, function.getKind()) == null) {
                this.functions.put(s, new JSFunction[]{function2, function});
            }
        }
    }

    public void removeFunctionByNameAndKind(String name, JSFunction.FunctionKind kind) {
        Object o = this.functions.get(name);
        if (o instanceof JSFunction && ((JSFunction)o).getKind() == kind) {
            this.functions.remove(name);
        } else if (o instanceof JSFunction[]) {
            JSFunction[] functions = (JSFunction[])o;
            this.functions.put(name, functions[0].getKind() == kind ? functions[1] : functions[0]);
        }
    }

    public Collection<JSFunction> getFunctions() {
        ArrayList<JSFunction> result = new ArrayList<JSFunction>();
        for (Map.Entry<String, Object> entry : this.functions.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof JSFunction[]) {
                for (JSFunction function : (JSFunction[])value) {
                    result.add(function);
                }
                continue;
            }
            result.add((JSFunction)value);
        }
        return result;
    }

    public boolean hasFunctionWithTheSameKind(String name, JSFunction.FunctionKind kind) {
        return this.findFunctionWithTheSameKind(name, kind) != null;
    }
}

