/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttribute;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeNameValuePair;
import com.intellij.lang.javascript.psi.ecmal4.JSConditionalCompileVariableReference;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSAttributeListStub;
import com.intellij.lang.javascript.refactoring.JSVisibilityUtil;
import com.intellij.lang.typescript.formatter.TypeScriptCodeStyleSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSAttributeListWrapper {
    public static final JSAttributeList.ModifierType[] MODIFIERS = new JSAttributeList.ModifierType[]{JSAttributeList.ModifierType.DECLARE, JSAttributeList.ModifierType.OVERRIDE, JSAttributeList.ModifierType.VIRTUAL, JSAttributeList.ModifierType.STATIC, JSAttributeList.ModifierType.ABSTRACT, JSAttributeList.ModifierType.FINAL, JSAttributeList.ModifierType.NATIVE, JSAttributeList.ModifierType.DYNAMIC};
    @Nullable
    private final JSAttributeList myAttributeList;
    @Nullable
    private JSAttributeList.AccessType myAccessTypeOverride;
    private final Map<JSAttributeList.ModifierType, Boolean> myModifiers = new HashMap<JSAttributeList.ModifierType, Boolean>();
    @Nullable
    private String myNamespace;
    private final List<Attribute> myAdditionalAttributes = new ArrayList<Attribute>();
    private boolean myRemoveOriginalAttributes;
    private boolean myNullAccessModifier;
    private static final Function<JSAttributeNameValuePair, Pair<String, String>> VALUE_MAPPER = pair -> Pair.create((Object)pair.getName(), (Object)pair.getSimpleValue());
    private static final Function<JSAttribute, Attribute> ATTRIBUTE_MAPPER = jsAttribute -> new Attribute(jsAttribute.getName(), ContainerUtil.map((Object[])jsAttribute.getValues(), VALUE_MAPPER));

    @Nullable
    public String getConditionalCompileVariableReference() {
        if (this.myAttributeList == null) {
            return null;
        }
        JSConditionalCompileVariableReference ref = this.myAttributeList.getConditionalCompileVariableReference();
        return ref != null ? ref.getText() : null;
    }

    public JSAttributeListWrapper(@Nullable JSAttributeList attributeList) {
        this.myAttributeList = attributeList;
    }

    public void overrideAccessType(@NotNull JSAttributeList.AccessType accessTypeOverride) {
        if (accessTypeOverride == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessTypeOverride", "com/intellij/lang/javascript/validation/fixes/JSAttributeListWrapper", "overrideAccessType"));
        }
        this.myAccessTypeOverride = accessTypeOverride;
        this.myNamespace = null;
        this.myNullAccessModifier = false;
    }

    public void overrideNamespace(@NotNull String namespace) {
        if (namespace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/intellij/lang/javascript/validation/fixes/JSAttributeListWrapper", "overrideNamespace"));
        }
        this.myNamespace = namespace;
        this.myAccessTypeOverride = null;
        this.myNullAccessModifier = false;
    }

    public void removeAccessModifier() {
        this.myNullAccessModifier = true;
    }

    private JSAttributeList.AccessType getAccessType() {
        if (this.myNullAccessModifier) {
            return null;
        }
        if (this.myAccessTypeOverride != null) {
            return this.myAccessTypeOverride;
        }
        if (this.myNamespace != null) {
            return null;
        }
        return this.myAttributeList != null ? this.myAttributeList.getExplicitAccessType() : null;
    }

    @Nullable
    private String getNamespace() {
        if (this.myNullAccessModifier) {
            return null;
        }
        if (this.myNamespace != null) {
            return this.myNamespace;
        }
        if (this.myAccessTypeOverride != null) {
            return null;
        }
        return this.myAttributeList != null ? this.myAttributeList.getNamespace() : null;
    }

    private boolean hasModifier(JSAttributeList.ModifierType modifierType) {
        Boolean flag = this.myModifiers.get(modifierType);
        if (flag != null) {
            return flag;
        }
        if (this.myAttributeList == null) {
            return false;
        }
        JSAttributeListStub stub = (JSAttributeListStub)this.myAttributeList.getStub();
        return stub != null ? stub.hasModifier(modifierType) : this.myAttributeList.hasExplicitModifier(modifierType);
    }

    public void overrideModifiers(boolean exists, JSAttributeList.ModifierType ... modifierTypes) {
        for (JSAttributeList.ModifierType modifierType : modifierTypes) {
            this.overrideModifier(modifierType, exists);
        }
    }

    public void overrideModifier(JSAttributeList.ModifierType modifierType, boolean exists) {
        this.myModifiers.put(modifierType, exists);
    }

    @Nullable
    public String getNamespaceValue() {
        return this.myAttributeList != null ? JSResolveUtil.getNamespaceValue(this.myAttributeList) : null;
    }

    public void addAttribute(String name, String valueName, String value) {
        this.myAdditionalAttributes.add(new Attribute(name, Collections.singletonList(Pair.create((Object)valueName, (Object)value))));
    }

    private List<Attribute> getAttributes() {
        ArrayList<Attribute> result = new ArrayList<Attribute>();
        if (this.myAttributeList != null && !this.myRemoveOriginalAttributes) {
            result.addAll(ContainerUtil.map((Object[])this.myAttributeList.getAttributes(), ATTRIBUTE_MAPPER));
        }
        result.addAll(this.myAdditionalAttributes);
        return result;
    }

    public String computeText(@NotNull PsiElement context) {
        JSAttributeList.AccessType accessType;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/validation/fixes/JSAttributeListWrapper", "computeText"));
        }
        StringBuilder result = new StringBuilder();
        for (Attribute attribute : this.getAttributes()) {
            JSAttributeListWrapper.appendWithSpace(result, "[");
            result.append(attribute.name);
            if (attribute.getSimpleValue() != null) {
                result.append("(\"").append(attribute.getSimpleValue()).append("\")");
            } else if (!attribute.nameValuePairs.isEmpty()) {
                result.append("(");
                for (int i = 0; i < attribute.nameValuePairs.size(); ++i) {
                    if (i > 0) {
                        result.append(",");
                    }
                    Pair<String, String> value = attribute.nameValuePairs.get(i);
                    result.append((String)value.first).append("=\"").append((String)value.second).append("\"");
                }
                result.append(")");
            }
            result.append("]");
        }
        String compileVariableReference = this.getConditionalCompileVariableReference();
        if (compileVariableReference != null) {
            JSAttributeListWrapper.appendWithSpace(result, compileVariableReference);
        }
        if (this.hasModifier(JSAttributeList.ModifierType.OVERRIDE)) {
            JSAttributeListWrapper.appendWithSpace(result, JSAttributeList.ModifierType.OVERRIDE.keyword);
        }
        if ((accessType = this.getAccessType()) != null) {
            String keyword = JSVisibilityUtil.getVisibilityKeyword(accessType);
            if (this.isNeedAccessKeyword(accessType, context)) {
                JSAttributeListWrapper.appendWithSpace(result, keyword);
            }
        } else {
            String namespace = this.getNamespace();
            if (namespace != null) {
                JSAttributeListWrapper.appendWithSpace(result, namespace);
            }
        }
        for (JSAttributeList.ModifierType modifier : MODIFIERS) {
            if (modifier == JSAttributeList.ModifierType.OVERRIDE || !this.hasModifier(modifier)) continue;
            JSAttributeListWrapper.appendWithSpace(result, modifier.keyword);
        }
        return result.toString();
    }

    private boolean isNeedAccessKeyword(JSAttributeList.AccessType accessType, PsiElement context) {
        DialectOptionHolder holder;
        DialectOptionHolder dialectOptionHolder = holder = context == null ? null : DialectDetector.dialectOfElement(context);
        if (holder != null && holder.isECMA6) {
            return false;
        }
        if (this.myAttributeList == null || accessType != JSAttributeList.AccessType.PUBLIC || holder != null && holder.isECMA4) {
            return true;
        }
        return this.myAttributeList.getExplicitAccessType() == JSAttributeList.AccessType.PUBLIC || TypeScriptCodeStyleSettings.getTypeScriptSettings((Project)this.myAttributeList.getProject()).USE_PUBLIC_MODIFIER;
    }

    public void removeOriginalAttributes() {
        this.myRemoveOriginalAttributes = true;
    }

    public void applyTo(JSAttributeListOwner element) {
        JSAttributeList attributeList = element.getAttributeList();
        String text = this.computeText((PsiElement)element);
        JSAttributeListOwner el = element;
        if (el instanceof JSVariable) {
            el = el.getParent();
        }
        if (text.length() > 0) {
            PsiElement insertBefore;
            PsiElement newAttributeList = JSChangeUtil.createJSTreeFromText(element.getProject(), text + " ", JavaScriptSupportLoader.ECMA_SCRIPT_L4).getPsi();
            if (attributeList.getFirstChild() == null) {
                insertBefore = attributeList.getNextSibling();
                attributeList.delete();
            } else {
                insertBefore = attributeList.getNextSibling().getNextSibling();
                el.deleteChildRange((PsiElement)attributeList, attributeList.getNextSibling());
            }
            el.addRangeBefore(newAttributeList, newAttributeList.getNextSibling(), insertBefore);
        } else if (attributeList.getFirstChild() != null) {
            el.deleteChildRange((PsiElement)attributeList, attributeList.getNextSibling());
        }
    }

    private static void appendWithSpace(StringBuilder s, String text) {
        if (s.length() > 0) {
            s.append(" ");
        }
        s.append(text);
    }

    private static class Attribute {
        public final String name;
        public final List<Pair<String, String>> nameValuePairs;

        @Nullable
        public String getSimpleValue() {
            return this.nameValuePairs.size() == 1 && this.nameValuePairs.get((int)0).first == null ? (String)this.nameValuePairs.get((int)0).second : null;
        }

        public Attribute(String name, List<Pair<String, String>> nameValuePairs) {
            this.name = name;
            this.nameValuePairs = Collections.unmodifiableList(nameValuePairs);
        }
    }
}

