/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.languageService.protocol;

import com.intellij.lang.javascript.service.JSLanguageServiceDefaultCacheData;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceCommand;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceObject;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceSimpleCommand;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerConfigUtil;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptCloseEditorCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptFileObject;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptLanguageServiceUpdateFilesCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptOpenEditorCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptUpdateFilesContent;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class TypeScriptLanguageServiceCacheImpl
extends JSLanguageServiceDefaultCacheData {
    private final Project myProject;
    private final Map<String, Long> myUpdateTimeStamps = ContainerUtil.newConcurrentMap();
    private Set<VirtualFile> myOpenedFiles = ContainerUtil.newConcurrentSet();
    private Set<String> myLastModifiedFiles = ContainerUtil.newConcurrentSet();

    public TypeScriptLanguageServiceCacheImpl(Project project) {
        this.myProject = project;
    }

    @Override
    public synchronized JSLanguageServiceObject updateCacheAndGetServiceObject(@NotNull JSLanguageServiceCommand input) {
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/intellij/lang/typescript/compiler/languageService/protocol/TypeScriptLanguageServiceCacheImpl", "updateCacheAndGetServiceObject"));
        }
        if (input instanceof TypeScriptLanguageServiceUpdateFilesCommand) {
            return this.getUpdateFilesServiceObject((TypeScriptLanguageServiceUpdateFilesCommand)input);
        }
        if (input instanceof JSLanguageServiceSimpleCommand) {
            if (input instanceof TypeScriptOpenEditorCommand) {
                this.myOpenedFiles.add(((TypeScriptOpenEditorCommand)input).getFile());
            }
            if (input instanceof TypeScriptCloseEditorCommand) {
                TypeScriptCloseEditorCommand command = (TypeScriptCloseEditorCommand)input;
                String filePath = ((TypeScriptFileObject)command.arguments).file;
                this.myOpenedFiles.remove(command.getFile());
                this.myUpdateTimeStamps.remove(filePath);
                this.myLastModifiedFiles.add(filePath);
            }
            return ((JSLanguageServiceSimpleCommand)input).toSerializableObject();
        }
        return null;
    }

    private Set<String> getOpenedFilePaths() {
        return this.myOpenedFiles.stream().map(el -> TypeScriptCompilerConfigUtil.normalizeNameAndPath(el)).collect(Collectors.toSet());
    }

    private JSLanguageServiceObject getUpdateFilesServiceObject(@NotNull TypeScriptLanguageServiceUpdateFilesCommand command) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/lang/typescript/compiler/languageService/protocol/TypeScriptLanguageServiceCacheImpl", "getUpdateFilesServiceObject"));
        }
        HashMap newToUpdateChangedFiles = ContainerUtil.newHashMap();
        Map<String, Long> changedFiles = command.myChangedFilesToTimeStamp;
        Map<String, Document> unsavedContents = command.myUnsavedFilesContent;
        Set<String> openedFilePaths = this.getOpenedFilePaths();
        HashSet filesToReloadContentFromDisk = ContainerUtil.newHashSet();
        for (String string : this.myLastModifiedFiles) {
            if (changedFiles.containsKey(string) || openedFilePaths.contains(string)) continue;
            filesToReloadContentFromDisk.add(string);
            this.myUpdateTimeStamps.remove(string);
        }
        this.myLastModifiedFiles.clear();
        this.myLastModifiedFiles.addAll(changedFiles.keySet());
        for (Map.Entry entry : changedFiles.entrySet()) {
            String path = (String)entry.getKey();
            Document content = unsavedContents.get(path);
            if (content == null) continue;
            if ((Long)entry.getValue() < 0L) {
                newToUpdateChangedFiles.put(path, content.getText());
                this.myUpdateTimeStamps.remove(path);
                continue;
            }
            long fixedModifiedStamp = (Long)entry.getValue();
            Long timeStamp = this.myUpdateTimeStamps.get(path);
            if (timeStamp != null && fixedModifiedStamp == timeStamp) continue;
            newToUpdateChangedFiles.put(path, content.getText());
            this.myUpdateTimeStamps.put(path, (Long)entry.getValue());
        }
        return newToUpdateChangedFiles.isEmpty() && filesToReloadContentFromDisk.isEmpty() ? null : new TypeScriptUpdateFilesContent(newToUpdateChangedFiles, filesToReloadContentFromDisk);
    }

    @Override
    public void dispose() {
        this.clear();
        this.myOpenedFiles.clear();
    }

    @Override
    public void clear() {
        this.myUpdateTimeStamps.clear();
    }
}

