/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.formatter;

import com.intellij.formatting.Spacing;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.formatter.JSSpacingProcessor;
import com.intellij.lang.javascript.formatter.JavascriptFormattingModelBuilder;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptFunctionImpl;
import com.intellij.lang.typescript.TypeScriptElementTypes;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.tree.IElementType;

public class TypeScriptSpacingProcessor
extends JSSpacingProcessor {
    public TypeScriptSpacingProcessor(ASTNode parent, ASTNode child1, ASTNode child2, CodeStyleSettings settings, Language dialect) {
        super(parent, child1, child2, settings, dialect, JavascriptFormattingModelBuilder.getCustomSettings(settings, dialect));
    }

    @Override
    protected boolean shouldPlaceExtraLinesAroundMethod() {
        PsiElement psi;
        if (this.type1 == JSStubElementTypes.TYPESCRIPT_FUNCTION && (psi = this.myChild1.getPsi()) instanceof JSFunction && TypeScriptFunctionImpl.hasNextOverloadDeclaration((JSFunction)psi)) {
            return false;
        }
        return super.shouldPlaceExtraLinesAroundMethod();
    }

    @Override
    public void visitGlobalModuleExport(ASTNode node) {
        if (this.type1 == JSStubElementTypes.ATTRIBUTE_LIST && this.type2 == JSTokenTypes.EXPORT_KEYWORD) {
            this.decoratorSpacing();
        }
        super.visitGlobalModuleExport(node);
    }

    @Override
    protected void visitTypeScriptType(ASTNode node) {
        IElementType type = node.getElementType();
        if (type == TypeScriptElementTypes.FUNCTION_TYPE) {
            if (this.type1 == JSTokenTypes.EQGT || this.type2 == JSTokenTypes.EQGT) {
                int spaces = this.myJSCodeStyleSettings.SPACE_AROUND_ARROW_FUNCTION_OPERATOR ? 1 : 0;
                this.myResult = Spacing.createSpacing((int)spaces, (int)spaces, (int)0, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
            }
        } else if (type == TypeScriptElementTypes.TUPLE_TYPE) {
            this.forceSpacesInBrackets(node, this.mySettings.SPACE_WITHIN_BRACKETS);
        }
        super.visitTypeScriptType(node);
    }

    @Override
    public void visitTypeMember(ASTNode node) {
        this.appendSpacingForTypes();
        super.visitTypeMember(node);
    }
}

