/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.structureView;

import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.javascript.psi.JSNamedElementBase;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.ecma6.ES6Decorator;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCallSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptIndexSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterList;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.structureView.JSStructureItemPresentation;
import com.intellij.lang.javascript.structureView.JSStructureViewElement;
import com.intellij.lang.typescript.structureView.TypeScriptStructureItemPresentation;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.MultiMap;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class TypeScriptStructureViewElement
extends JSStructureViewElement {
    public TypeScriptStructureViewElement(List<PsiElement> elements, boolean includeInherited, Set<String> parentReferencedNames) {
        super(elements, includeInherited, parentReferencedNames, false);
    }

    public TypeScriptStructureViewElement(PsiElement element, boolean includeInherited) {
        super(element, includeInherited, false);
    }

    @Override
    @NotNull
    public JSStructureItemPresentation createPresentation() {
        TypeScriptStructureItemPresentation typeScriptStructureItemPresentation = new TypeScriptStructureItemPresentation(this);
        if (typeScriptStructureItemPresentation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/structureView/TypeScriptStructureViewElement", "createPresentation"));
        }
        return typeScriptStructureItemPresentation;
    }

    @Override
    protected JSStructureViewElement createStructureViewElement(List<PsiElement> elements, Set<String> parentReferencedNames) {
        return new TypeScriptStructureViewElement(elements, this.myIncludeInherited, parentReferencedNames);
    }

    @Override
    protected void addElement(MultiMap<String, PsiElement> children, PsiElement element, String name) {
        if (element instanceof TypeScriptFunction && ((TypeScriptFunction)element).isConstructor()) {
            for (JSParameter parameter : ((TypeScriptFunction)element).getParameterVariables()) {
                super.addElement(children, (PsiElement)parameter, parameter.getName());
            }
        }
        super.addElement(children, element, name);
    }

    @Override
    protected String getName(PsiElement element, MultiMap<String, PsiElement> children) {
        if (element instanceof TypeScriptCallSignature) {
            String name = JSPsiImplUtils.getNameOrComputedPropertyName((JSNamedElementBase)((TypeScriptCallSignature)element));
            return name != null ? name : String.valueOf(children.size());
        }
        if (element instanceof TypeScriptIndexSignature) {
            return "Index Signature";
        }
        if (element instanceof JSQualifiedNamedElement && ((JSQualifiedNamedElement)element).getName() == null && element.getParent() instanceof ES6ExportDefaultAssignment) {
            return "<default>";
        }
        return super.getName(element, children);
    }

    @Override
    protected boolean shouldSkipProcess(PsiElement element) {
        return element instanceof TypeScriptTypeParameterList || element instanceof ES6Decorator || element instanceof TypeScriptType && !(element.getParent() instanceof TypeScriptInterface);
    }
}

