/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.validation;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.ecmascript6.TypeScriptResolveProcessor;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSGenericTypesEvaluator;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.validation.JSFunctionSignatureChecker;
import com.intellij.lang.javascript.validation.JSProblemReporter;
import com.intellij.lang.javascript.validation.JSTypeChecker;
import com.intellij.lang.javascript.validation.ValidateTypesUtil;
import com.intellij.lang.typescript.psi.TypeScriptEntityName;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptFunctionSignatureChecker
extends JSFunctionSignatureChecker {
    public TypeScriptFunctionSignatureChecker(JSTypeChecker<Annotation> typeChecker, JSProblemReporter<Annotation> reporter) {
        super(typeChecker);
    }

    @Override
    protected void registerProblem(JSCallExpression callExpression, String message, LocalQuickFix ... fixes) {
        PsiElement place = ValidateTypesUtil.getPlaceForSignatureProblem(callExpression, callExpression.getArgumentList());
        ProblemHighlightType highlightType = ProblemHighlightType.GENERIC_ERROR;
        JSExpression methodExpression = callExpression.getMethodExpression();
        if (methodExpression instanceof JSReferenceExpression && !TypeScriptUtil.resolveIsStrict((JSReferenceExpression)methodExpression)) {
            highlightType = ProblemHighlightType.WEAK_WARNING;
        }
        this.myTypeChecker.registerProblem(place, message, highlightType, fixes);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void checkFunction(@NotNull JSCallExpression node, @NotNull PsiElement element) {
        block13: {
            PsiElement returnElement;
            JSTypeDeclaration type;
            TypeScriptEntityName internalModuleReference;
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/typescript/validation/TypeScriptFunctionSignatureChecker", "checkFunction"));
            }
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/typescript/validation/TypeScriptFunctionSignatureChecker", "checkFunction"));
            }
            if (element instanceof TypeScriptImportStatement && (internalModuleReference = ((TypeScriptImportStatement)element).getInternalModuleReference()) != null) {
                PsiElement resolve = internalModuleReference.resolve();
                if (resolve == null) {
                    return;
                }
                element = resolve;
            }
            if (element instanceof JSClass) {
                ResolveResult resolveResult = TypeScriptUtil.resolveConstructorMatchingArguments((JSClass)element, node.getMethodExpression());
                PsiElement resolveResultElement = resolveResult.getElement();
                if (resolveResultElement instanceof JSFunction) {
                    element = resolveResultElement;
                    break block13;
                } else {
                    if (node.getArguments().length > 0) {
                        this.registerProblem(node, JSBundle.message((String)"javascript.invalid.number.of.parameters", (Object[])new Object[]{0}), new LocalQuickFix[0]);
                    }
                    return;
                }
            }
            if (element instanceof TypeScriptPropertySignature) {
                type = ((TypeScriptPropertySignature)element).getTypeDeclaration();
                if (type instanceof JSFunction) {
                    element = type;
                    break block13;
                } else {
                    JSArgumentList argumentList = node.getArgumentList();
                    List<JSType> argumentTypes = JSTypeUtils.getArgumentTypes(argumentList);
                    String problem = TypeScriptResolveProcessor.checkParameterTypes((Ref<PsiElement>)Ref.create((Object)element), argumentTypes, null, node instanceof JSNewExpression);
                    if (problem != null) {
                        this.registerProblem(node, JSBundle.message((String)problem, (Object[])new Object[0]), new LocalQuickFix[0]);
                    }
                    return;
                }
            }
            if (element instanceof TypeScriptFunction && ((TypeScriptFunction)element).isGetProperty() && (type = ((TypeScriptFunction)element).getReturnType()) != null && (returnElement = type.getSource().getSourceElement()) instanceof JSFunction) {
                element = returnElement;
            }
        }
        super.checkFunction(node, element);
    }

    @Override
    protected void canBeCalledWithArguments(JSType type, JSCallExpression node) {
        if ((type = JSTypeUtils.getValuableType(type)) instanceof JSFunctionTypeImpl) {
            super.canBeCalledWithArguments(type, node);
        } else if (!JSTypeUtils.canBeCalledWithArguments(type, JSTypeUtils.getArgumentTypes(node.getArgumentList()), node instanceof JSNewExpression)) {
            this.registerProblem(node, JSBundle.message((String)"javascript.argument.types.mismatch", (Object[])new Object[0]), new LocalQuickFix[0]);
        }
    }

    @Override
    protected void checkCallArgumentType(JSParameterItem p, JSExpression exp, JSCallExpression node, PsiElement resolveResult) {
        final Ref ref = Ref.create();
        JSType type = this.addGenericTypesFromCall(p.getType(), node, resolveResult, new JSGenericTypesEvaluator.GenericErrorReporter(){

            @Override
            public void error(String errorCode) {
                ref.set((Object)errorCode);
            }
        });
        if (ref.get() != null && type != null) {
            this.myTypeChecker.registerProblem((PsiElement)exp, JSBundle.message((String)((String)ref.get()), (Object[])new Object[0]), ValidateTypesUtil.getHighlightTypeForTypeOrSignatureProblem((PsiElement)exp), new LocalQuickFix[0]);
        }
        this.myTypeChecker.checkExpressionIsAssignableToType(exp, type, "javascript.argument.type.mismatch", (PsiElement)(p instanceof JSParameter ? (JSParameter)p : null));
    }

    @Override
    @Nullable
    @Contract(value="!null, _, _, _ -> !null")
    protected JSType addGenericTypesFromCall(@Nullable JSType type, JSCallExpression callExpression, PsiElement resolveResult, JSGenericTypesEvaluator.GenericErrorReporter reporter) {
        if (JSTypeUtils.hasGenericParameter(type)) {
            type = TypeScriptGenericTypesEvaluator.getInstance().evaluateGenerics(type, callExpression.getMethodExpression(), resolveResult, reporter);
            Map<String, JSType> genericArguments = TypeScriptResolveProcessor.addGenericArgumentsFromCall(resolveResult, (PsiElement)callExpression, null);
            if (genericArguments != null && !genericArguments.isEmpty()) {
                return JSTypeUtils.applyGenericArguments(type, genericArguments, true, reporter);
            }
        }
        return type;
    }

    @Override
    protected boolean obtainNextMatchedParams(int[] matchedParams, JSParameterItem[] parameters) {
        return false;
    }
}

