/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.functionmetrics;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

class NegationCountVisitor
extends JSRecursiveElementVisitor {
    private int negationCount = 0;

    NegationCountVisitor() {
    }

    public void visitJSElement(JSElement jsElement) {
        int oldCount = 0;
        if (jsElement instanceof JSFunction) {
            oldCount = this.negationCount;
        }
        super.visitJSElement(jsElement);
        if (jsElement instanceof JSFunction) {
            this.negationCount = oldCount;
        }
    }

    public void visitJSBinaryExpression(@NotNull JSBinaryExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/sixrr/inspectjs/functionmetrics/NegationCountVisitor", "visitJSBinaryExpression"));
        }
        super.visitJSBinaryExpression(expression);
        IElementType sign = expression.getOperationSign();
        if (JSTokenTypes.NE.equals(sign) || JSTokenTypes.NEQEQ.equals(sign)) {
            ++this.negationCount;
        }
    }

    public void visitJSPrefixExpression(@NotNull JSPrefixExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/sixrr/inspectjs/functionmetrics/NegationCountVisitor", "visitJSPrefixExpression"));
        }
        super.visitJSPrefixExpression(expression);
        IElementType sign = expression.getOperationSign();
        if (JSTokenTypes.EXCL.equals(sign)) {
            ++this.negationCount;
        }
    }

    public int getNegationCount() {
        return this.negationCount;
    }
}

