/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionToolbarPosition;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.externalSystem.ExternalSystemUiAware;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.util.ExternalSystemUiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleProjectCompositeSelectorDialog
extends DialogWrapper {
    private static final int MAX_PATH_LENGTH = 40;
    @NotNull
    private final Project myProject;
    @Nullable
    private final GradleProjectSettings myCompositeRootSettings;
    private JPanel mainPanel;
    private JPanel contentPanel;
    private JBLabel myDescriptionLbl;
    private ExternalSystemUiAware myExternalSystemUiAware;
    private CheckboxTree myTree;

    public GradleProjectCompositeSelectorDialog(@NotNull Project project, String compositeRootProjectPath) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/gradle/ui/GradleProjectCompositeSelectorDialog", "<init>"));
        }
        super(project, true);
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myCompositeRootSettings = (GradleProjectSettings)GradleSettings.getInstance(this.myProject).getLinkedProjectSettings(compositeRootProjectPath);
        this.myExternalSystemUiAware = ExternalSystemUiUtil.getUiAware((ProjectSystemId)GradleConstants.SYSTEM_ID);
        this.myTree = this.createTree();
        this.setTitle(String.format("%s Project Build Composite", GradleConstants.SYSTEM_ID.getReadableName()));
        this.init();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator((JTree)this.myTree).addExtraAction((AnActionButton)new SelectAllButton()).addExtraAction((AnActionButton)new UnselectAllButton()).setToolbarPosition(ActionToolbarPosition.BOTTOM).setToolbarBorder(IdeBorderFactory.createEmptyBorder());
        this.contentPanel.add(decorator.createPanel());
        return this.mainPanel;
    }

    protected void doOKAction() {
        if (this.myCompositeRootSettings != null) {
            Pair[] pairs = (Pair[])this.myTree.getCheckedNodes(Pair.class, null);
            HashSet compositeParticipants = new HashSet();
            for (Pair pair : pairs) {
                compositeParticipants.add(pair.second.toString());
            }
            this.myCompositeRootSettings.setCompositeParticipants((Set<String>)(compositeParticipants.isEmpty() ? null : compositeParticipants));
        }
        super.doOKAction();
    }

    public void doCancelAction() {
        super.doCancelAction();
    }

    public void dispose() {
        super.dispose();
    }

    private CheckboxTree createTree() {
        CheckedTreeNode root = new CheckedTreeNode();
        if (this.myCompositeRootSettings != null) {
            ArrayList nodes = ContainerUtil.newArrayList();
            for (GradleProjectSettings projectSettings : GradleSettings.getInstance(this.myProject).getLinkedProjectsSettings()) {
                if (projectSettings == this.myCompositeRootSettings) continue;
                boolean added = this.myCompositeRootSettings.getCompositeParticipants().contains(projectSettings.getExternalProjectPath());
                String representationName = this.myExternalSystemUiAware.getProjectRepresentationName(projectSettings.getExternalProjectPath(), projectSettings.getExternalProjectPath());
                CheckedTreeNode treeNode = new CheckedTreeNode((Object)Pair.create((Object)representationName, (Object)projectSettings.getExternalProjectPath()));
                treeNode.setChecked(added);
                nodes.add(treeNode);
            }
            TreeUtil.addChildrenTo((MutableTreeNode)root, (List)nodes);
        }
        CheckboxTree tree = new CheckboxTree(new CheckboxTree.CheckboxTreeCellRenderer(true, false){

            public void customizeRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (!(value instanceof CheckedTreeNode)) {
                    return;
                }
                CheckedTreeNode node = (CheckedTreeNode)value;
                if (!(node.getUserObject() instanceof Pair)) {
                    return;
                }
                Pair pair = (Pair)node.getUserObject();
                ColoredTreeCellRenderer renderer = this.getTextRenderer();
                renderer.setIcon(GradleProjectCompositeSelectorDialog.this.myExternalSystemUiAware.getProjectIcon());
                String projectName = (String)pair.first;
                renderer.append(projectName, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                String projectPath = StringUtil.trimMiddle((String)((String)pair.second), (int)40);
                renderer.append(" (" + projectPath + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
                this.setToolTipText((String)pair.second);
            }
        }, root);
        TreeUtil.expand((JTree)tree, (int)1);
        return tree;
    }

    private void walkTree(Consumer<CheckedTreeNode> consumer) {
        TreeModel treeModel = this.myTree.getModel();
        Object root = treeModel.getRoot();
        if (!(root instanceof CheckedTreeNode)) {
            return;
        }
        for (TreeNode node : TreeUtil.childrenToArray((TreeNode)((CheckedTreeNode)root))) {
            if (!(node instanceof CheckedTreeNode)) continue;
            consumer.consume((Object)((CheckedTreeNode)node));
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JPanel jPanel;
        JPanel jPanel2;
        this.mainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(5, 5));
        jPanel2.setOpaque(false);
        ((Component)jPanel2).setEnabled(true);
        jPanel2.setMinimumSize(new Dimension(300, 100));
        jPanel2.setPreferredSize(new Dimension(400, 300));
        this.contentPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel.setAutoscrolls(true);
        jPanel.setMinimumSize(new Dimension(0, 0));
        jPanel.setPreferredSize(new Dimension(0, 0));
        jPanel2.add((Component)jPanel, "Center");
        this.myDescriptionLbl = jBLabel = new JBLabel();
        jBLabel.setText("Please select project participants to include in the gradle composite.");
        jPanel2.add((Component)jBLabel, "North");
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }

    private class UnselectAllButton
    extends AnActionButton {
        public UnselectAllButton() {
            super("Unselect All", AllIcons.Actions.Unselectall);
        }

        public void actionPerformed(AnActionEvent e) {
            GradleProjectCompositeSelectorDialog.this.walkTree((Consumer<CheckedTreeNode>)node -> node.setChecked(false));
            ((DefaultTreeModel)GradleProjectCompositeSelectorDialog.this.myTree.getModel()).reload();
        }
    }

    private class SelectAllButton
    extends AnActionButton {
        public SelectAllButton() {
            super("Select All", AllIcons.Actions.Selectall);
        }

        public void actionPerformed(AnActionEvent e) {
            GradleProjectCompositeSelectorDialog.this.walkTree((Consumer<CheckedTreeNode>)node -> node.setChecked(true));
            ((DefaultTreeModel)GradleProjectCompositeSelectorDialog.this.myTree.getModel()).reload();
        }
    }
}

