/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.sceneBuilder;

import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JdkVersionUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.NanoXmlUtil;
import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.ContentPanelController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.hierarchy.treeview.HierarchyTreeViewController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.InspectorPanelController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.library.LibraryPanelController;
import com.oracle.javafx.scenebuilder.kit.editor.selection.AbstractSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.ObjectSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMProperty;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMPropertyC;
import com.oracle.javafx.scenebuilder.kit.library.BuiltinLibrary;
import com.oracle.javafx.scenebuilder.kit.library.Library;
import com.oracle.javafx.scenebuilder.kit.library.LibraryItem;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.embed.swing.JFXPanel;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.SceneAntialiasing;
import javafx.scene.control.SplitPane;
import javax.swing.JComponent;
import net.n3.nanoxml.IXMLBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.javaFX.sceneBuilder.EditorCallback;
import org.jetbrains.plugins.javaFX.sceneBuilder.SceneBuilder;

public class SceneBuilderImpl
implements SceneBuilder {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.plugins.javaFX.sceneBuilder.SceneBuilderImpl");
    private final URL myFileURL;
    private final Project myProject;
    private final EditorCallback myEditorCallback;
    private final JFXPanel myPanel = new JFXPanel();
    private EditorController myEditorController;
    private URLClassLoader myClassLoader;
    private volatile Collection<CustomComponent> myCustomComponents;
    private volatile boolean mySkipChanges;
    private ChangeListener<Number> myListener;
    private ChangeListener<Number> mySelectionListener;
    private List<List<SelectionNode>> mySelectionState;
    private static final PropertyName ourChildrenPropertyName = new PropertyName("children");

    public SceneBuilderImpl(URL url, Project project, EditorCallback editorCallback) {
        this.myFileURL = url;
        this.myProject = project;
        this.myEditorCallback = editorCallback;
        Platform.setImplicitExit((boolean)false);
        DumbService dumbService = DumbService.getInstance((Project)this.myProject);
        if (dumbService.isDumb()) {
            dumbService.smartInvokeLater(() -> Platform.runLater(this::create));
        } else {
            Platform.runLater(this::create);
        }
    }

    private void create() {
        if (this.myProject.isDisposed()) {
            return;
        }
        this.myEditorController = new EditorController();
        this.updateCustomLibrary();
        HierarchyTreeViewController componentTree = new HierarchyTreeViewController(this.myEditorController);
        ContentPanelController canvas = new ContentPanelController(this.myEditorController);
        InspectorPanelController propertyTable = new InspectorPanelController(this.myEditorController);
        LibraryPanelController palette = new LibraryPanelController(this.myEditorController);
        SplitPane leftPane = new SplitPane();
        leftPane.setOrientation(Orientation.VERTICAL);
        leftPane.getItems().addAll((Object[])new Node[]{palette.getPanelRoot(), componentTree.getPanelRoot()});
        leftPane.setDividerPositions(new double[]{0.5, 0.5});
        SplitPane.setResizableWithParent((Node)leftPane, (Boolean)Boolean.FALSE);
        SplitPane.setResizableWithParent((Node)propertyTable.getPanelRoot(), (Boolean)Boolean.FALSE);
        SplitPane mainPane = new SplitPane();
        mainPane.getItems().addAll((Object[])new Node[]{leftPane, canvas.getPanelRoot(), propertyTable.getPanelRoot()});
        mainPane.setDividerPositions(new double[]{0.11036789297658862, 0.8963210702341137});
        this.myPanel.setScene(new Scene((Parent)mainPane, (double)this.myPanel.getWidth(), (double)this.myPanel.getHeight(), true, SceneAntialiasing.BALANCED));
        this.loadFile();
        this.startChangeListener();
        if (this.myProject.isDisposed()) {
            return;
        }
        UsageTrigger.trigger((String)"scene-builder.open");
    }

    private void updateCustomLibrary() {
        URLClassLoader oldClassLoader = this.myClassLoader;
        this.myClassLoader = SceneBuilderImpl.createProjectContentClassLoader(this.myProject);
        FXMLLoader.setDefaultClassLoader((ClassLoader)this.myClassLoader);
        if (oldClassLoader != null) {
            try {
                oldClassLoader.close();
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
            }
        }
        Collection customComponents = (Collection)DumbService.getInstance((Project)this.myProject).runReadActionInSmartMode(this::collectCustomComponents);
        try {
            CustomLibrary customLibrary = new CustomLibrary(this.myClassLoader, customComponents);
            this.myEditorController.setLibrary((Library)customLibrary);
            this.myCustomComponents = customComponents;
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
        }
    }

    private Collection<CustomComponent> collectCustomComponents() {
        if (this.myProject.isDisposed()) {
            return Collections.emptyList();
        }
        PsiClass nodeClass = JavaPsiFacade.getInstance((Project)this.myProject).findClass("javafx.scene.Node", GlobalSearchScope.allScope((Project)this.myProject));
        if (nodeClass == null) {
            return Collections.emptyList();
        }
        Collection psiClasses = (Collection)CachedValuesManager.getCachedValue((PsiElement)nodeClass, () -> {
            GlobalSearchScope scope = ProjectScope.getLibrariesScope((Project)nodeClass.getProject());
            String ideJdkVersion = Object.class.getPackage().getSpecificationVersion();
            LanguageLevel ideLanguageLevel = LanguageLevel.parse((String)ideJdkVersion);
            Query query = ClassInheritorsSearch.search((PsiClass)nodeClass, (SearchScope)scope, (boolean)true, (boolean)true, (boolean)false);
            THashSet result = new THashSet();
            query.forEach(arg_0 -> SceneBuilderImpl.lambda$null$1(ideLanguageLevel, (Set)result, arg_0));
            return CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
        });
        if (psiClasses.isEmpty()) {
            return Collections.emptyList();
        }
        return this.prepareCustomComponents(psiClasses);
    }

    private static boolean isBuiltInComponent(PsiClass psiClass) {
        VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)psiClass);
        if (file == null) {
            return false;
        }
        List entries = ProjectRootManager.getInstance((Project)psiClass.getProject()).getFileIndex().getOrderEntriesForFile(file);
        return entries.stream().anyMatch(entry -> entry instanceof JdkOrderEntry);
    }

    private static boolean isCompatibleLanguageLevel(@NotNull PsiClass aClass, @Nullable LanguageLevel targetLevel) {
        JavaSdkVersion jdkVersion;
        Sdk jdk;
        OrderEntry entry;
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/plugins/javaFX/sceneBuilder/SceneBuilderImpl", "isCompatibleLanguageLevel"));
        }
        if (targetLevel == null) {
            return true;
        }
        Project project = aClass.getProject();
        VirtualFile vFile = PsiUtilCore.getVirtualFile((PsiElement)aClass);
        if (vFile == null) {
            return true;
        }
        Module module = ProjectRootManager.getInstance((Project)project).getFileIndex().getModuleForFile(vFile);
        if (module == null && (entry = LibraryUtil.findLibraryEntry((VirtualFile)vFile, (Project)project)) != null) {
            module = entry.getOwnerModule();
        }
        Sdk sdk = jdk = module != null ? ModuleRootManager.getInstance((Module)module).getSdk() : null;
        if (jdk == null) {
            jdk = ProjectRootManager.getInstance((Project)project).getProjectSdk();
        }
        if (jdk == null) {
            return true;
        }
        String versionString = jdk.getVersionString();
        if (versionString != null && (jdkVersion = JdkVersionUtil.getVersion((String)versionString)) != null) {
            return targetLevel.isAtLeast(jdkVersion.getMaxLanguageLevel());
        }
        return true;
    }

    @NotNull
    private Collection<CustomComponent> prepareCustomComponents(Collection<PsiClass> psiClasses) {
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)this.myProject);
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)this.myProject);
        Map<String, BuiltinComponent> builtinComponents = SceneBuilderImpl.loadBuiltinComponents(className -> psiFacade.findClass(className, scope) != null);
        ArrayList<CustomComponent> customComponents = new ArrayList<CustomComponent>();
        for (PsiClass psiClass : psiClasses) {
            String qualifiedName = psiClass.getQualifiedName();
            String name = psiClass.getName();
            if (qualifiedName == null || name == null) continue;
            BuiltinComponent parentComponent = null;
            for (PsiClass aClass = psiClass; aClass != null; aClass = aClass.getSuperClass()) {
                BuiltinComponent component = builtinComponents.get(aClass.getQualifiedName());
                if (component == null) continue;
                parentComponent = component;
                break;
            }
            String moduleName = this.getComponentModuleName(psiClass);
            Map<String, String> attributes = parentComponent != null ? parentComponent.getAttributes() : Collections.emptyMap();
            customComponents.add(new CustomComponent(name, qualifiedName, moduleName, attributes));
        }
        ArrayList<CustomComponent> arrayList = customComponents;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/sceneBuilder/SceneBuilderImpl", "prepareCustomComponents"));
        }
        return arrayList;
    }

    @Nullable
    private String getComponentModuleName(@NotNull PsiClass psiClass) {
        String libraryName;
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/plugins/javaFX/sceneBuilder/SceneBuilderImpl", "getComponentModuleName"));
        }
        VirtualFile vFile = PsiUtilCore.getVirtualFile((PsiElement)psiClass);
        if (vFile == null) {
            return null;
        }
        Module module = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex().getModuleForFile(vFile);
        if (module != null) {
            return module.getName();
        }
        OrderEntry entry = LibraryUtil.findLibraryEntry((VirtualFile)vFile, (Project)this.myProject);
        if (entry instanceof LibraryOrderEntry && (libraryName = ((LibraryOrderEntry)entry).getLibraryName()) != null) {
            return libraryName;
        }
        return null;
    }

    @NotNull
    private static URLClassLoader createProjectContentClassLoader(Project project) {
        List pathList = (List)ApplicationManager.getApplication().runReadAction(() -> OrderEnumerator.orderEntries((Project)project).productionOnly().withoutSdk().recursively().getPathsList().getPathList());
        ArrayList<URL> classpathUrls = new ArrayList<URL>();
        for (String path : pathList) {
            try {
                URL url = new File(path).toURI().toURL();
                classpathUrls.add(url);
            }
            catch (MalformedURLException e) {
                LOG.info((Throwable)e);
            }
        }
        URLClassLoader uRLClassLoader = new URLClassLoader(classpathUrls.toArray(new URL[0]), SceneBuilderImpl.class.getClassLoader());
        if (uRLClassLoader == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/sceneBuilder/SceneBuilderImpl", "createProjectContentClassLoader"));
        }
        return uRLClassLoader;
    }

    @Override
    public JComponent getPanel() {
        return this.myPanel;
    }

    private void startChangeListener() {
        this.myListener = (observable, oldValue, newValue) -> {
            if (!this.mySkipChanges) {
                this.myEditorCallback.saveChanges(this.myEditorController.getFxmlText());
                UsageTrigger.trigger((String)"scene-builder.edit");
            }
        };
        this.mySelectionListener = (observable, oldValue, newValue) -> {
            if (!this.mySkipChanges) {
                this.mySelectionState = this.getSelectionState();
            }
        };
        this.myEditorController.getJobManager().revisionProperty().addListener(this.myListener);
        this.myEditorController.getSelection().revisionProperty().addListener(this.mySelectionListener);
    }

    @Override
    public boolean reload() {
        if (this.myCustomComponents == null) {
            return false;
        }
        Collection customComponents = (Collection)DumbService.getInstance((Project)this.myProject).runReadActionInSmartMode(this::collectCustomComponents);
        if (!new THashSet(this.myCustomComponents).equals((Object)new THashSet(customComponents))) {
            return false;
        }
        Platform.runLater(() -> {
            if (this.myEditorController != null) {
                this.loadFile();
            }
        });
        return true;
    }

    @Override
    public void close() {
        Platform.runLater(this::closeImpl);
    }

    private void closeImpl() {
        if (this.myEditorController != null) {
            if (this.mySelectionListener != null) {
                this.myEditorController.getSelection().revisionProperty().removeListener(this.mySelectionListener);
            }
            if (this.myListener != null) {
                this.myEditorController.getJobManager().revisionProperty().removeListener(this.myListener);
            }
            this.myEditorController = null;
        }
        try {
            if (this.myClassLoader != null) {
                FXMLLoader.setDefaultClassLoader((ClassLoader)SceneBuilderImpl.class.getClassLoader());
                this.myClassLoader.close();
                this.myClassLoader = null;
            }
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
    }

    private void loadFile() {
        this.mySkipChanges = true;
        try {
            String fxmlText = FXOMDocument.readContentFromURL((URL)this.myFileURL);
            String editorFxmlText = this.myEditorController.getFxmlText();
            if (Objects.equals(fxmlText, editorFxmlText)) {
                return;
            }
            this.myEditorController.setFxmlTextAndLocation(fxmlText, this.myFileURL);
            this.restoreSelection(this.mySelectionState);
        }
        catch (Throwable e) {
            this.myEditorCallback.handleError(e);
        }
        finally {
            this.mySkipChanges = false;
        }
    }

    private List<List<SelectionNode>> getSelectionState() {
        AbstractSelectionGroup group = this.myEditorController.getSelection().getGroup();
        if (group instanceof ObjectSelectionGroup) {
            Set items = ((ObjectSelectionGroup)group).getItems();
            ArrayList<List<SelectionNode>> state = new ArrayList<List<SelectionNode>>();
            for (FXOMObject item : items) {
                ArrayList<SelectionNode> path = new ArrayList<SelectionNode>();
                Object graphObject = item.getSceneGraphObject();
                for (FXOMObject component = item; component != null; component = component.getParentObject()) {
                    path.add(new SelectionNode(component));
                }
                Collections.reverse(path);
                state.add(path);
            }
            return state;
        }
        return null;
    }

    private void restoreSelection(List<List<SelectionNode>> state) {
        if (state == null) {
            return;
        }
        ArrayList<FXOMObject> newSelection = new ArrayList<FXOMObject>();
        FXOMObject rootComponent = this.myEditorController.getFxomDocument().getFxomRoot();
        for (List<SelectionNode> path : state) {
            FXOMObject component = this.getSelectedComponent(rootComponent, path, 0);
            if (component == null) continue;
            newSelection.add(component);
        }
        this.myEditorController.getSelection().select(newSelection);
    }

    private FXOMObject getSelectedComponent(FXOMObject component, List<SelectionNode> path, int step) {
        if (step >= path.size()) {
            return null;
        }
        SelectionNode node = new SelectionNode(component);
        if (node.equals(path.get(step))) {
            if (step == path.size() - 1) {
                return component;
            }
            List<FXOMObject> children = SceneBuilderImpl.getChildComponents(component);
            if (children.isEmpty()) {
                return null;
            }
            int indexInParent = path.get((int)(step + 1)).indexInParent;
            if (indexInParent >= 0 && indexInParent < children.size()) {
                return this.getSelectedComponent(children.get(indexInParent), path, step + 1);
            }
        }
        return null;
    }

    private static List<FXOMObject> getChildComponents(FXOMObject component) {
        Map properties;
        FXOMProperty value;
        if (component instanceof FXOMInstance && (value = (FXOMProperty)(properties = ((FXOMInstance)component).getProperties()).get(ourChildrenPropertyName)) instanceof FXOMPropertyC) {
            return ((FXOMPropertyC)value).getValues();
        }
        return Collections.emptyList();
    }

    @NotNull
    private static Map<String, BuiltinComponent> loadBuiltinComponents(Predicate<String> psiClassExists) {
        THashMap components = new THashMap();
        for (LibraryItem item : BuiltinLibrary.getLibrary().getItems()) {
            BuiltinComponent previous;
            Ref refQualifiedName = new Ref();
            final ArrayList imports = new ArrayList();
            THashMap attributes = new THashMap();
            final Ref rootTagProcessed = new Ref((Object)false);
            NanoXmlUtil.parse((Reader)new StringReader(item.getFxmlText()), (IXMLBuilder)new NanoXmlUtil.IXMLBuilderAdapter((Map)attributes, refQualifiedName, psiClassExists){
                final /* synthetic */ Map val$attributes;
                final /* synthetic */ Ref val$refQualifiedName;
                final /* synthetic */ Predicate val$psiClassExists;
                {
                    this.val$attributes = map;
                    this.val$refQualifiedName = ref2;
                    this.val$psiClassExists = predicate;
                }

                public void newProcessingInstruction(String target, Reader reader) throws Exception {
                    if ("import".equals(target)) {
                        String imported = StreamUtil.readTextFrom((Reader)reader);
                        imports.add(imported);
                    }
                }

                public void addAttribute(String key, String nsPrefix, String nsURI, String value, String type) throws Exception {
                    if (((Boolean)rootTagProcessed.get()).booleanValue()) {
                        return;
                    }
                    if (key != null && value != null && StringUtil.isEmpty((String)nsPrefix)) {
                        this.val$attributes.put(key, value);
                    }
                }

                public void elementAttributesProcessed(String name, String nsPrefix, String nsURI) throws Exception {
                    rootTagProcessed.set((Object)true);
                }

                public void startElement(String name, String nsPrefix, String nsURI, String systemID, int lineNr) throws Exception {
                    if (((Boolean)rootTagProcessed.get()).booleanValue()) {
                        return;
                    }
                    for (String imported : imports) {
                        String className;
                        if (imported.equals(name) || imported.endsWith("." + name)) {
                            this.val$refQualifiedName.set((Object)imported);
                            break;
                        }
                        if (!imported.endsWith(".*") || !this.val$psiClassExists.test(className = imported.substring(0, imported.length() - 1) + name)) continue;
                        this.val$refQualifiedName.set((Object)className);
                        break;
                    }
                }
            });
            String qualifiedName = (String)refQualifiedName.get();
            if (StringUtil.isEmpty((String)qualifiedName) || (previous = (BuiltinComponent)components.get(qualifiedName)) != null && previous.getAttributes().size() >= attributes.size()) continue;
            components.put(qualifiedName, new BuiltinComponent((Map<String, String>)attributes));
        }
        THashMap tHashMap = components;
        if (tHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/sceneBuilder/SceneBuilderImpl", "loadBuiltinComponents"));
        }
        return tHashMap;
    }

    private static /* synthetic */ void lambda$null$1(LanguageLevel ideLanguageLevel, Set result, PsiClass psiClass) {
        if (psiClass.hasModifierProperty("public") && !psiClass.hasModifierProperty("abstract") && !SceneBuilderImpl.isBuiltInComponent(psiClass) && SceneBuilderImpl.isCompatibleLanguageLevel(psiClass, ideLanguageLevel)) {
            result.add(psiClass);
        }
    }

    private static class CustomLibrary
    extends Library {
        private static final String CUSTOM_SECTION = "Custom";

        public CustomLibrary(ClassLoader classLoader, Collection<CustomComponent> customComponents) {
            this.classLoaderProperty.set((Object)classLoader);
            this.getItems().setAll((Collection)BuiltinLibrary.getLibrary().getItems());
            List items = ContainerUtil.map(customComponents, component -> new LibraryItem(component.getDisplayName(), CUSTOM_SECTION, component.getFxmlText(), null, (Library)this));
            this.getItems().addAll((Collection)items);
        }

        public Comparator<String> getSectionComparator() {
            return CustomLibrary::compareSections;
        }

        private static int compareSections(String s1, String s2) {
            boolean isCustom1 = CUSTOM_SECTION.equals(s1);
            boolean isCustom2 = CUSTOM_SECTION.equals(s2);
            if (isCustom1) {
                return isCustom2 ? 0 : 1;
            }
            if (isCustom2) {
                return -1;
            }
            return BuiltinLibrary.getLibrary().getSectionComparator().compare(s1, s2);
        }
    }

    private static class CustomComponent {
        private final String myName;
        private final String myQualifiedName;
        private final String myModule;
        private final Map<String, String> myAttributes;

        public CustomComponent(@NotNull String name, @NotNull String qualifiedName, @Nullable String module, @NotNull Map<String, String> attributes) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/javaFX/sceneBuilder/SceneBuilderImpl$CustomComponent", "<init>"));
            }
            if (qualifiedName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "org/jetbrains/plugins/javaFX/sceneBuilder/SceneBuilderImpl$CustomComponent", "<init>"));
            }
            if (attributes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "org/jetbrains/plugins/javaFX/sceneBuilder/SceneBuilderImpl$CustomComponent", "<init>"));
            }
            this.myName = name;
            this.myQualifiedName = qualifiedName;
            this.myModule = module;
            this.myAttributes = attributes;
        }

        public String getDisplayName() {
            return !StringUtil.isEmpty((String)this.myModule) ? this.myName + " (" + this.myModule + ")" : this.myName;
        }

        public String getFxmlText() {
            StringBuilder builder = new StringBuilder(String.format("<?xml version=\"1.0\" encoding=\"UTF-8\"?><?import %s?><%s", this.myQualifiedName, this.myName));
            this.myAttributes.forEach((name, value) -> builder.append(String.format(" %s=\"%s\"", name, value.replace("\"", "&quot;"))));
            builder.append("/>");
            return builder.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CustomComponent)) {
                return false;
            }
            CustomComponent c = (CustomComponent)o;
            return this.myQualifiedName.equals(c.myQualifiedName) && Objects.equals(this.myModule, c.myModule);
        }

        public int hashCode() {
            return Objects.hash(this.myQualifiedName, this.myModule);
        }

        public String toString() {
            return this.myModule != null ? this.myQualifiedName + "(" + this.myModule + ")" : this.myQualifiedName;
        }
    }

    private static class BuiltinComponent {
        private final Map<String, String> myAttributes;

        public BuiltinComponent(Map<String, String> attributes) {
            this.myAttributes = attributes;
        }

        public Map<String, String> getAttributes() {
            return this.myAttributes;
        }
    }

    static class SelectionNode {
        final String qualifiedName;
        final int indexInParent;

        SelectionNode(FXOMObject component) {
            Object graphObject = component.getSceneGraphObject();
            this.qualifiedName = graphObject.getClass().getName();
            FXOMPropertyC parentProperty = component.getParentProperty();
            this.indexInParent = parentProperty != null ? parentProperty.getValues().indexOf(component) : -1;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SelectionNode)) {
                return false;
            }
            SelectionNode node = (SelectionNode)o;
            return this.indexInParent == node.indexInParent && Objects.equals(this.qualifiedName, node.qualifiedName);
        }

        public int hashCode() {
            return Objects.hash(this.qualifiedName, this.indexInParent);
        }

        public String toString() {
            return this.indexInParent + ":" + this.qualifiedName;
        }
    }
}

