/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.aspectj.highlight.analysis.member;

import com.intellij.codeInsight.daemon.impl.analysis.HighlightNamesUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.aspectj.AspectJBundle;
import com.intellij.lang.aspectj.highlight.analysis.AnnotationUtil;
import com.intellij.lang.aspectj.highlight.analysis.ElementAnnotator;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ExternallyDefinedPsiElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.util.MethodSignature;

public class DuplicateMethodsInClassAnnotator
extends ElementAnnotator<PsiMethod> {
    @Override
    public boolean annotate(AnnotationHolder holder, PsiMethod method) {
        PsiClass aClass = method.getContainingClass();
        if (aClass == null || aClass.isEnum()) {
            return false;
        }
        MethodSignature signature = method.getSignature(PsiSubstitutor.EMPTY);
        PsiMethod copy = null;
        for (PsiMethod other : aClass.findMethodsByName(method.getName(), false)) {
            if (other instanceof ExternallyDefinedPsiElement || method.isConstructor() != other.isConstructor() || !signature.equals(other.getSignature(PsiSubstitutor.EMPTY)) || AnnotationUtil.nonIntersecting((PsiMember)method, (PsiMember)other)) continue;
            copy = other;
            break;
        }
        if (copy == null) {
            return false;
        }
        TextRange range = HighlightNamesUtil.getMethodDeclarationTextRange((PsiMethod)method);
        AnnotationUtil.createErrorAnnotation(holder, range, AspectJBundle.message("highlighting.declaration.conflict.in.aspect", JavaHighlightUtil.formatMethod((PsiMethod)method), aClass.getQualifiedName()), AspectJBundle.message("highlighting.declaration.conflict.in.aspect", JavaHighlightUtil.formatMethod((PsiMethod)method), AnnotationUtil.link((PsiElement)copy, aClass.getQualifiedName())));
        return true;
    }
}

