/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.aspectj.refactoring.move;

import com.intellij.lang.aspectj.psi.PsiAspect;
import com.intellij.lang.aspectj.psi.PsiInterTypeDeclaration;
import com.intellij.lang.aspectj.psi.PsiInterTypeReference;
import com.intellij.lang.aspectj.psi.util.InterTypeResolveUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.move.moveMembers.MoveJavaMemberHandler;
import com.intellij.refactoring.move.moveMembers.MoveMembersOptions;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringConflictsUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.util.StringBuilderSpinAllocator;
import com.intellij.util.containers.MultiMap;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoveAjMemberHandler
extends MoveJavaMemberHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.aspectj.refactoring.move.MoveAjMemberHandler");

    public void checkConflictsOnMember(@NotNull PsiMember member, @Nullable String newVisibility, @Nullable PsiModifierList modifierListCopy, @NotNull PsiClass targetClass, @NotNull Set<PsiMember> membersToMove, @NotNull MultiMap<PsiElement, String> conflicts) {
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/lang/aspectj/refactoring/move/MoveAjMemberHandler", "checkConflictsOnMember"));
        }
        if (targetClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetClass", "com/intellij/lang/aspectj/refactoring/move/MoveAjMemberHandler", "checkConflictsOnMember"));
        }
        if (membersToMove == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "membersToMove", "com/intellij/lang/aspectj/refactoring/move/MoveAjMemberHandler", "checkConflictsOnMember"));
        }
        if (conflicts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conflicts", "com/intellij/lang/aspectj/refactoring/move/MoveAjMemberHandler", "checkConflictsOnMember"));
        }
        if (member instanceof PsiInterTypeDeclaration) {
            PsiClass containingClass;
            if (member instanceof PsiMethod && MoveAjMemberHandler.hasMethod((PsiClass)targetClass, (PsiMethod)((PsiMethod)member)) || member instanceof PsiField && MoveAjMemberHandler.hasField((PsiClass)targetClass, (PsiField)((PsiField)member))) {
                String message = RefactoringBundle.message((String)"0.already.exists.in.the.target.class", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)member, (boolean)false)});
                conflicts.putValue((Object)member, (Object)CommonRefactoringUtil.capitalize((String)message));
            }
            PsiClass context = targetClass;
            if (targetClass instanceof PsiAspect && ((PsiAspect)targetClass).isPrivileged() && (containingClass = member.getContainingClass()) != null) {
                context = containingClass;
            }
            RefactoringConflictsUtil.checkUsedElements((PsiMember)member, (PsiElement)member, membersToMove, null, (PsiClass)targetClass, (PsiElement)context, conflicts);
            return;
        }
        super.checkConflictsOnMember(member, newVisibility, modifierListCopy, targetClass, membersToMove, conflicts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public PsiMember doMove(@NotNull MoveMembersOptions options, @NotNull PsiMember member, PsiElement anchor, @NotNull PsiClass targetClass) {
        PsiElement copy;
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/lang/aspectj/refactoring/move/MoveAjMemberHandler", "doMove"));
        }
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/lang/aspectj/refactoring/move/MoveAjMemberHandler", "doMove"));
        }
        if (targetClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetClass", "com/intellij/lang/aspectj/refactoring/move/MoveAjMemberHandler", "doMove"));
        }
        if (!(member instanceof PsiInterTypeDeclaration)) {
            PsiMember psiMember = super.doMove(options, member, anchor, targetClass);
            if (psiMember == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/aspectj/refactoring/move/MoveAjMemberHandler", "doMove"));
            }
            return psiMember;
        }
        if (targetClass instanceof PsiAspect) {
            copy = member.copy();
        } else {
            PsiClass original;
            String text;
            StringBuilder builder = StringBuilderSpinAllocator.alloc();
            try {
                PsiElement point;
                builder.append(member.getText());
                PsiInterTypeReference ref = ((PsiInterTypeDeclaration)member).getInterTypeReference();
                for (point = ref.getNextSibling(); point != null && !PsiUtil.isJavaToken((PsiElement)point, (IElementType)JavaTokenType.DOT); point = point.getNextSibling()) {
                }
                assert (point != null) : member;
                if (member instanceof PsiMethod && ((PsiMethod)member).isConstructor()) {
                    PsiElement newKw;
                    for (newKw = point.getNextSibling(); newKw != null && !PsiUtil.isJavaToken((PsiElement)newKw, (IElementType)JavaTokenType.NEW_KEYWORD); newKw = newKw.getNextSibling()) {
                    }
                    assert (newKw != null) : member;
                    builder.replace(newKw.getStartOffsetInParent(), newKw.getStartOffsetInParent() + newKw.getTextLength(), member.getName());
                }
                builder.delete(ref.getStartOffsetInParent(), point.getStartOffsetInParent() + 1);
                text = builder.toString();
            }
            finally {
                StringBuilderSpinAllocator.dispose((StringBuilder)builder);
            }
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)member.getProject());
            if (member instanceof PsiClass) {
                original = (PsiClass)member;
                PsiClass newClass = factory.createClassFromText(text, (PsiElement)original).getInnerClasses()[0];
                MoveAjMemberHandler.replace(newClass.getModifierList(), original.getModifierList());
                MoveAjMemberHandler.replace(newClass.getTypeParameterList(), original.getTypeParameterList());
                MoveAjMemberHandler.replace(newClass.getExtendsList(), original.getExtendsList());
                MoveAjMemberHandler.replace(newClass.getImplementsList(), original.getImplementsList());
                newClass.deleteChildRange(newClass.getLBrace(), newClass.getRBrace());
                newClass.addRange(original.getLBrace(), original.getRBrace());
                copy = newClass;
            } else if (member instanceof PsiField) {
                original = (PsiField)member;
                PsiField newField = factory.createFieldFromText(text, (PsiElement)original);
                MoveAjMemberHandler.replace(newField.getModifierList(), original.getModifierList());
                MoveAjMemberHandler.replace(newField.getTypeElement(), MoveAjMemberHandler.getRealTypeElement(original.getTypeElement(), factory));
                MoveAjMemberHandler.replace(newField.getInitializer(), original.getInitializer());
                copy = newField;
            } else if (member instanceof PsiMethod) {
                original = (PsiMethod)member;
                PsiMethod newMethod = factory.createMethodFromText(text, (PsiElement)original);
                MoveAjMemberHandler.replace(newMethod.getModifierList(), original.getModifierList());
                MoveAjMemberHandler.replace(newMethod.getTypeParameterList(), original.getTypeParameterList());
                MoveAjMemberHandler.replace(newMethod.getReturnTypeElement(), MoveAjMemberHandler.getRealTypeElement(original.getReturnTypeElement(), factory));
                MoveAjMemberHandler.replace(newMethod.getParameterList(), original.getParameterList());
                MoveAjMemberHandler.replace(newMethod.getThrowsList(), original.getThrowsList());
                MoveAjMemberHandler.replace(newMethod.getBody(), original.getBody());
                copy = newMethod;
            } else {
                LOG.error("Unexpected element: " + member);
                if (null == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/aspectj/refactoring/move/MoveAjMemberHandler", "doMove"));
                }
                return null;
            }
        }
        PsiMember newMember = (PsiMember)(anchor != null ? targetClass.addAfter(copy, anchor) : targetClass.add(copy));
        member.delete();
        PsiMember psiMember = newMember;
        if (psiMember == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/aspectj/refactoring/move/MoveAjMemberHandler", "doMove"));
        }
        return psiMember;
    }

    private static <T extends PsiElement> void replace(@Nullable T newElement, @Nullable T originalElement) {
        if (newElement != null && originalElement != null) {
            newElement.replace(originalElement.copy());
        }
    }

    @Nullable
    private static PsiTypeElement getRealTypeElement(PsiTypeElement original, PsiElementFactory factory) {
        PsiClass aClass;
        PsiType originalType;
        if (original != null && (originalType = original.getType()) instanceof PsiClassReferenceType && (aClass = ((PsiClassReferenceType)originalType).resolve()) instanceof InterTypeResolveUtil.TypeParameterReference) {
            PsiTypeParameter realType = ((InterTypeResolveUtil.TypeParameterReference)aClass).getDelegate();
            return factory.createTypeElementFromText(realType.getText(), null);
        }
        return original;
    }
}

