/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.velocity.psi.directives;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.velocity.Icons;
import com.intellij.velocity.VelocityBundle;
import com.intellij.velocity.editorActions.VtlCommenter;
import com.intellij.velocity.psi.PsiUtil;
import com.intellij.velocity.psi.VtlDirectiveHeader;
import com.intellij.velocity.psi.VtlElementTypes;
import com.intellij.velocity.psi.VtlMacro;
import com.intellij.velocity.psi.VtlParameterDeclaration;
import com.intellij.velocity.psi.VtlPresentableNamedElement;
import com.intellij.velocity.psi.directives.FixedNameVariable;
import com.intellij.velocity.psi.directives.VtlDirective;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VtlMacroImpl
extends VtlPresentableNamedElement
implements VtlDirective,
VtlMacro {
    public VtlMacroImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/velocity/psi/directives/VtlMacroImpl", "<init>"));
        }
        super(node);
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/velocity/psi/directives/VtlMacroImpl", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/velocity/psi/directives/VtlMacroImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/velocity/psi/directives/VtlMacroImpl", "processDeclarations"));
        }
        if (!super.processDeclarations(processor, state, lastParent, place)) {
            return false;
        }
        for (VtlParameterDeclaration declaration : this.getParameters()) {
            if (processor.execute((PsiElement)declaration, state)) continue;
            return false;
        }
        return processor.execute((PsiElement)new FixedNameVariable((PsiElement)this, "bodyContent", null), state) && (!PsiUtil.isAtLeast17(this) || processor.execute((PsiElement)new FixedNameVariable(this, "macro", null, true), state));
    }

    @Override
    @Nullable
    protected PsiElement getNameElement() {
        return this.findHeaderOfDirective().findChildByType(VtlElementTypes.IDENTIFIER);
    }

    @Nullable
    public TextRange getNameElementRange() {
        PsiElement nameElement = this.getNameElement();
        return nameElement == null ? null : nameElement.getTextRange();
    }

    @Override
    @NotNull
    public String getPresentableName() {
        String string = "macro '" + this.getName() + "'";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/velocity/psi/directives/VtlMacroImpl", "getPresentableName"));
        }
        return string;
    }

    @NotNull
    public VtlParameterDeclaration[] getParameters() {
        VtlParameterDeclaration[] vtlParameterDeclarationArray = this.findHeaderOfDirective().findChildrenByClass(VtlParameterDeclaration.class);
        if (vtlParameterDeclarationArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/velocity/psi/directives/VtlMacroImpl", "getParameters"));
        }
        return vtlParameterDeclarationArray;
    }

    @Override
    public VtlDirectiveHeader findHeaderOfDirective() {
        return super.findHeaderOfDirective();
    }

    @Override
    public boolean isDeprecated() {
        return false;
    }

    @Override
    public int getFoldingStartOffset() {
        return this.getNode().getTextRange().getStartOffset() + "#macro".length();
    }

    @Override
    public int getFoldingEndOffset() {
        return this.getNode().getTextRange().getEndOffset() - "#end".length();
    }

    @Override
    public boolean needsClosing() {
        return true;
    }

    public String getTypeName() {
        return VelocityBundle.message("type.name.macro", new Object[0]);
    }

    public Icon getIcon() {
        return Icons.SHARP_ICON;
    }

    @Nullable
    public TextRange getBodyRange() {
        VtlDirectiveHeader header = (VtlDirectiveHeader)((Object)this.findChildByClass(VtlDirectiveHeader.class));
        PsiElement end = this.findChildByType(VtlElementTypes.SHARP_END);
        if (header != null && end != null) {
            return new TextRange(header.getTextRange().getEndOffset() - this.getTextRange().getStartOffset(), end.getStartOffsetInParent());
        }
        return null;
    }

    @Override
    public PsiComment getDocComment() {
        return VtlCommenter.findDocComment(this);
    }

    @Nullable
    public VtlParameterDeclaration findParameter(String name) {
        for (VtlParameterDeclaration declaration : this.getParameters()) {
            if (!name.equals(declaration.getName())) continue;
            return declaration;
        }
        return null;
    }
}

