/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.velocity.psi.files;

import com.intellij.extapi.psi.PsiFileBase;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.velocity.VtlFileIndex;
import com.intellij.velocity.psi.PsiUtil;
import com.intellij.velocity.psi.VtlImplicitVariable;
import com.intellij.velocity.psi.VtlLanguage;
import com.intellij.velocity.psi.VtlMacro;
import com.intellij.velocity.psi.VtlVariable;
import com.intellij.velocity.psi.directives.FixedNameVariable;
import com.intellij.velocity.psi.directives.VtlDirective;
import com.intellij.velocity.psi.directives.VtlDirectiveHolder;
import com.intellij.velocity.psi.files.ProviderBuilder;
import com.intellij.velocity.psi.files.VelocityPropertiesProvider;
import com.intellij.velocity.psi.files.VtlFileProxy;
import com.intellij.velocity.psi.files.VtlFileType;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VtlFile
extends PsiFileBase
implements VtlDirectiveHolder {
    private static final String QUOTED_TEXT = "\"([^\"]*)\"";
    private static final String QUOTED_TEXT_NOT_EMPTY = "\"([^\"]+)\"";
    private static final String PATH_TO_FILE = "[ \t\n]*path=\"([^\"]+)\"";
    private static final String SCOPE_FILE_AND_ANY_TAIL = "([ \t\n]+file=\"([^\"]*)\")?(.*)";
    @NonNls
    public static final String VTLVARIABLE_MARKER = "@vtlvariable ";
    @NonNls
    private static final Pattern IMPLICIT_VAR_DECL_PATTERN = Pattern.compile("(.*?)@vtlvariable [ ]*name=\"([^\"]+)\"[ \t\n]+type=\"([^\"]*)\"([ \t\n]+file=\"([^\"]*)\")?(.*)");
    @NonNls
    public static final String VTLMACROLIBRARY_MARKER = "@vtlmacrolibrary ";
    @NonNls
    private static final Pattern EXTERNAL_MACRO_LIBRARY_PATTERN = Pattern.compile("(.*?)@vtlmacrolibrary [ \t\n]*path=\"([^\"]+)\"([ \t\n]+file=\"([^\"]*)\")?(.*)");
    @NonNls
    public static final String VELOCITY_PROPERTIES_MARKER = "@velocityproperties ";
    @NonNls
    private static final Pattern VELOCITY_PROPERTIES_PATTERN = Pattern.compile("(.*?)@velocityproperties [ \t\n]*path=\"([^\"]+)\"([ \t\n]+runtime_root=\"([^\"]*)\")?([ \t\n]+file=\"([^\"]*)\")?(.*)");
    private final CachedValue<Map<String, VtlImplicitVariable>> myImplicitVars;
    private final CachedValue<Collection<VtlVariable>> myGlobalVars;
    private final CachedValue<Collection<VtlMacro>> myGlobalMacros;
    private final CachedValue<Collection<VtlFileProxy>> myMacroLibraries;
    private final CachedValue<Map<String, Set<VtlMacro>>> myAllMacros;
    private final CachedValue<VelocityPropertiesProvider> myVelocityProperties;

    public VtlFile(FileViewProvider viewProvider) {
        super(viewProvider, (Language)VtlLanguage.INSTANCE);
        ProviderBuilder builder = new ProviderBuilder(this);
        this.myImplicitVars = this.createCachedValue(ProviderBuilder.createImplicitVarsProvider(this));
        this.myGlobalVars = this.createCachedValue(builder.createGlobalVarsProvider());
        this.myGlobalMacros = this.createCachedValue(builder.createGlobalMacrosProvider());
        this.myMacroLibraries = this.createCachedValue(builder.createMacroLibrariesProvider());
        this.myAllMacros = this.createCachedValue(builder.createAllMacrosProvider());
        this.myVelocityProperties = this.createCachedValue(builder.createVelocityPropertiesProvider());
    }

    private <T> CachedValue<T> createCachedValue(CachedValueProvider<T> provider) {
        return CachedValuesManager.getManager((Project)this.getProject()).createCachedValue(provider, false);
    }

    @NotNull
    public FileType getFileType() {
        VtlFileType vtlFileType = VtlFileType.INSTANCE;
        if (vtlFileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/velocity/psi/files/VtlFile", "getFileType"));
        }
        return vtlFileType;
    }

    public String toString() {
        return this.getPresentableName();
    }

    @Override
    @NotNull
    public VtlDirective[] getDirectiveChildren() {
        VtlDirective[] vtlDirectiveArray = (VtlDirective[])this.findChildrenByClass(VtlDirective.class);
        if (vtlDirectiveArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/velocity/psi/files/VtlFile", "getDirectiveChildren"));
        }
        return vtlDirectiveArray;
    }

    @Override
    @NotNull
    public String getPresentableName() {
        String string = "VtlFile:" + this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/velocity/psi/files/VtlFile", "getPresentableName"));
        }
        return string;
    }

    @Nullable
    public VtlImplicitVariable findImplicitVariable(@NotNull String name, @Nullable String scopeFilePath) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/velocity/psi/files/VtlFile", "findImplicitVariable"));
        }
        if (scopeFilePath != null) {
            name = name + scopeFilePath;
        }
        return (VtlImplicitVariable)((Map)this.myImplicitVars.getValue()).get(name);
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/velocity/psi/files/VtlFile", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/velocity/psi/files/VtlFile", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/velocity/psi/files/VtlFile", "processDeclarations"));
        }
        if (!this.processExportableDeclarations(processor, state, null)) {
            return false;
        }
        if (!PsiUtil.processDeclarations(processor, state, lastParent, null, this)) {
            return false;
        }
        for (VtlVariable var : (Collection)this.myGlobalVars.getValue()) {
            if (processor.execute((PsiElement)var, state)) continue;
            return false;
        }
        return this.processGlobalMacros(processor, state) && this.processVelocityPropertiesLibraries(processor, state) && this.processImplicitlyIncludedFiles(processor, state) && this.processScopeControlVariables(processor, state);
    }

    private boolean processScopeControlVariables(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/velocity/psi/files/VtlFile", "processScopeControlVariables"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/velocity/psi/files/VtlFile", "processScopeControlVariables"));
        }
        return !PsiUtil.isAtLeast17(this) || processor.execute((PsiElement)new FixedNameVariable((PsiElement)this, "template", true), state) && processor.execute((PsiElement)new FixedNameVariable((PsiElement)this, "evaluate", true), state);
    }

    private boolean processGlobalMacros(PsiScopeProcessor processor, ResolveState state) {
        for (VtlMacro macro : (Collection)this.myGlobalMacros.getValue()) {
            if (processor.execute((PsiElement)macro, state)) continue;
            return false;
        }
        return true;
    }

    private boolean processExportableDeclarations(PsiScopeProcessor processor, ResolveState state, @Nullable VtlFile placeFile) {
        for (VtlImplicitVariable var : ((Map)this.myImplicitVars.getValue()).values()) {
            if (!var.isVisibleIn(placeFile) || processor.execute((PsiElement)var, state)) continue;
            return false;
        }
        return this.processMacroLibraries(processor, state, placeFile);
    }

    private boolean processVelocityPropertiesLibraries(PsiScopeProcessor processor, ResolveState state) {
        VelocityPropertiesProvider velocityProperties = (VelocityPropertiesProvider)this.myVelocityProperties.getValue();
        if (velocityProperties == null) {
            return true;
        }
        VirtualFile virtual = this.getOriginalFile().getVirtualFile();
        if (virtual == null) {
            return true;
        }
        List<VtlFile> velocimacros = velocityProperties.getVelocimacroLibraryListBasedOn(virtual.getParent());
        for (VtlFile lib : velocimacros) {
            if (lib.processMacrosInFile(processor, state)) continue;
            return false;
        }
        return true;
    }

    private boolean processImplicitlyIncludedFiles(PsiScopeProcessor processor, ResolveState state) {
        Collection<VtlFile> implicitlyIncludedFiles = VtlFileIndex.getImplicitlyIncludedFiles((PsiFile)this);
        if (implicitlyIncludedFiles.isEmpty()) {
            return true;
        }
        VtlFile placeFile = (VtlFile)this.getOriginalFile();
        for (VtlFile implicitlyIncludedFile : implicitlyIncludedFiles) {
            if (implicitlyIncludedFile.processExportableDeclarations(processor, state, placeFile)) continue;
            return false;
        }
        return true;
    }

    private boolean processMacroLibraries(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, VtlFile placeFile) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/velocity/psi/files/VtlFile", "processMacroLibraries"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/velocity/psi/files/VtlFile", "processMacroLibraries"));
        }
        for (VtlFileProxy lib : (Collection)this.myMacroLibraries.getValue()) {
            if (!lib.isVisibleIn(placeFile) || lib.getFile().processMacrosInFile(processor, state)) continue;
            return false;
        }
        return true;
    }

    private boolean processMacrosInFile(PsiScopeProcessor processor, ResolveState state) {
        for (Set macros : ((Map)this.myAllMacros.getValue()).values()) {
            assert (macros.size() > 0);
            if (processor.execute((PsiElement)macros.iterator().next(), state)) continue;
            return false;
        }
        return true;
    }

    public boolean processAllMacrosInScope(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/velocity/psi/files/VtlFile", "processAllMacrosInScope"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/velocity/psi/files/VtlFile", "processAllMacrosInScope"));
        }
        return this.processGlobalMacros(processor, state) && this.processMacroLibraries(processor, state, null) && this.processVelocityPropertiesLibraries(processor, state) && this.processImplicitlyIncludedFiles(processor, state) && this.processMacrosInFile(processor, state);
    }

    public int getNumberOfMacros(@Nullable String macroName) {
        Set macroSet = (Set)((Map)this.myAllMacros.getValue()).get(macroName);
        return macroSet == null ? 0 : macroSet.size();
    }

    @NotNull
    public Set<String> getDefinedMacroNames() {
        HashSet<String> result = new HashSet<String>();
        for (VtlMacro macro : this.getDefinedMacros()) {
            ContainerUtil.addIfNotNull(result, (Object)macro.getName());
        }
        HashSet<String> hashSet = result;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/velocity/psi/files/VtlFile", "getDefinedMacroNames"));
        }
        return hashSet;
    }

    @NotNull
    public Set<VtlMacro> getDefinedMacros() {
        THashSet res = new THashSet();
        Map macros = (Map)this.myAllMacros.getValue();
        for (Set sameNameMacros : macros.values()) {
            for (VtlMacro macro : sameNameMacros) {
                if (macro.getContainingFile() != this) continue;
                res.add(macro);
            }
        }
        THashSet tHashSet = res;
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/velocity/psi/files/VtlFile", "getDefinedMacros"));
        }
        return tHashSet;
    }

    @Nullable
    public VelocityPropertiesProvider getVelocityProperties() {
        return (VelocityPropertiesProvider)this.myVelocityProperties.getValue();
    }

    public boolean isIdeTemplateFile() {
        return this.getViewProvider().getUserData(FileTemplateManager.DEFAULT_TEMPLATE_PROPERTIES) != null;
    }

    @Nullable
    public static String[] findVariableNameAndTypeAndScopeFilePath(@NotNull String commentText) {
        if (commentText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commentText", "com/intellij/velocity/psi/files/VtlFile", "findVariableNameAndTypeAndScopeFilePath"));
        }
        Matcher matcher = IMPLICIT_VAR_DECL_PATTERN.matcher(commentText);
        if (!matcher.matches()) {
            return null;
        }
        return new String[]{matcher.group(2), matcher.group(3), matcher.group(5)};
    }

    @Nullable
    public static String[] findMacroLibraryPathAndScopeFilePath(@NotNull String commentText) {
        if (commentText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commentText", "com/intellij/velocity/psi/files/VtlFile", "findMacroLibraryPathAndScopeFilePath"));
        }
        Matcher matcher = EXTERNAL_MACRO_LIBRARY_PATTERN.matcher(commentText);
        if (!matcher.matches()) {
            return null;
        }
        return new String[]{matcher.group(2), matcher.group(4)};
    }

    public static String[] findVelocityPropertiesPathAndScopeFilePath(String commentText) {
        Matcher matcher = VELOCITY_PROPERTIES_PATTERN.matcher(commentText);
        if (!matcher.matches()) {
            return null;
        }
        return new String[]{matcher.group(2), matcher.group(4), matcher.group(6)};
    }
}

