/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle;

import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidArtifactOutput;
import com.android.builder.model.Variant;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.model.ClassJarProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.List;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidGradleClassJarProvider
extends ClassJarProvider {
    @Override
    @Nullable
    public VirtualFile findModuleClassFile(@NotNull String className, @NotNull Module module) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "com/android/tools/idea/gradle/AndroidGradleClassJarProvider", "findModuleClassFile"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/AndroidGradleClassJarProvider", "findModuleClassFile"));
        }
        AndroidGradleModel model = AndroidGradleModel.get(module);
        if (model == null) {
            return null;
        }
        VirtualFile outputDir = AndroidGradleClassJarProvider.getCompilerOutputRoot(model);
        if (outputDir == null) {
            return null;
        }
        return ClassJarProvider.findClassFileInPath(outputDir, className);
    }

    @Nullable
    private static VirtualFile getCompilerOutputRoot(@NotNull AndroidGradleModel model) {
        File outFolder;
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/gradle/AndroidGradleClassJarProvider", "getCompilerOutputRoot"));
        }
        Variant variant = model.getSelectedVariant();
        String variantName = variant.getName();
        AndroidArtifact mainArtifactInfo = model.getMainArtifact();
        File classesFolder = mainArtifactInfo.getClassesFolder();
        if (classesFolder == null) {
            AndroidArtifactOutput output = GradleUtil.getOutput(mainArtifactInfo);
            File file = output.getMainOutputFile().getOutputFile();
            File buildFolder = file.getParentFile().getParentFile();
            classesFolder = new File(buildFolder, "classes");
        }
        if ((outFolder = new File(classesFolder, variantName.replace('-', File.separatorChar))).exists()) {
            return VfsUtil.findFileByIoFile((File)outFolder, (boolean)true);
        }
        return null;
    }

    @Override
    @NotNull
    public List<VirtualFile> getModuleExternalLibraries(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/AndroidGradleClassJarProvider", "getModuleExternalLibraries"));
        }
        List<VirtualFile> list = AndroidRootUtil.getExternalLibraries(module);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/AndroidGradleClassJarProvider", "getModuleExternalLibraries"));
        }
        return list;
    }
}

