/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.model.android;

import com.android.builder.model.BaseArtifact;
import com.android.builder.model.Variant;
import com.android.tools.idea.gradle.structure.model.PsModelCollection;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidArtifact;
import com.android.tools.idea.gradle.structure.model.android.PsVariant;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsAndroidArtifactCollection
implements PsModelCollection<PsAndroidArtifact> {
    @NotNull
    private final PsVariant myParent;
    @NotNull
    private final Map<String, PsAndroidArtifact> myArtifactsByName;

    PsAndroidArtifactCollection(@NotNull PsVariant parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/android/tools/idea/gradle/structure/model/android/PsAndroidArtifactCollection", "<init>"));
        }
        this.myArtifactsByName = Maps.newHashMap();
        this.myParent = parent;
        Variant variant = this.myParent.getResolvedModel();
        if (variant != null) {
            this.addArtifact((BaseArtifact)variant.getMainArtifact());
            this.addArtifacts(variant.getExtraAndroidArtifacts());
            this.addArtifacts(variant.getExtraJavaArtifacts());
        }
    }

    private void addArtifacts(@NotNull Collection<? extends BaseArtifact> artifacts) {
        if (artifacts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifacts", "com/android/tools/idea/gradle/structure/model/android/PsAndroidArtifactCollection", "addArtifacts"));
        }
        artifacts.forEach(this::addArtifact);
    }

    private void addArtifact(@NotNull BaseArtifact artifact) {
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/android/tools/idea/gradle/structure/model/android/PsAndroidArtifactCollection", "addArtifact"));
        }
        this.myArtifactsByName.put(artifact.getName(), new PsAndroidArtifact(this.myParent, artifact.getName(), artifact));
    }

    @Override
    @Nullable
    public <S extends PsAndroidArtifact> S findElement(@NotNull String name, @NotNull Class<S> type) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/structure/model/android/PsAndroidArtifactCollection", "findElement"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/gradle/structure/model/android/PsAndroidArtifactCollection", "findElement"));
        }
        PsAndroidArtifact found = this.myArtifactsByName.get(name);
        return (S)(type.isInstance(found) ? (PsAndroidArtifact)type.cast(found) : null);
    }

    @Override
    public void forEach(@NotNull Consumer<PsAndroidArtifact> consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/android/tools/idea/gradle/structure/model/android/PsAndroidArtifactCollection", "forEach"));
        }
        this.myArtifactsByName.values().forEach(consumer);
    }

    @NotNull
    public PsVariant getParent() {
        PsVariant psVariant = this.myParent;
        if (psVariant == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/model/android/PsAndroidArtifactCollection", "getParent"));
        }
        return psVariant;
    }
}

