/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.ProjectViewDirectoryHelper;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class NativeAndroidSourceDirectoryNode
extends PsiDirectoryNode {
    @NotNull
    private final Collection<String> myFileExtensions;
    @NotNull
    private final Collection<VirtualFile> mySourceFolders;
    @NotNull
    private final Collection<VirtualFile> mySourceFiles;

    public NativeAndroidSourceDirectoryNode(@NotNull Project project, @NotNull PsiDirectory dir, @NotNull ViewSettings settings, @NotNull Collection<String> fileExtensions, @NotNull Collection<VirtualFile> sourceFolders, @NotNull Collection<VirtualFile> sourceFiles) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/navigator/nodes/NativeAndroidSourceDirectoryNode", "<init>"));
        }
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/android/tools/idea/navigator/nodes/NativeAndroidSourceDirectoryNode", "<init>"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/android/tools/idea/navigator/nodes/NativeAndroidSourceDirectoryNode", "<init>"));
        }
        if (fileExtensions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileExtensions", "com/android/tools/idea/navigator/nodes/NativeAndroidSourceDirectoryNode", "<init>"));
        }
        if (sourceFolders == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceFolders", "com/android/tools/idea/navigator/nodes/NativeAndroidSourceDirectoryNode", "<init>"));
        }
        if (sourceFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceFiles", "com/android/tools/idea/navigator/nodes/NativeAndroidSourceDirectoryNode", "<init>"));
        }
        super(project, dir, settings);
        this.myFileExtensions = fileExtensions;
        this.mySourceFolders = sourceFolders;
        this.mySourceFiles = sourceFiles;
    }

    protected boolean shouldShowModuleName() {
        return false;
    }

    protected boolean shouldShowSourcesRoot() {
        return false;
    }

    protected void updateImpl(PresentationData presentation) {
        super.updateImpl(presentation);
        presentation.setIcon(AllIcons.Nodes.Folder);
    }

    public Collection<AbstractTreeNode> getChildrenImpl() {
        PsiDirectory psiDirectory = (PsiDirectory)this.getValue();
        if (psiDirectory == null) {
            return ImmutableList.of();
        }
        Collection directoryChildren = ProjectViewDirectoryHelper.getInstance((Project)this.myProject).getDirectoryChildren(psiDirectory, this.getSettings(), true);
        ArrayList result = Lists.newArrayList();
        for (AbstractTreeNode child : directoryChildren) {
            Object value = child.getValue();
            if (value instanceof PsiFile) {
                VirtualFile file = ((PsiFile)value).getVirtualFile();
                if ((!this.mySourceFolders.contains(psiDirectory.getVirtualFile()) || !this.myFileExtensions.contains(file.getExtension())) && !this.mySourceFiles.contains(file)) continue;
                result.add(child);
                continue;
            }
            if (!(value instanceof PsiDirectory)) continue;
            VirtualFile dir = ((PsiDirectory)value).getVirtualFile();
            if (this.mySourceFolders.contains(dir) || this.mySourceFolders.contains(psiDirectory.getVirtualFile())) {
                result.add(new NativeAndroidSourceDirectoryNode(this.myProject, (PsiDirectory)value, this.getSettings(), this.myFileExtensions, (Collection<VirtualFile>)ImmutableList.of((Object)dir), (Collection<VirtualFile>)ImmutableList.of()));
                continue;
            }
            ArrayList childDirs = Lists.newArrayList();
            for (VirtualFile sourceFolder : this.mySourceFolders) {
                if (!VfsUtilCore.isAncestor((VirtualFile)dir, (VirtualFile)sourceFolder, (boolean)true)) continue;
                childDirs.add(sourceFolder);
            }
            ArrayList childFiles = Lists.newArrayList();
            for (VirtualFile file : this.mySourceFiles) {
                if (!VfsUtilCore.isAncestor((VirtualFile)dir, (VirtualFile)file, (boolean)true)) continue;
                childFiles.add(file);
            }
            if (childDirs.isEmpty() && childFiles.isEmpty()) continue;
            result.add(new NativeAndroidSourceDirectoryNode(this.myProject, (PsiDirectory)value, this.getSettings(), this.myFileExtensions, childDirs, childFiles));
        }
        return result;
    }
}

