/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ModuleResourceRepository;
import com.android.tools.idea.res.MultiResourceRepository;
import com.android.tools.idea.res.ProjectResourceRepositoryRootListener;
import com.google.common.collect.Lists;
import com.intellij.openapi.module.Module;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ProjectResourceRepository
extends MultiResourceRepository {
    private final AndroidFacet myFacet;

    private ProjectResourceRepository(@NotNull AndroidFacet facet, @NotNull List<? extends LocalResourceRepository> delegates) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/res/ProjectResourceRepository", "<init>"));
        }
        if (delegates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegates", "com/android/tools/idea/res/ProjectResourceRepository", "<init>"));
        }
        super(facet.getModule().getName() + " with modules", delegates);
        this.myFacet = facet;
    }

    @Nullable
    public static ProjectResourceRepository getProjectResources(@NotNull Module module, boolean createIfNecessary) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/res/ProjectResourceRepository", "getProjectResources"));
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet != null) {
            return facet.getProjectResources(createIfNecessary);
        }
        return null;
    }

    @Contract(value="!null, true -> !null")
    @Nullable
    public static ProjectResourceRepository getProjectResources(@NotNull AndroidFacet facet, boolean createIfNecessary) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/res/ProjectResourceRepository", "getProjectResources"));
        }
        return facet.getProjectResources(createIfNecessary);
    }

    @NotNull
    public static ProjectResourceRepository create(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/res/ProjectResourceRepository", "create"));
        }
        List<LocalResourceRepository> resources = ProjectResourceRepository.computeRepositories(facet);
        ProjectResourceRepository repository = new ProjectResourceRepository(facet, resources);
        ProjectResourceRepositoryRootListener.ensureSubscribed(facet.getModule().getProject());
        ProjectResourceRepository projectResourceRepository = repository;
        if (projectResourceRepository == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/res/ProjectResourceRepository", "create"));
        }
        return projectResourceRepository;
    }

    private static List<LocalResourceRepository> computeRepositories(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/res/ProjectResourceRepository", "computeRepositories"));
        }
        LocalResourceRepository main = ModuleResourceRepository.getModuleResources(facet, true);
        List<AndroidFacet> dependentFacets = AndroidUtils.getAllAndroidDependencies(facet.getModule(), true);
        if (dependentFacets.isEmpty()) {
            return Collections.singletonList(main);
        }
        ArrayList resources = Lists.newArrayListWithExpectedSize((int)dependentFacets.size());
        for (AndroidFacet f : dependentFacets) {
            LocalResourceRepository r = ModuleResourceRepository.getModuleResources(f, true);
            resources.add(r);
        }
        resources.add(main);
        return resources;
    }

    void updateRoots() {
        List<LocalResourceRepository> repositories = ProjectResourceRepository.computeRepositories(this.myFacet);
        this.updateRoots(repositories);
    }

    void updateRoots(List<LocalResourceRepository> resourceDirectories) {
        this.invalidateResourceDirs();
        if (!resourceDirectories.equals(this.myChildren)) {
            this.setChildren(resourceDirectories);
        }
    }

    @NotNull
    static ProjectResourceRepository createForTest(AndroidFacet facet, List<LocalResourceRepository> modules) {
        ProjectResourceRepository projectResourceRepository = new ProjectResourceRepository(facet, modules);
        if (projectResourceRepository == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/res/ProjectResourceRepository", "createForTest"));
        }
        return projectResourceRepository;
    }
}

