/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.editor;

import com.android.tools.idea.uibuilder.editor.NlEditorPanel;
import com.android.tools.idea.uibuilder.editor.NlPaletteManager;
import com.android.tools.idea.uibuilder.editor.NlPropertiesWindowManager;
import com.android.tools.idea.uibuilder.lint.NlBackgroundEditorHighlighter;
import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.designer.DesignerEditorPanelFacade;
import com.intellij.designer.LightToolWindowManager;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlEditor
extends UserDataHolderBase
implements FileEditor {
    private final AndroidFacet myFacet;
    private final VirtualFile myFile;
    private final DumbService myDumbService;
    private final LightToolWindowManager myPaletteManager;
    private final LightToolWindowManager myPropertiesWindowManager;
    private NlEditorPanel myEditorPanel;
    private BackgroundEditorHighlighter myBackgroundHighlighter;

    public NlEditor(AndroidFacet facet, VirtualFile file, Project project) {
        this.myFacet = facet;
        this.myFile = file;
        this.myDumbService = DumbService.getInstance((Project)project);
        this.myPaletteManager = NlPaletteManager.get(project);
        this.myPropertiesWindowManager = NlPropertiesWindowManager.get(project);
    }

    @NotNull
    public NlEditorPanel getComponent() {
        if (this.myEditorPanel == null) {
            this.myEditorPanel = new NlEditorPanel(this, this.myFacet, this.myFile);
            this.myDumbService.smartInvokeLater(new Runnable(){

                @Override
                public void run() {
                    NlEditor.this.myPaletteManager.bind((DesignerEditorPanelFacade)NlEditor.this.myEditorPanel);
                    NlEditor.this.myPropertiesWindowManager.bind((DesignerEditorPanelFacade)NlEditor.this.myEditorPanel);
                }
            });
        }
        NlEditorPanel nlEditorPanel = this.myEditorPanel;
        if (nlEditorPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/editor/NlEditor", "getComponent"));
        }
        return nlEditorPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.getComponent().getPreferredFocusedComponent();
    }

    @NotNull
    public String getName() {
        if ("Design" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/editor/NlEditor", "getName"));
        }
        return "Design";
    }

    @NotNull
    public FileEditorState getState(@NotNull FileEditorStateLevel level) {
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/android/tools/idea/uibuilder/editor/NlEditor", "getState"));
        }
        FileEditorState fileEditorState = FileEditorState.INSTANCE;
        if (fileEditorState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/editor/NlEditor", "getState"));
        }
        return fileEditorState;
    }

    public void setState(@NotNull FileEditorState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/idea/uibuilder/editor/NlEditor", "setState"));
        }
    }

    public void dispose() {
        this.getComponent().dispose();
    }

    public void selectNotify() {
        this.getComponent().activate();
    }

    public void deselectNotify() {
        this.getComponent().deactivate();
    }

    public boolean isValid() {
        return this.myFile.isValid();
    }

    public boolean isModified() {
        return false;
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/uibuilder/editor/NlEditor", "addPropertyChangeListener"));
        }
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/uibuilder/editor/NlEditor", "removePropertyChangeListener"));
        }
    }

    @Nullable
    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        if (this.myBackgroundHighlighter == null) {
            this.myBackgroundHighlighter = new NlBackgroundEditorHighlighter(this.myEditorPanel);
        }
        return this.myBackgroundHighlighter;
    }

    @Nullable
    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    @Nullable
    public StructureViewBuilder getStructureViewBuilder() {
        return null;
    }
}

