/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint;

import android.support.constraint.solver.widgets.ConstraintAnchor;
import android.support.constraint.solver.widgets.ConstraintWidget;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintModel;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintUtilities;
import com.android.tools.idea.uibuilder.handlers.constraint.DrawConstraintModel;
import com.android.tools.idea.uibuilder.handlers.constraint.SingleWidgetView;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.property.NlProperty;
import com.android.tools.sherpa.drawing.BlueprintColorSet;
import com.android.tools.sherpa.drawing.ColorSet;
import com.android.tools.sherpa.structure.WidgetsScene;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicSliderUI;
import org.jetbrains.annotations.NotNull;

public class WidgetConstraintPanel
extends JPanel {
    private static final String HORIZONTAL_TOOL_TIP_TEXT = "Horizontal Bias";
    private static final String VERTICAL_TOOL_TIP_TEXT = "Vertical Bias";
    public static final String SIZE_ANY = "0dp";
    final SingleWidgetView mMain;
    final JSlider mVerticalSlider;
    final JSlider mHorizontalSlider;
    private WidgetsScene mScene;
    ConstraintModel mConstraintModel;
    NlComponent mComponent;
    ConstraintWidget mWidget;
    private boolean mWidgetModified;
    public static final int UNCONNECTED = -1;
    private String mWidgetWidthCache;
    private String mWidgetHeightCache;
    ColorSet mColorSet;

    public void setProperty(NlProperty property) {
        this.updateComponents(property.getComponents());
    }

    public WidgetConstraintPanel(@NotNull List<NlComponent> components) {
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/android/tools/idea/uibuilder/handlers/constraint/WidgetConstraintPanel", "<init>"));
        }
        super(new GridBagLayout());
        this.mVerticalSlider = new JSlider(1);
        this.mHorizontalSlider = new JSlider(0);
        this.mColorSet = new InspectorColorSet();
        super.setBorder(new EmptyBorder(4, 0, 0, 0));
        this.setBackground(this.mColorSet.getInspectorBackgroundColor());
        this.mMain = new SingleWidgetView(this, this.mColorSet);
        this.setPreferredSize(new Dimension(200, 216));
        this.mVerticalSlider.setMajorTickSpacing(50);
        this.mHorizontalSlider.setMajorTickSpacing(50);
        this.mVerticalSlider.setBackground(this.mColorSet.getInspectorBackgroundColor());
        this.mHorizontalSlider.setBackground(this.mColorSet.getInspectorBackgroundColor());
        this.mHorizontalSlider.setToolTipText(HORIZONTAL_TOOL_TIP_TEXT);
        this.mVerticalSlider.setToolTipText(VERTICAL_TOOL_TIP_TEXT);
        this.updateComponents(components);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.fill = 1;
        this.add((Component)this.mVerticalSlider, gbc);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridx = 1;
        this.add((Component)this.mMain, gbc);
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridy = 1;
        this.add((Component)this.mHorizontalSlider, gbc);
        this.mVerticalSlider.setUI(new WidgetSliderUI(this.mVerticalSlider, this.mColorSet));
        this.mHorizontalSlider.setUI(new WidgetSliderUI(this.mHorizontalSlider, this.mColorSet));
        this.mHorizontalSlider.addChangeListener(e -> this.setHorizontalBias());
        this.mVerticalSlider.addChangeListener(e -> this.setVerticalBias());
    }

    private void widgetChanged() {
        this.configureUI();
        this.repaint();
    }

    private void configureUI() {
        float bias;
        boolean showHorizontalSlider;
        if (this.mWidget == null) {
            return;
        }
        int top = this.getMargin(ConstraintAnchor.Type.TOP);
        int left = this.getMargin(ConstraintAnchor.Type.LEFT);
        int right = this.getMargin(ConstraintAnchor.Type.RIGHT);
        int bottom = this.getMargin(ConstraintAnchor.Type.BOTTOM);
        boolean baseline = this.hasBaseline();
        boolean showVerticalSlider = bottom != -1 && top != -1;
        boolean bl = showHorizontalSlider = left != -1 && right != -1;
        if (showHorizontalSlider) {
            bias = this.mWidget.getHorizontalBiasPercent();
            this.mHorizontalSlider.setValue((int)(bias * 100.0f));
        }
        if (showVerticalSlider) {
            bias = this.mWidget.getVerticalBiasPercent();
            this.mVerticalSlider.setValue(100 - (int)(bias * 100.0f));
        }
        this.mVerticalSlider.setEnabled(showVerticalSlider);
        this.mHorizontalSlider.setEnabled(showHorizontalSlider);
        this.mHorizontalSlider.invalidate();
        this.mVerticalSlider.invalidate();
        this.mVerticalSlider.setToolTipText(showVerticalSlider ? VERTICAL_TOOL_TIP_TEXT : null);
        this.mHorizontalSlider.setToolTipText(showHorizontalSlider ? HORIZONTAL_TOOL_TIP_TEXT : null);
        int widthVal = WidgetConstraintPanel.convert(this.mWidget.getHorizontalDimensionBehaviour());
        int heightValue = WidgetConstraintPanel.convert(this.mWidget.getVerticalDimensionBehaviour());
        this.mMain.configureUi(bottom, top, left, right, baseline, widthVal, heightValue);
    }

    private static int convert(ConstraintWidget.DimensionBehaviour behaviour) {
        switch (behaviour) {
            case FIXED: {
                return 0;
            }
            case WRAP_CONTENT: {
                return 2;
            }
            case ANY: {
                return 1;
            }
        }
        return 0;
    }

    private boolean hasBaseline() {
        ConstraintAnchor anchor = this.mWidget.getAnchor(ConstraintAnchor.Type.BASELINE);
        return anchor != null && anchor.isConnected();
    }

    public void updateComponents(@NotNull List<NlComponent> components) {
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/android/tools/idea/uibuilder/handlers/constraint/WidgetConstraintPanel", "updateComponents"));
        }
        this.mComponent = components.isEmpty() ? null : components.get(0);
        this.mWidget = null;
        if (this.mComponent != null) {
            this.mConstraintModel = ConstraintModel.getConstraintModel(this.mComponent.getModel());
            this.mScene = this.mConstraintModel.getScene();
            this.mConstraintModel.getSelection().setContinuousListener(e -> this.widgetChanged());
            ConstraintWidget widget = this.mScene.getWidget((Object)this.mComponent);
            if (widget == null) {
                return;
            }
            if (this.mWidgetModified && this.mWidget != null && widget != this.mWidget) {
                this.saveWidget();
            }
            this.mWidget = widget;
            this.configureUI();
        }
    }

    private int getMargin(ConstraintAnchor.Type type) {
        ConstraintAnchor anchor = this.mWidget.getAnchor(type);
        if (anchor != null && anchor.isConnected()) {
            return anchor.getMargin();
        }
        return -1;
    }

    public void configureUI(NlComponent component) {
        this.mComponent = component;
        if (component == null) {
            return;
        }
        String mWidgetName = component.getId();
        int bottom = ConstraintUtilities.getMargin(component, "layout_marginBottom");
        int top = ConstraintUtilities.getMargin(component, "layout_marginTop");
        int left = ConstraintUtilities.getMargin(component, "layout_marginStart");
        int right = ConstraintUtilities.getMargin(component, "layout_marginEnd");
        String rl = component.getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintRight_toLeftOf");
        String rr = component.getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintRight_toRightOf");
        String ll = component.getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintLeft_toLeftOf");
        String lr = component.getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintLeft_toRightOf");
        String tt = component.getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintTop_toTopOf");
        String tb = component.getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintTop_toBottomOf");
        String bt = component.getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintBottom_toTopOf");
        String bb = component.getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintBottom_toBottomOf");
        String basline = component.getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintBaseline_toBaselineOf");
        String hbias = component.getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintHorizontal_bias");
        String vbias = component.getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintVertical_bias");
        String widthStr = component.getAttribute("http://schemas.android.com/apk/res/android", "layout_width");
        String heightStr = component.getAttribute("http://schemas.android.com/apk/res/android", "layout_height");
        if (rl == null && rr == null) {
            right = -1;
        }
        if (ll == null && lr == null) {
            left = -1;
        }
        if (tt == null && tb == null) {
            top = -1;
        }
        if (bb == null && bt == null) {
            bottom = -1;
        }
        boolean showVerticalSlider = bottom >= 0 && top >= 0;
        boolean showHorizontalSlider = left >= 0 && right >= 0;
        this.mVerticalSlider.setEnabled(showVerticalSlider);
        this.mHorizontalSlider.setEnabled(showHorizontalSlider);
        this.mHorizontalSlider.invalidate();
        this.mVerticalSlider.invalidate();
        this.mVerticalSlider.setToolTipText(showVerticalSlider ? VERTICAL_TOOL_TIP_TEXT : null);
        this.mHorizontalSlider.setToolTipText(showHorizontalSlider ? HORIZONTAL_TOOL_TIP_TEXT : null);
        float horizBias = 0.5f;
        if (hbias != null && hbias.length() > 0) {
            horizBias = Float.parseFloat(hbias);
        }
        float vertBias = 0.5f;
        if (vbias != null && vbias.length() > 0) {
            vertBias = Float.parseFloat(vbias);
        }
        this.mHorizontalSlider.setValue((int)(horizBias * 100.0f));
        this.mVerticalSlider.setValue(100 - (int)(vertBias * 100.0f));
        int widthVal = 0;
        int heightValue = 0;
        if ("wrap_content".equals(widthStr)) {
            widthVal = 2;
        } else if (SIZE_ANY.equals(widthStr)) {
            widthVal = 1;
        } else {
            this.mWidgetWidthCache = widthStr;
        }
        this.updateCacheSize(heightStr, heightValue);
        this.mMain.configureUi(bottom, top, left, right, basline != null, widthVal, heightValue);
    }

    private int updateCacheSize(String heightStr, int heightValue) {
        Configuration configuration = this.mComponent.getModel().getConfiguration();
        float scale = (float)configuration.getDensity().getDpiValue() / 160.0f;
        if (this.mWidgetWidthCache == null) {
            this.mWidgetWidthCache = String.valueOf((int)Math.max((double)((float)this.mComponent.w / scale), 1.0)) + "dp";
        }
        if ("wrap_content".equals(heightStr)) {
            heightValue = 2;
        } else if (SIZE_ANY.equals(heightStr)) {
            heightValue = 1;
        } else {
            this.mWidgetHeightCache = heightStr;
        }
        if (this.mWidgetHeightCache == null) {
            this.mWidgetHeightCache = String.valueOf((int)Math.max((double)((float)this.mComponent.h / scale), 1.0)) + "dp";
        }
        return heightValue;
    }

    private void widgetModified() {
        if (this.mWidget == null) {
            return;
        }
        if (!this.mWidgetModified) {
            this.mConstraintModel.getSelection().addModifiedWidget(this.mWidget);
        }
        this.mWidgetModified = true;
        this.mConstraintModel.getDrawConstraintModels().forEach(DrawConstraintModel::repaint);
        this.saveWidget();
    }

    private void saveWidget() {
        this.mConstraintModel.requestSaveToXML();
        this.mWidgetModified = false;
    }

    private void setMargin(ConstraintAnchor.Type type, int margin) {
        if (this.mWidget == null) {
            return;
        }
        ConstraintAnchor anchor = this.mWidget.getAnchor(type);
        if (anchor != null) {
            if (margin == -1) {
                anchor.reset();
            } else {
                anchor.setMargin(margin);
            }
            this.widgetModified();
        }
    }

    private void killConstraint(ConstraintAnchor.Type type) {
        if (this.mWidget == null) {
            return;
        }
        ConstraintAnchor anchor = this.mWidget.getAnchor(type);
        anchor.reset();
        this.widgetModified();
    }

    public void setHorizontalBias() {
        if (this.mWidget == null) {
            return;
        }
        float bias = (float)this.mHorizontalSlider.getValue() / 100.0f;
        this.mWidget.setHorizontalBiasPercent(bias);
        this.widgetModified();
    }

    public void setVerticalBias() {
        if (this.mWidget == null) {
            return;
        }
        float bias = 1.0f - (float)this.mVerticalSlider.getValue() / 100.0f;
        this.mWidget.setVerticalBiasPercent(bias);
        this.widgetModified();
    }

    public void setTopMargin(int margin) {
        if (this.mWidget == null) {
            return;
        }
        this.setMargin(ConstraintAnchor.Type.TOP, margin);
    }

    public void setLeftMargin(int margin) {
        if (this.mWidget == null) {
            return;
        }
        this.setMargin(ConstraintAnchor.Type.LEFT, margin);
    }

    public void setRightMargin(int margin) {
        if (this.mWidget == null) {
            return;
        }
        this.setMargin(ConstraintAnchor.Type.RIGHT, margin);
    }

    public void setBottomMargin(int margin) {
        if (this.mWidget == null) {
            return;
        }
        this.setMargin(ConstraintAnchor.Type.BOTTOM, margin);
    }

    public void killTopConstraint() {
        if (this.mWidget == null) {
            return;
        }
        this.killConstraint(ConstraintAnchor.Type.TOP);
    }

    public void killLeftConstraint() {
        if (this.mWidget == null) {
            return;
        }
        this.killConstraint(ConstraintAnchor.Type.LEFT);
    }

    public void killRightConstraint() {
        if (this.mWidget == null) {
            return;
        }
        this.killConstraint(ConstraintAnchor.Type.RIGHT);
    }

    public void killBottomConstraint() {
        if (this.mWidget == null) {
            return;
        }
        this.killConstraint(ConstraintAnchor.Type.BOTTOM);
    }

    public void killBaselineConstraint() {
        this.killConstraint(ConstraintAnchor.Type.BASELINE);
    }

    public void setHorizontalConstraint(int horizontalConstraint) {
        if (this.mWidget == null) {
            return;
        }
        switch (horizontalConstraint) {
            case 1: {
                this.mWidget.setHorizontalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.ANY);
                break;
            }
            case 0: {
                this.mWidget.setHorizontalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.FIXED);
                break;
            }
            case 2: {
                this.mWidget.setHorizontalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.WRAP_CONTENT);
            }
        }
        this.widgetModified();
    }

    public void setVerticalConstraint(int verticalConstraint) {
        if (this.mWidget == null) {
            return;
        }
        switch (verticalConstraint) {
            case 1: {
                this.mWidget.setVerticalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.ANY);
                break;
            }
            case 0: {
                this.mWidget.setVerticalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.FIXED);
                break;
            }
            case 2: {
                this.mWidget.setVerticalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.WRAP_CONTENT);
            }
        }
        this.widgetModified();
    }

    static class WidgetSliderUI
    extends BasicSliderUI {
        static final int thumbSize = 22;
        private static Font sSmallFont = new Font("Helvetica", 0, 10);
        ColorSet mColorSet;

        WidgetSliderUI(JSlider s, ColorSet colorSet) {
            super(s);
            this.mColorSet = colorSet;
        }

        @Override
        protected Dimension getThumbSize() {
            return new Dimension(22, 22);
        }

        @Override
        public void paintTrack(Graphics g) {
            if (this.slider.isEnabled()) {
                super.paintTrack(g);
            }
        }

        @Override
        protected Color getShadowColor() {
            return this.mColorSet.getInspectorStrokeColor();
        }

        @Override
        protected Color getHighlightColor() {
            return this.mColorSet.getInspectorStrokeColor();
        }

        @Override
        protected Color getFocusColor() {
            return new Color(0, 0, 0, 0);
        }

        @Override
        public void paintThumb(Graphics g) {
            String percentText = Integer.toString(this.slider.getValue());
            if (!this.slider.isEnabled()) {
                return;
            }
            g.setColor(this.mColorSet.getInspectorFillColor());
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.fillRoundRect(this.thumbRect.x + 1, this.thumbRect.y + 1, this.thumbRect.width - 2, this.thumbRect.height - 2, this.thumbRect.width - 2, this.thumbRect.height - 2);
            g.setColor(this.mColorSet.getInspectorStrokeColor());
            g.drawRoundRect(this.thumbRect.x + 1, this.thumbRect.y + 1, this.thumbRect.width - 2, this.thumbRect.height - 2, this.thumbRect.width - 2, this.thumbRect.height - 2);
            int x = this.thumbRect.x + this.thumbRect.width / 2;
            int y = this.thumbRect.y + this.thumbRect.height / 2 - 1;
            g.setFont(sSmallFont);
            FontMetrics fm = g.getFontMetrics();
            Rectangle2D bounds = fm.getStringBounds(percentText, g);
            double tw = bounds.getWidth();
            g.setColor(this.mColorSet.getInspectorStrokeColor());
            g.drawString(percentText, (int)((double)x - tw / 2.0), y + fm.getAscent() / 2);
        }
    }

    static class InspectorColorSet
    extends BlueprintColorSet {
        InspectorColorSet() {
            this.mDrawBackground = false;
            this.mDrawWidgetInfos = true;
            this.mInspectorBackgroundColor = new JBColor(0xE8E8E8, 3948353);
            this.mInspectorFillColor = new JBColor(0xDCDCDC, 4540746);
            this.mInspectorHighlightsStrokeColor = JBColor.border();
            this.mInspectorStrokeColor = JBColor.foreground();
        }
    }
}

