/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.ext.jee;

import com.intellij.javaee.artifact.JavaeeArtifactUtil;
import com.intellij.javaee.ejb.facet.EjbFacet;
import com.intellij.javaee.ejb.facet.EjbFacetConfiguration;
import com.intellij.javaee.ejb.facet.EjbFacetType;
import com.intellij.javaee.model.EjbRootDescriptor;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.artifacts.ModifiableArtifact;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementFactory;
import com.intellij.packaging.impl.elements.ArchivePackagingElement;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.idea.maven.ext.jee.JavaeeFacetImporter;
import org.jetbrains.idea.maven.importing.MavenRootModelAdapter;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenProjectsProcessorTask;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.utils.MavenUtil;

public class EjbFacetImporter
extends JavaeeFacetImporter<EjbFacet, EjbFacetConfiguration, EjbFacetType> {
    public EjbFacetImporter() {
        super("org.apache.maven.plugins", "maven-ejb-plugin", "ejb", EjbFacetType.getInstance());
    }

    protected String getTargetExtension(MavenProject p) {
        return "jar";
    }

    @Override
    protected void setupJavaeeFacet(EjbFacet f, MavenProject p) {
        this.setDescriptor(f, EjbRootDescriptor.EJB_JAR_META_DATA, this.makePath(p, new String[]{"src/main/resources/META-INF/ejb-jar.xml"}));
    }

    @Override
    protected ArtifactType getArtifactType(boolean exploded) {
        return exploded ? JavaeeArtifactUtil.getInstance().getExplodedEjbArtifactType() : JavaeeArtifactUtil.getInstance().getEjbJarArtifactType();
    }

    @Override
    protected void setSourceRoots(EjbFacet f, String[] urls) {
        f.setEjbSourceRoots(urls);
    }

    @Override
    protected void ensureArtifactExists(MavenProject mavenProject, IdeModifiableModelsProvider modelsProvider, Module module, boolean exploded) {
        String archiveClientArtifactName;
        Artifact archiveArtifact;
        super.ensureArtifactExists(mavenProject, modelsProvider, module, exploded);
        if (!this.shouldGenerateClient(mavenProject)) {
            return;
        }
        String explodedClientArtifactName = MavenUtil.getEjbClientArtifactName((Module)module, (boolean)true);
        ModifiableArtifactModel artifactModel = modelsProvider.getModifiableArtifactModel();
        Artifact explodedArtifact = artifactModel.findArtifact(explodedClientArtifactName);
        if (explodedArtifact == null || !explodedArtifact.getArtifactType().equals(JavaeeArtifactUtil.getInstance().getExplodedEjbArtifactType())) {
            if (explodedArtifact != null) {
                artifactModel.removeArtifact(explodedArtifact);
            }
            explodedArtifact = artifactModel.addArtifact(explodedClientArtifactName, JavaeeArtifactUtil.getInstance().getExplodedEjbArtifactType());
        }
        if ((archiveArtifact = artifactModel.findArtifact(archiveClientArtifactName = MavenUtil.getEjbClientArtifactName((Module)module, (boolean)false))) == null || !archiveArtifact.getArtifactType().equals(JavaeeArtifactUtil.getInstance().getEjbJarArtifactType())) {
            if (archiveArtifact != null) {
                artifactModel.removeArtifact(archiveArtifact);
            }
            archiveArtifact = artifactModel.addArtifact(archiveClientArtifactName, JavaeeArtifactUtil.getInstance().getEjbJarArtifactType());
        }
        PackagingElement artifactElement = PackagingElementFactory.getInstance().createArtifactElement(explodedArtifact, module.getProject());
        archiveArtifact.getRootElement().addOrFindChild(artifactElement);
    }

    private boolean shouldGenerateClient(MavenProject mavenProject) {
        Element cfg = this.getConfig(mavenProject);
        return cfg != null && Boolean.parseBoolean(cfg.getChildTextTrim("generateClient"));
    }

    @Override
    protected void reimportFacet(IdeModifiableModelsProvider modelsProvider, Module module, MavenRootModelAdapter rootModel, EjbFacet facet, MavenProjectsTree mavenTree, MavenProject mavenProject, MavenProjectChanges changes, Map<MavenProject, String> mavenProjectToModuleName, List<MavenProjectsProcessorTask> postTasks) {
        super.reimportFacet(modelsProvider, module, rootModel, facet, mavenTree, mavenProject, changes, mavenProjectToModuleName, postTasks);
        this.findArtifact(modelsProvider, module, true).getRootElement().addOrFindChild(PackagingElementFactory.getInstance().createModuleOutput(module));
        this.configClientArtifact(modelsProvider, module, rootModel, facet, mavenProject);
    }

    private void configClientArtifact(IdeModifiableModelsProvider modelsProvider, Module module, MavenRootModelAdapter rootModel, EjbFacet facet, MavenProject mavenProject) {
        ModifiableArtifactModel artifactModel = modelsProvider.getModifiableArtifactModel();
        String explodedClientArtifactName = MavenUtil.getEjbClientArtifactName((Module)module, (boolean)true);
        Artifact explodedArtifact = artifactModel.findArtifact(explodedClientArtifactName);
        String archiveClientArtifactName = MavenUtil.getEjbClientArtifactName((Module)module, (boolean)false);
        Artifact archiveArtifact = artifactModel.findArtifact(archiveClientArtifactName);
        if (!this.shouldGenerateClient(mavenProject)) {
            if (explodedArtifact != null) {
                artifactModel.removeArtifact(explodedArtifact);
            }
            if (archiveArtifact != null) {
                artifactModel.removeArtifact(archiveArtifact);
            }
            return;
        }
        assert (explodedArtifact != null);
        assert (archiveArtifact != null);
        ModifiableArtifact modifiableExplodedArtifact = artifactModel.getOrCreateModifiableArtifact(explodedArtifact);
        this.prepareRootElement(facet, modifiableExplodedArtifact.getRootElement(), mavenProject);
        this.reimportSourceRoots(facet, rootModel);
        this.reimportAppServerDescriptors(facet, mavenProject);
        modifiableExplodedArtifact.getRootElement().addOrFindChild(PackagingElementFactory.getInstance().createModuleOutput(module));
        String archiveOutputPath = this.getArchiveOutputPath(mavenProject);
        String targetFileName = this.getTargetFileName(mavenProject, "-client");
        modifiableExplodedArtifact.setOutputPath(archiveOutputPath + "/" + targetFileName);
        ModifiableArtifact modifiableArchiveArtifact = artifactModel.getOrCreateModifiableArtifact(archiveArtifact);
        boolean shouldConfigurePaths = MavenProjectsManager.getInstance((Project)module.getProject()).getImportingSettings().isUseMavenOutput();
        if (shouldConfigurePaths) {
            modifiableArchiveArtifact.setOutputPath(archiveOutputPath);
        }
        CompositePackagingElement root = modifiableArchiveArtifact.getRootElement();
        assert (root instanceof ArchivePackagingElement);
        ((ArchivePackagingElement)root).setArchiveFileName(targetFileName + ".jar");
        modifiableArchiveArtifact.getRootElement().removeAllChildren();
        PackagingElement artifactElement = PackagingElementFactory.getInstance().createArtifactElement((Artifact)modifiableExplodedArtifact, module.getProject());
        modifiableArchiveArtifact.getRootElement().addOrFindChild(artifactElement);
    }

    @Override
    protected void doAddLibraryDependency(IdeModifiableModelsProvider modelsProvider, MavenProject mavenProject, ModifiableArtifact artifact, Library depLibrary, String relativeOutputPath, String jarFileName) {
    }

    @Override
    protected boolean isLinkViaManifest(MavenProject project) {
        return true;
    }

    @Override
    protected boolean shouldIncludeInArtifact(MavenProject project) {
        return false;
    }
}

