/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.storage;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.EventDispatcher;
import gnu.trove.THashSet;
import java.util.EventListener;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class HeavyProcessLatch {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.io.storage.HeavyProcessLatch");
    public static final HeavyProcessLatch INSTANCE = new HeavyProcessLatch();
    private final Set<String> myHeavyProcesses = new THashSet<String>();
    private final EventDispatcher<HeavyProcessListener> myEventDispatcher = EventDispatcher.create(HeavyProcessListener.class);
    private final EventDispatcher<HeavyProcessListener> myUIProcessDispatcher = EventDispatcher.create(HeavyProcessListener.class);
    private volatile Thread myUiActivityThread;
    private volatile long myPrioritizingDeadLine;

    private HeavyProcessLatch() {
    }

    public void addUIActivityListener(@NotNull Disposable parentDisposable, @NotNull HeavyProcessListener listener) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/util/io/storage/HeavyProcessLatch", "addUIActivityListener"));
        }
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/util/io/storage/HeavyProcessLatch", "addUIActivityListener"));
        }
        this.myUIProcessDispatcher.addListener(listener, parentDisposable);
    }

    public void stopThreadPrioritizing() {
        this.myUiActivityThread = null;
        this.myUIProcessDispatcher.getMulticaster().processFinished();
    }

    public boolean isInsideLowPriorityThread() {
        Thread uiThread = this.myUiActivityThread;
        if (uiThread != null && uiThread != Thread.currentThread()) {
            Thread.State state2 = uiThread.getState();
            if (state2 == Thread.State.WAITING || state2 == Thread.State.TIMED_WAITING || state2 == Thread.State.BLOCKED) {
                return false;
            }
            if (System.currentTimeMillis() > this.myPrioritizingDeadLine) {
                this.stopThreadPrioritizing();
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean hasPrioritizedThread() {
        return this.myUiActivityThread != null;
    }

    public static interface HeavyProcessListener
    extends EventListener {
        public void processFinished();
    }
}

