/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jboss.jpdl.el;

import com.intellij.jboss.jpdl.el.JpdlElContextProvider;
import com.intellij.jboss.jpdl.model.JpdlDomModelManager;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.jsp.el.ELContextProvider;
import com.intellij.psi.impl.source.jsp.el.ELLanguage;
import com.intellij.psi.impl.source.jsp.el.ELUtil;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlText;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JpdlElInjector
implements MultiHostInjector {
    private static boolean isJpdlFile(@NotNull XmlFile xmlFile) {
        if (xmlFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlFile", "com/intellij/jboss/jpdl/el/JpdlElInjector", "isJpdlFile"));
        }
        Project project = xmlFile.getProject();
        if (project.isDefault()) {
            return false;
        }
        return JpdlDomModelManager.getInstance(project).isJpdl(xmlFile);
    }

    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement host) {
        List ranges;
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/jboss/jpdl/el/JpdlElInjector", "getLanguagesToInject"));
        }
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/jboss/jpdl/el/JpdlElInjector", "getLanguagesToInject"));
        }
        PsiElement originalElement = host.getOriginalElement();
        PsiFile psiFile = originalElement.getContainingFile();
        if (psiFile instanceof XmlFile && !(psiFile instanceof JspFile) && JpdlElInjector.isJpdlFile((XmlFile)psiFile) && (ranges = ELUtil.getELTextRanges((PsiElement)originalElement, (String)"#{", (String)"}")).size() > 0) {
            for (TextRange textRange : ranges) {
                registrar.startInjecting(ELLanguage.INSTANCE).addPlace(null, null, (PsiLanguageInjectionHost)originalElement, textRange).doneInjecting();
            }
            originalElement.putUserData(ELContextProvider.ourContextProviderKey, (Object)new JpdlElContextProvider(originalElement));
        }
    }

    @NotNull
    public List<? extends Class<? extends PsiElement>> elementsToInjectIn() {
        List<Class> list = Arrays.asList(XmlAttributeValue.class, XmlText.class);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jboss/jpdl/el/JpdlElInjector", "elementsToInjectIn"));
        }
        return list;
    }
}

