/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.diff;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.pom.Navigatable;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.concurrent.Callable;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DiffElement<T> {
    public static final DiffElement[] EMPTY_ARRAY = new DiffElement[0];

    public abstract String getPath();

    @NotNull
    public abstract String getName();

    public String getPresentablePath() {
        return this.getName();
    }

    public abstract long getSize();

    public abstract long getTimeStamp();

    public FileType getFileType() {
        return FileTypeManager.getInstance().getFileTypeByFileName(this.getName());
    }

    public abstract boolean isContainer();

    public abstract DiffElement[] getChildren() throws IOException;

    @Nullable
    public Navigatable getNavigatable(@Nullable Project project) {
        return null;
    }

    @Nullable
    public abstract byte[] getContent() throws IOException;

    @NotNull
    public Charset getCharset() {
        Charset charset = EncodingManager.getInstance().getDefaultCharset();
        if (charset == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/diff/DiffElement", "getCharset"));
        }
        return charset;
    }

    public abstract T getValue();

    public String getSeparator() {
        return "/";
    }

    @Nullable
    public Icon getIcon() {
        return null;
    }

    @NotNull
    public DiffContent createDiffContent(@Nullable Project project, @NotNull ProgressIndicator indicator) throws DiffRequestProducerException, ProcessCanceledException {
        block7: {
            DiffContent diffContent;
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/ide/diff/DiffElement", "createDiffContent"));
            }
            try {
                T src = this.getValue();
                if (!(src instanceof VirtualFile)) break block7;
                diffContent = DiffContentFactory.getInstance().create(project, (VirtualFile)src);
            }
            catch (IOException e) {
                throw new DiffRequestProducerException(e);
            }
            if (diffContent == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/diff/DiffElement", "createDiffContent"));
            }
            return diffContent;
        }
        byte[] content = this.getContent();
        if (content == null) {
            throw new DiffRequestProducerException("Can't get content");
        }
        DocumentContent documentContent = DiffContentFactory.getInstance().create(project, new String(content, this.getCharset()), this.getFileType());
        if (documentContent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/diff/DiffElement", "createDiffContent"));
        }
        return documentContent;
    }

    @Nullable
    public Callable<DiffElement<T>> getElementChooser(Project project) {
        return null;
    }

    public boolean isOperationsEnabled() {
        return false;
    }

    @Nullable
    public DiffElement<?> copyTo(DiffElement<T> container, String relativePath) {
        return null;
    }

    public boolean delete() {
        return false;
    }

    public void refresh(boolean userInitiated) throws IOException {
    }
}

