/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jam;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.jam.JamConverter;
import com.intellij.jam.JamSimpleReference;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ElementPresentationManager;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JamSimpleReferenceConverter<T>
extends JamConverter<T> {
    @Override
    @NotNull
    public PsiReference[] createReferences(JamStringAttributeElement<T> context) {
        PsiLiteral literal = context.getPsiLiteral();
        if (literal == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jam/JamSimpleReferenceConverter", "createReferences"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        PsiReference[] psiReferenceArray = new PsiReference[]{this.createReference(context)};
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jam/JamSimpleReferenceConverter", "createReferences"));
        }
        return psiReferenceArray;
    }

    protected JamSimpleReference<T> createReference(JamStringAttributeElement<T> context) {
        return new JamSimpleReference<T>(context);
    }

    @Nullable
    protected PsiElement getPsiElementFor(@NotNull T target) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/jam/JamSimpleReferenceConverter", "getPsiElementFor"));
        }
        if (target instanceof PsiElement) {
            return (PsiElement)target;
        }
        if (target instanceof CommonModelElement) {
            return ((CommonModelElement)target).getIdentifyingPsiElement();
        }
        return null;
    }

    @NotNull
    protected LookupElement createLookupElementFor(@NotNull T target) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/jam/JamSimpleReferenceConverter", "createLookupElementFor"));
        }
        String name = ElementPresentationManager.getElementName(target);
        if (name != null) {
            LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create(name);
            if (lookupElementBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jam/JamSimpleReferenceConverter", "createLookupElementFor"));
            }
            return lookupElementBuilder;
        }
        PsiElement psiElement = this.getPsiElementFor(target);
        if (psiElement instanceof PsiNamedElement) {
            LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((PsiNamedElement)psiElement).withIcon(ElementPresentationManager.getIcon(target));
            if (lookupElementBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jam/JamSimpleReferenceConverter", "createLookupElementFor"));
            }
            return lookupElementBuilder;
        }
        throw new UnsupportedOperationException("Cannot convert " + target + ", PSI:" + psiElement);
    }

    public LookupElement[] getLookupVariants(JamStringAttributeElement<T> context) {
        return (LookupElement[])ContainerUtil.map2Array(this.getVariants(context), LookupElement.class, (Function)((NotNullFunction)t -> this.createLookupElementFor(t)));
    }

    public Collection<T> getVariants(JamStringAttributeElement<T> context) {
        return Collections.emptyList();
    }

    public PsiElement bindReference(JamStringAttributeElement<T> context, PsiElement element) {
        throw new UnsupportedOperationException();
    }
}

