/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jam.view;

import com.intellij.ide.DeleteProvider;
import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.jam.model.common.CommonModelManager;
import com.intellij.jam.view.JamUserResponse;
import com.intellij.openapi.actionSystem.DataContext;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class JamDeleteProvider
implements DeleteProvider {
    private final Collection<CommonModelElement> myElements;
    private final JamUserResponse myResponse;

    public JamDeleteProvider(Collection<JamDeleteProvider> providers) {
        this.myElements = new THashSet();
        JamUserResponse response = JamUserResponse.QUIET;
        for (JamDeleteProvider provider : providers) {
            this.myElements.addAll(provider.myElements);
            response = provider.myResponse;
        }
        this.myResponse = response;
    }

    public JamDeleteProvider(JamUserResponse response, Collection<CommonModelElement> elements) {
        this.myElements = elements;
        this.myResponse = response;
    }

    public JamDeleteProvider(CommonModelElement element, JamUserResponse response) {
        this(response, Collections.singletonList(element));
    }

    @Override
    public void deleteElement(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/jam/view/JamDeleteProvider", "deleteElement"));
        }
        CommonModelManager.getInstance().deleteModelElements(this.myElements, this.myResponse);
    }

    @Override
    public boolean canDeleteElement(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/jam/view/JamDeleteProvider", "canDeleteElement"));
        }
        for (CommonModelElement element : this.myElements) {
            if (element == null || element.isValid()) continue;
            return false;
        }
        return true;
    }
}

