/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataContextWrapper
implements DataContext,
UserDataHolder {
    private final DataContext myDelegate;
    private final UserDataHolder myDataHolder;

    public DataContextWrapper(@NotNull DataContext delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/openapi/actionSystem/DataContextWrapper", "<init>"));
        }
        this.myDelegate = delegate;
        this.myDataHolder = delegate instanceof UserDataHolder ? (UserDataHolder)delegate : new UserDataHolderBase();
    }

    @Override
    @Nullable
    public Object getData(@NonNls String dataId) {
        return this.myDelegate.getData(dataId);
    }

    @Nullable
    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/actionSystem/DataContextWrapper", "getUserData"));
        }
        return (T)this.myDataHolder.getUserData(key);
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/actionSystem/DataContextWrapper", "putUserData"));
        }
        this.myDataHolder.putUserData(key, value);
    }
}

