/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jps.flex.build;

import com.intellij.flex.FlexCommonBundle;
import com.intellij.flex.FlexCommonUtils;
import com.intellij.flex.build.CompilerConfigGeneratorRt;
import com.intellij.flex.build.FlexBuildTarget;
import com.intellij.flex.build.FlexBuildTargetType;
import com.intellij.flex.model.JpsFlexCompilerProjectExtension;
import com.intellij.flex.model.JpsFlexProjectLevelCompilerOptionsExtension;
import com.intellij.flex.model.bc.JpsFlexBuildConfiguration;
import com.intellij.flex.model.bc.JpsFlexBuildConfigurationManager;
import com.intellij.flex.model.bc.JpsFlexCompilerOptions;
import com.intellij.flex.model.bc.OutputType;
import com.intellij.flex.model.bc.TargetPlatform;
import com.intellij.flex.model.sdk.JpsFlexSdkType;
import com.intellij.flex.model.sdk.JpsFlexmojosSdkType;
import com.intellij.jps.flex.build.CompilerMessageHandlerBase;
import com.intellij.jps.flex.build.FlexBuilderUtils;
import com.intellij.jps.flex.build.FlexCompilerProcessHandler;
import com.intellij.jps.flex.build.JpsBuiltInFlexCompilerHandler;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.PathUtilRt;
import com.intellij.util.concurrency.Semaphore;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.BuildOutputConsumer;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.builders.FileProcessor;
import org.jetbrains.jps.cmdline.ProjectDescriptor;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.incremental.StopBuildException;
import org.jetbrains.jps.incremental.TargetBuilder;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.incremental.messages.ProgressMessage;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.library.sdk.JpsSdk;
import org.jetbrains.jps.model.module.JpsModule;

public class FlexBuilder
extends TargetBuilder<BuildRootDescriptor, FlexBuildTarget> {
    private static Logger LOG = Logger.getInstance((String)FlexBuilder.class.getName());
    private JpsBuiltInFlexCompilerHandler myBuiltInCompilerHandler;

    protected FlexBuilder() {
        super(Collections.singletonList(FlexBuildTargetType.INSTANCE));
    }

    @NotNull
    public String getPresentableName() {
        if ("Flash Compiler" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jps/flex/build/FlexBuilder", "getPresentableName"));
        }
        return "Flash Compiler";
    }

    public void buildStarted(CompileContext context) {
        super.buildStarted(context);
        this.myBuiltInCompilerHandler = new JpsBuiltInFlexCompilerHandler(context.getProjectDescriptor().getProject());
    }

    public void buildFinished(CompileContext context) {
        LOG.assertTrue(this.myBuiltInCompilerHandler.getActiveCompilationsNumber() == 0, (Object)(this.myBuiltInCompilerHandler.getActiveCompilationsNumber() + " Flex compilation(s) are not finished!"));
        this.myBuiltInCompilerHandler.stopCompilerProcess();
        this.myBuiltInCompilerHandler = null;
        FlexCommonUtils.deleteTempFlexConfigFiles((String)context.getProjectDescriptor().getProject().getName());
        super.buildFinished(context);
    }

    public void build(final @NotNull FlexBuildTarget buildTarget, @NotNull DirtyFilesHolder<BuildRootDescriptor, FlexBuildTarget> holder, @NotNull BuildOutputConsumer outputConsumer, @NotNull CompileContext context) throws ProjectBuildException, IOException {
        if (buildTarget == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildTarget", "com/intellij/jps/flex/build/FlexBuilder", "build"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/jps/flex/build/FlexBuilder", "build"));
        }
        if (outputConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputConsumer", "com/intellij/jps/flex/build/FlexBuilder", "build"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/jps/flex/build/FlexBuilder", "build"));
        }
        final ArrayList<String> dirtyFilePaths = new ArrayList<String>();
        holder.processDirtyFiles((FileProcessor)new FileProcessor<BuildRootDescriptor, FlexBuildTarget>(){

            public boolean apply(FlexBuildTarget target, File file, BuildRootDescriptor root) throws IOException {
                assert (target == buildTarget);
                dirtyFilePaths.add(file.getPath());
                return true;
            }
        });
        if (LOG.isDebugEnabled()) {
            StringBuilder b = new StringBuilder();
            b.append(buildTarget.getId()).append(", ").append("dirty files: ").append(dirtyFilePaths.size());
            if (dirtyFilePaths.size() < 10) {
                for (String path : dirtyFilePaths) {
                    b.append('\n').append(path);
                }
            }
            LOG.debug(b.toString());
        }
        JpsFlexBuildConfiguration mainBC = buildTarget.getBC();
        List<JpsFlexBuildConfiguration> bcsToCompile = FlexBuilder.getAllBCsToCompile(mainBC);
        if (!FlexCommonUtils.isFlexUnitBC((JpsFlexBuildConfiguration)mainBC) && !FlexBuilder.isFlexmojosBCWithUpdatedConfigFile(mainBC)) {
            if (dirtyFilePaths.isEmpty()) {
                boolean outputFilesExist = true;
                for (JpsFlexBuildConfiguration bc : bcsToCompile) {
                    if (new File(bc.getActualOutputFilePath()).isFile()) continue;
                    outputFilesExist = false;
                    LOG.debug("recompile because output file doesn't exist: " + bc.getActualOutputFilePath());
                    break;
                }
                if (outputFilesExist) {
                    return;
                }
            } else if (mainBC.getNature().isApp() && FlexBuilder.isOnlyWrapperFilesDirty(mainBC, dirtyFilePaths)) {
                LOG.debug("only wrapper files dirty");
                FlexBuilderUtils.performPostCompileActions(context, mainBC, dirtyFilePaths, outputConsumer);
                return;
            }
        }
        for (JpsFlexBuildConfiguration bc : bcsToCompile) {
            Status status = FlexBuilder.compileBuildConfiguration(context, bc, this.myBuiltInCompilerHandler);
            switch (status) {
                case Ok: {
                    outputConsumer.registerOutputFile(new File(mainBC.getActualOutputFilePath()), dirtyFilePaths);
                    FlexBuilderUtils.performPostCompileActions(context, bc, dirtyFilePaths, outputConsumer);
                    context.processMessage((BuildMessage)new CompilerMessage(FlexBuilderUtils.getCompilerName(bc), BuildMessage.Kind.INFO, FlexCommonBundle.message((String)"compilation.successful", (Object[])new Object[0])));
                    break;
                }
                case Failed: {
                    String message = bc.getOutputType() == OutputType.Application ? FlexCommonBundle.message((String)"compilation.failed", (Object[])new Object[0]) : FlexCommonBundle.message((String)"compilation.failed.dependent.will.be.skipped", (Object[])new Object[0]);
                    context.processMessage((BuildMessage)new CompilerMessage(FlexBuilderUtils.getCompilerName(bc), BuildMessage.Kind.INFO, message));
                    throw new StopBuildException();
                }
                case Cancelled: {
                    context.processMessage((BuildMessage)new CompilerMessage(FlexBuilderUtils.getCompilerName(bc), BuildMessage.Kind.INFO, FlexCommonBundle.message((String)"compilation.cancelled", (Object[])new Object[0])));
                    return;
                }
            }
        }
    }

    private static boolean isFlexmojosBCWithUpdatedConfigFile(JpsFlexBuildConfiguration bc) {
        String configFilePath = bc.getCompilerOptions().getAdditionalConfigFilePath();
        if (configFilePath.isEmpty() || !configFilePath.contains("/.idea/flexmojos/")) {
            return false;
        }
        File configFile = new File(configFilePath);
        File outputFile = new File(bc.getActualOutputFilePath());
        return configFile.lastModified() > outputFile.lastModified();
    }

    private static boolean isOnlyWrapperFilesDirty(JpsFlexBuildConfiguration bc, Collection<String> dirtyFilePaths) {
        if (bc.getTargetPlatform() == TargetPlatform.Web && bc.isUseHtmlWrapper() && !bc.getWrapperTemplatePath().isEmpty()) {
            for (String dirtyFilePath : dirtyFilePaths) {
                if (FileUtil.isAncestor((String)bc.getWrapperTemplatePath(), (String)dirtyFilePath, (boolean)true)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static List<JpsFlexBuildConfiguration> getAllBCsToCompile(JpsFlexBuildConfiguration bc) {
        ArrayList<JpsFlexBuildConfiguration> result = new ArrayList<JpsFlexBuildConfiguration>(1 + bc.getRLMs().size() + bc.getCssFilesToCompile().size());
        result.add(bc);
        if (FlexCommonUtils.canHaveRLMsAndRuntimeStylesheets((JpsFlexBuildConfiguration)bc)) {
            for (JpsFlexBuildConfiguration.RLMInfo rlm : bc.getRLMs()) {
                result.add(FlexBuilder.createRlmBC(bc, rlm));
            }
            for (String cssPath : bc.getCssFilesToCompile()) {
                if (!new File(cssPath).isFile()) continue;
                result.add(FlexBuilder.createCssBC(bc, cssPath));
            }
        }
        return result;
    }

    private static JpsFlexBuildConfiguration createRlmBC(JpsFlexBuildConfiguration mainBC, JpsFlexBuildConfiguration.RLMInfo rlm) {
        JpsFlexBuildConfiguration rlmBC = ((JpsFlexBuildConfigurationManager)mainBC.getModule().getProperties()).createTemporaryCopyForCompilation(mainBC);
        rlmBC.setOutputType(OutputType.RuntimeLoadedModule);
        rlmBC.setOptimizeFor(rlm.OPTIMIZE ? mainBC.getName() : "");
        String subdir = PathUtilRt.getParentPath((String)rlm.OUTPUT_FILE);
        String outputFileName = PathUtilRt.getFileName((String)rlm.OUTPUT_FILE);
        rlmBC.setMainClass(rlm.MAIN_CLASS);
        rlmBC.setOutputFileName(outputFileName);
        if (!subdir.isEmpty()) {
            String outputFolder = PathUtilRt.getParentPath((String)mainBC.getActualOutputFilePath());
            rlmBC.setOutputFolder(outputFolder + "/" + subdir);
        }
        rlmBC.setUseHtmlWrapper(false);
        rlmBC.setRLMs(Collections.emptyList());
        rlmBC.setCssFilesToCompile(Collections.emptyList());
        JpsFlexCompilerOptions compilerOptions = rlmBC.getCompilerOptions();
        compilerOptions.setResourceFilesMode(JpsFlexCompilerOptions.ResourceFilesMode.None);
        String additionalOptions = compilerOptions.getAdditionalOptions();
        additionalOptions = FlexCommonUtils.removeOptions((String)additionalOptions, (String[])new String[]{"link-report"});
        additionalOptions = FlexCommonUtils.fixSizeReportOption((String)additionalOptions, (String)StringUtil.getShortName((String)rlmBC.getMainClass()));
        compilerOptions.setAdditionalOptions(additionalOptions);
        return rlmBC;
    }

    private static JpsFlexBuildConfiguration createCssBC(JpsFlexBuildConfiguration mainBC, String cssPath) {
        JpsFlexBuildConfiguration cssBC = ((JpsFlexBuildConfigurationManager)mainBC.getModule().getProperties()).createTemporaryCopyForCompilation(mainBC);
        cssBC.setOutputType(OutputType.Application);
        cssBC.setMainClass(cssPath);
        cssBC.setOutputFileName(FileUtil.getNameWithoutExtension((String)PathUtilRt.getFileName((String)cssPath)) + ".swf");
        String cssDirPath = PathUtilRt.getParentPath((String)cssPath);
        String relativeToRoot = FlexCommonUtils.getPathRelativeToSourceRoot((JpsModule)mainBC.getModule(), (String)cssDirPath);
        if (relativeToRoot == null) {
            relativeToRoot = FlexCommonUtils.getPathRelativeToContentRoot((JpsModule)mainBC.getModule(), (String)cssDirPath);
        }
        if (!StringUtil.isEmpty((String)relativeToRoot)) {
            String outputFolder = PathUtilRt.getParentPath((String)mainBC.getActualOutputFilePath());
            cssBC.setOutputFolder(outputFolder + "/" + relativeToRoot);
        }
        cssBC.setUseHtmlWrapper(false);
        cssBC.setRLMs(Collections.emptyList());
        cssBC.setCssFilesToCompile(Collections.emptyList());
        JpsFlexCompilerOptions compilerOptions = cssBC.getCompilerOptions();
        compilerOptions.setResourceFilesMode(JpsFlexCompilerOptions.ResourceFilesMode.None);
        String additionalOptions = compilerOptions.getAdditionalOptions();
        additionalOptions = FlexCommonUtils.removeOptions((String)additionalOptions, (String[])new String[]{"link-report"});
        additionalOptions = FlexCommonUtils.fixSizeReportOption((String)additionalOptions, (String)FileUtil.getNameWithoutExtension((String)PathUtilRt.getFileName((String)cssPath)));
        compilerOptions.setAdditionalOptions(additionalOptions);
        return cssBC;
    }

    private static Status compileBuildConfiguration(CompileContext context, JpsFlexBuildConfiguration bc, JpsBuiltInFlexCompilerHandler builtInCompilerHandler) {
        FlexBuilder.setProgressMessage(context, bc);
        String compilerName = FlexBuilderUtils.getCompilerName(bc);
        try {
            List<File> configFiles = FlexBuilder.createConfigFiles(bc, context.getProjectDescriptor());
            String outputFilePath = bc.getActualOutputFilePath();
            if (!FlexBuilder.ensureCanCreateFile(new File(outputFilePath))) {
                context.processMessage((BuildMessage)new CompilerMessage(compilerName, BuildMessage.Kind.ERROR, FlexCommonBundle.message((String)"failed.to.create.file", (Object[])new Object[]{bc.getActualOutputFilePath()})));
                return Status.Failed;
            }
            return FlexBuilder.doCompile(context, bc, configFiles, compilerName, builtInCompilerHandler);
        }
        catch (IOException e) {
            context.processMessage((BuildMessage)new CompilerMessage(compilerName, BuildMessage.Kind.ERROR, e.getMessage()));
            return Status.Failed;
        }
    }

    private static boolean ensureCanCreateFile(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/jps/flex/build/FlexBuilder", "ensureCanCreateFile"));
        }
        int maxAttempts = 3;
        for (int i = 0; i < 3; ++i) {
            if (FileUtil.ensureCanCreateFile((File)file)) {
                return true;
            }
            try {
                Thread.sleep(10L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return false;
    }

    private static void setProgressMessage(CompileContext context, JpsFlexBuildConfiguration bc) {
        String postfix;
        String string = postfix = bc.isTempBCForCompilation() ? " - " + FlexCommonUtils.getBCSpecifier((JpsFlexBuildConfiguration)bc) : "";
        if (!bc.getName().equals(bc.getModule().getName())) {
            postfix = postfix + " (module " + bc.getModule().getName() + ")";
        }
        context.processMessage((BuildMessage)new ProgressMessage(FlexCommonBundle.message((String)"compiling", (Object[])new Object[]{bc.getName() + postfix})));
    }

    private static List<File> createConfigFiles(JpsFlexBuildConfiguration bc, ProjectDescriptor projectDescriptor) throws IOException {
        ArrayList<File> configFiles = new ArrayList<File>(2);
        configFiles.add(CompilerConfigGeneratorRt.getOrCreateConfigFile((JpsFlexBuildConfiguration)bc, (ProjectDescriptor)projectDescriptor));
        String additionalConfigFilePath = bc.getCompilerOptions().getAdditionalConfigFilePath();
        if (!bc.isTempBCForCompilation() && !additionalConfigFilePath.isEmpty()) {
            File additionalConfigFile = new File(additionalConfigFilePath);
            if (!additionalConfigFile.isFile()) {
                throw new IOException(FlexCommonBundle.message((String)"additional.config.file.not.found.for.bc.0.of.module.1", (Object[])new Object[]{additionalConfigFilePath, bc.getName(), bc.getModule().getName()}));
            }
            configFiles.add(additionalConfigFile);
        }
        return configFiles;
    }

    private static Status doCompile(CompileContext context, JpsFlexBuildConfiguration bc, List<File> configFiles, String compilerName, JpsBuiltInFlexCompilerHandler builtInCompilerHandler) {
        boolean builtIn;
        boolean app = bc.getOutputType() != OutputType.Library;
        JpsSdk sdk = bc.getSdk();
        assert (sdk != null);
        boolean asc20 = bc.isPureAs() && FlexCommonUtils.containsASC20((String)sdk.getHomePath()) && (JpsFlexCompilerProjectExtension.getInstance((JpsProject)bc.getModule().getProject()).PREFER_ASC_20 || FlexCommonUtils.isAirSdkWithoutFlex((JpsSdk)sdk));
        boolean bl = builtIn = !asc20 && JpsFlexCompilerProjectExtension.getInstance((JpsProject)bc.getModule().getProject()).USE_BUILT_IN_COMPILER && builtInCompilerHandler.canBeUsedForSdk(sdk.getHomePath());
        if (builtIn) {
            return FlexBuilder.doCompileWithBuiltInCompiler(context, bc, configFiles, compilerName, builtInCompilerHandler);
        }
        List<String> compilerCommand = asc20 ? FlexBuilder.getASC20Command(bc.getModule().getProject(), sdk, app) : FlexBuilder.getMxmlcCompcCommand(bc.getModule().getProject(), sdk, app);
        List<String> command = FlexBuilder.buildCommand(compilerCommand, configFiles, bc);
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        processBuilder.redirectErrorStream(true);
        processBuilder.directory(new File(FlexCommonUtils.getFlexCompilerWorkDirPath((JpsProject)bc.getModule().getProject())));
        try {
            Process process = processBuilder.start();
            FlexCompilerProcessHandler processHandler = new FlexCompilerProcessHandler(context, process, asc20, compilerName, StringUtil.join(command, (String)" "));
            processHandler.startNotify();
            processHandler.waitFor();
            return processHandler.isCancelled() ? Status.Cancelled : (processHandler.isCompilationFailed() ? Status.Failed : Status.Ok);
        }
        catch (IOException e) {
            context.processMessage((BuildMessage)new CompilerMessage(compilerName, BuildMessage.Kind.ERROR, e.getMessage()));
            return Status.Failed;
        }
    }

    private static Status doCompileWithBuiltInCompiler(CompileContext context, JpsFlexBuildConfiguration bc, List<File> configFiles, String compilerName, JpsBuiltInFlexCompilerHandler builtInCompilerHandler) {
        try {
            builtInCompilerHandler.startCompilerIfNeeded(bc.getSdk(), context, compilerName);
        }
        catch (IOException e) {
            context.processMessage((BuildMessage)new CompilerMessage(compilerName, BuildMessage.Kind.ERROR, e.toString()));
            return Status.Failed;
        }
        List<String> mxmlcOrCompc = Collections.singletonList(bc.getOutputType() == OutputType.Library ? "compc" : "mxmlc");
        List<String> command = FlexBuilder.buildCommand(mxmlcOrCompc, configFiles, bc);
        String plainCommand = StringUtil.join(command, (Function)new Function<String, String>(){

            public String fun(String s) {
                return s.indexOf(32) >= 0 && (!s.startsWith("\"") || !s.endsWith("\"")) ? '\"' + s + '\"' : s;
            }
        }, (String)" ");
        final Semaphore semaphore = new Semaphore();
        semaphore.down();
        context.processMessage((BuildMessage)new CompilerMessage(compilerName, BuildMessage.Kind.INFO, plainCommand));
        BuiltInCompilerListener listener = new BuiltInCompilerListener(context, compilerName, new Runnable(){

            @Override
            public void run() {
                semaphore.up();
            }
        });
        builtInCompilerHandler.sendCompilationCommand(plainCommand, listener);
        semaphore.waitFor();
        builtInCompilerHandler.removeListener(listener);
        return listener.isCompilationCancelled() ? Status.Cancelled : (listener.isCompilationFailed() ? Status.Failed : Status.Ok);
    }

    private static List<String> getASC20Command(JpsProject project, JpsSdk<?> flexSdk, boolean isApp) {
        String mainClass = isApp ? "com.adobe.flash.compiler.clients.MXMLC" : "com.adobe.flash.compiler.clients.COMPC";
        String additionalClasspath = flexSdk.getSdkType() == JpsFlexmojosSdkType.INSTANCE ? null : FileUtil.toSystemDependentName((String)(flexSdk.getHomePath() + "/lib/compiler.jar"));
        return FlexCommonUtils.getCommandLineForSdkTool((JpsProject)project, flexSdk, additionalClasspath, (String)mainClass);
    }

    private static List<String> getMxmlcCompcCommand(JpsProject project, JpsSdk<?> flexSdk, boolean isApp) {
        String mainClass = isApp ? (StringUtil.compareVersionNumbers((String)flexSdk.getVersionString(), (String)"4") >= 0 ? "flex2.tools.Mxmlc" : "flex2.tools.Compiler") : "flex2.tools.Compc";
        String additionalClasspath = FileUtil.toSystemDependentName((String)FlexCommonUtils.getPathToBundledJar((String)"idea-flex-compiler-fix.jar"));
        if (flexSdk.getSdkType() == JpsFlexSdkType.INSTANCE) {
            additionalClasspath = additionalClasspath + File.pathSeparator + FileUtil.toSystemDependentName((String)(flexSdk.getHomePath() + "/lib/compc.jar"));
        }
        return FlexCommonUtils.getCommandLineForSdkTool((JpsProject)project, flexSdk, (String)additionalClasspath, (String)mainClass);
    }

    private static List<String> buildCommand(List<String> compilerCommand, List<File> configFiles, JpsFlexBuildConfiguration bc) {
        ArrayList<String> command = new ArrayList<String>(compilerCommand);
        for (File configFile : configFiles) {
            command.add("-load-config=" + configFile.getPath());
        }
        JpsSdk sdk = bc.getSdk();
        assert (sdk != null);
        FlexBuilder.addAdditionalOptions(command, (JpsModule)bc.getModule(), sdk.getHomePath(), JpsFlexProjectLevelCompilerOptionsExtension.getProjectLevelCompilerOptions((JpsProject)bc.getModule().getProject()).getAdditionalOptions());
        FlexBuilder.addAdditionalOptions(command, (JpsModule)bc.getModule(), sdk.getHomePath(), ((JpsFlexBuildConfigurationManager)bc.getModule().getProperties()).getModuleLevelCompilerOptions().getAdditionalOptions());
        FlexBuilder.addAdditionalOptions(command, (JpsModule)bc.getModule(), sdk.getHomePath(), bc.getCompilerOptions().getAdditionalOptions());
        return command;
    }

    private static void addAdditionalOptions(List<String> command, JpsModule module, String sdkHome, String additionalOptions) {
        if (!StringUtil.isEmpty((String)additionalOptions)) {
            for (String s : StringUtil.split((String)additionalOptions, (String)" ")) {
                command.add(FlexCommonUtils.replacePathMacros((String)s, (JpsModule)module, (String)sdkHome));
            }
        }
    }

    private static class BuiltInCompilerListener
    extends CompilerMessageHandlerBase
    implements JpsBuiltInFlexCompilerHandler.Listener {
        private final Runnable myOnCompilationFinishedRunnable;

        public BuiltInCompilerListener(CompileContext context, String compilerName, Runnable onCompilationFinishedRunnable) {
            super(context, false, compilerName);
            this.myOnCompilationFinishedRunnable = onCompilationFinishedRunnable;
        }

        @Override
        public void textAvailable(String text) {
            this.handleText(text);
        }

        @Override
        public void compilationFinished() {
            this.registerCompilationFinished();
            this.myOnCompilationFinishedRunnable.run();
        }

        @Override
        protected void onCancelled() {
            this.compilationFinished();
        }
    }

    private static enum Status {
        Ok,
        Failed,
        Cancelled;

    }
}

