/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.jsp.jspJava;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.PsiElementBase;
import com.intellij.psi.impl.light.LightClassReference;
import com.intellij.psi.impl.light.LightPackageReference;
import com.intellij.psi.impl.source.jsp.jspJava.JspxImportList;
import com.intellij.psi.impl.source.jsp.jspJava.JspxImportListAttribute;
import com.intellij.psi.impl.source.jsp.jspJava.JspxImportStatement;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JspxImportStatementImpl
extends PsiElementBase
implements JspxImportStatement {
    private final JspxImportList myImportList;
    private final JspxImportListAttribute myListAttribute;
    private final TextRange myTextRange;
    private String myFqn;
    private Boolean myOnDemand;

    public JspxImportStatementImpl(@NotNull JspxImportList list, @NotNull JspxImportListAttribute importList, @NotNull TextRange textRange) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/psi/impl/source/jsp/jspJava/JspxImportStatementImpl", "<init>"));
        }
        if (importList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importList", "com/intellij/psi/impl/source/jsp/jspJava/JspxImportStatementImpl", "<init>"));
        }
        if (textRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textRange", "com/intellij/psi/impl/source/jsp/jspJava/JspxImportStatementImpl", "<init>"));
        }
        this.myFqn = null;
        this.myOnDemand = null;
        this.myImportList = list;
        this.myListAttribute = importList;
        this.myTextRange = textRange;
    }

    @NotNull
    public String getQualifiedName() {
        if (this.myFqn == null) {
            String text = this.getText();
            this.myFqn = StringUtil.trimEnd((String)text, (String)".*");
        }
        String string = this.myFqn;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/jspJava/JspxImportStatementImpl", "getQualifiedName"));
        }
        return string;
    }

    public boolean isOnDemand() {
        if (this.myOnDemand != null) {
            return this.myOnDemand;
        }
        String text = this.getText();
        this.myOnDemand = StringUtil.endsWithChar((CharSequence)text, (char)'*');
        return this.myOnDemand;
    }

    public final PsiJavaCodeReferenceElement getImportReference() {
        PsiElement resolved = this.resolve();
        PsiJavaCodeReferenceElement element = this.getResolvingReference(resolved);
        return element != null ? element : new LightClassReference(this.getManager(), this.getText(), this.getQualifiedName(), this.getResolveScope()){

            public PsiElement getParent() {
                return JspxImportStatementImpl.this;
            }
        };
    }

    @Nullable
    protected PsiJavaCodeReferenceElement getResolvingReference(PsiElement resolved) {
        if (resolved instanceof PsiPackage) {
            return new LightPackageReference(this.getManager(), (PsiPackage)resolved){

                public PsiElement getParent() {
                    return JspxImportStatementImpl.this;
                }
            };
        }
        if (resolved instanceof PsiClass) {
            return new LightClassReference(this.getManager(), this.getQualifiedName(), (PsiClass)resolved){

                public PsiElement getParent() {
                    return JspxImportStatementImpl.this;
                }
            };
        }
        return null;
    }

    public PsiElement resolve() {
        PsiManager psiManager = this.getManager();
        String qName = this.getQualifiedName();
        PsiClass aClass = JavaPsiFacade.getInstance((Project)psiManager.getProject()).findClass(qName, this.getResolveScope());
        if (aClass != null) {
            return aClass;
        }
        if (this.isOnDemand()) {
            return JavaPsiFacade.getInstance((Project)psiManager.getProject()).findPackage(qName);
        }
        return null;
    }

    @NotNull
    public Language getLanguage() {
        Language language = StdFileTypes.JSPX.getLanguage();
        if (language == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/jspJava/JspxImportStatementImpl", "getLanguage"));
        }
        return language;
    }

    public PsiManager getManager() {
        return this.myImportList.getManager();
    }

    @NotNull
    public PsiElement[] getChildren() {
        if (PsiElement.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/jspJava/JspxImportStatementImpl", "getChildren"));
        }
        return PsiElement.EMPTY_ARRAY;
    }

    public PsiElement getParent() {
        return this.myImportList;
    }

    public PsiFile getContainingFile() {
        return this.myImportList.getContainingFile();
    }

    public TextRange getTextRange() {
        this.myListAttribute.getImportStatements();
        XmlAttributeValue valueElement = this.myListAttribute.getAttribute().getValueElement();
        if (valueElement == null) {
            int endOffset = this.myListAttribute.getAttribute().getTextRange().getEndOffset();
            return new TextRange(endOffset, endOffset);
        }
        return this.myTextRange.shiftRight(valueElement.getTextRange().getStartOffset() + 1);
    }

    public int getStartOffsetInParent() {
        return -1;
    }

    public int getTextLength() {
        this.myListAttribute.getImportStatements();
        return this.myTextRange.getLength();
    }

    public PsiElement findElementAt(int offset) {
        return this;
    }

    public int getTextOffset() {
        return this.getTextRange().getStartOffset();
    }

    public String getText() {
        return this.myTextRange.substring(this.myListAttribute.getAttribute().getValue());
    }

    @NotNull
    public char[] textToCharArray() {
        char[] cArray = this.getText().toCharArray();
        if (cArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/jspJava/JspxImportStatementImpl", "textToCharArray"));
        }
        return cArray;
    }

    public boolean textMatches(@NotNull CharSequence text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/impl/source/jsp/jspJava/JspxImportStatementImpl", "textMatches"));
        }
        return text.toString().equals(this.getText());
    }

    public boolean textMatches(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/jsp/jspJava/JspxImportStatementImpl", "textMatches"));
        }
        return element.getText().equals(this.getText());
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/impl/source/jsp/jspJava/JspxImportStatementImpl", "accept"));
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitImportStatement((PsiImportStatement)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public PsiElement copy() {
        return null;
    }

    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/jsp/jspJava/JspxImportStatementImpl", "add"));
        }
        throw new IncorrectOperationException("Not supported");
    }

    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/jsp/jspJava/JspxImportStatementImpl", "addBefore"));
        }
        throw new IncorrectOperationException("Not supported");
    }

    public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/jsp/jspJava/JspxImportStatementImpl", "addAfter"));
        }
        throw new IncorrectOperationException("Not supported");
    }

    public void checkAdd(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/jsp/jspJava/JspxImportStatementImpl", "checkAdd"));
        }
        throw new IncorrectOperationException("Not supported");
    }

    public void delete() throws IncorrectOperationException {
        this.myListAttribute.delete(this.myListAttribute.getIndex(this));
    }

    public void checkDelete() throws IncorrectOperationException {
        CheckUtil.checkWritable((PsiElement)this);
    }

    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        if (newElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "com/intellij/psi/impl/source/jsp/jspJava/JspxImportStatementImpl", "replace"));
        }
        if (!(newElement instanceof PsiImportStatement)) {
            throw new IncorrectOperationException("Can't replace import statement with " + newElement);
        }
        PsiImportStatement importStatement = (PsiImportStatement)newElement;
        String importText = importStatement.getQualifiedName() + (importStatement.isOnDemand() ? ".*" : "");
        this.myListAttribute.replace(this.myListAttribute.getIndex(this), importText);
        this.clearCaches();
        return this;
    }

    public void clearCaches() {
        this.myFqn = null;
        this.myOnDemand = null;
    }

    public boolean isValid() {
        return this.myImportList.isValid() && this.myListAttribute.getIndex(this) != -1;
    }

    public boolean isWritable() {
        return this.myImportList.isWritable();
    }

    public boolean isPhysical() {
        return false;
    }

    public String toString() {
        return "Jspx import " + this.getQualifiedName();
    }

    public int hashCode() {
        return this.getQualifiedName().hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof JspxImportStatement)) {
            return false;
        }
        JspxImportStatement other = (JspxImportStatement)object;
        PsiFile otherFile = other.getContainingFile();
        PsiFile file = this.getContainingFile();
        return file == otherFile && this.isOnDemand() == other.isOnDemand() && Comparing.strEqual((String)this.getQualifiedName(), (String)other.getQualifiedName());
    }

    public ASTNode getNode() {
        return null;
    }

    public boolean isForeignFileImport() {
        return this.getDeclarationFile().getViewProvider() != this.getContainingFile().getViewProvider();
    }

    public PsiFile getDeclarationFile() {
        return this.myListAttribute.getAttribute().getContainingFile();
    }
}

