/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.fixStack;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.optimization.common.UtilKt;
import org.jetbrains.kotlin.codegen.optimization.fixStack.DecompiledTryDescriptor;
import org.jetbrains.kotlin.codegen.pseudoInsns.PseudoInsn;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LabelNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.TryCatchBlockNode;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000>\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a8\u0010\u0000\u001a\u00020\u00012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a8\u0010\t\u001a\u00020\u00012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\n2\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003H\u0002\u001a\u0010\u0010\f\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a$\u0010\r\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u000eH\u0002\u001a\u0014\u0010\u000f\u001a\u00020\u0010*\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001a\f\u0010\u0013\u001a\u00020\u0014*\u00020\u0012H\u0002\u00a8\u0006\u0015"}, d2={"collectDecompiledTryDescriptors", "", "decompiledTryDescriptorForStart", "", "Lorg/jetbrains/org/objectweb/asm/tree/LabelNode;", "Lorg/jetbrains/kotlin/codegen/optimization/fixStack/DecompiledTryDescriptor;", "decompiledTryDescriptorForHandler", "methodNode", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "insertSaveRestoreStackMarkers", "", "newTryStartLabels", "insertTryCatchBlocksMarkers", "transformTryCatchBlocks", "Ljava/util/HashMap;", "debugString", "", "tcb", "Lorg/jetbrains/org/objectweb/asm/tree/TryCatchBlockNode;", "isDefaultHandlerNode", "", "backend"})
public final class AnalyzeTryCatchBlocksKt {
    private static final boolean isDefaultHandlerNode(@NotNull TryCatchBlockNode $receiver) {
        return Intrinsics.areEqual((Object)$receiver.start, (Object)$receiver.handler);
    }

    private static final String debugString(@NotNull MethodNode $receiver, TryCatchBlockNode tcb) {
        return "TCB<" + $receiver.instructions.indexOf((AbstractInsnNode)tcb.start) + ", " + $receiver.instructions.indexOf((AbstractInsnNode)tcb.end) + ", " + $receiver.instructions.indexOf((AbstractInsnNode)tcb.handler) + ">";
    }

    public static final void insertTryCatchBlocksMarkers(@NotNull MethodNode methodNode) {
        Intrinsics.checkParameterIsNotNull((Object)methodNode, (String)"methodNode");
        if (methodNode.tryCatchBlocks.isEmpty()) {
            return;
        }
        LinkedHashMap decompiledTryDescriptorForStart = MapsKt.linkedMapOf((Pair[])new Pair[0]);
        HashMap decompiledTryDescriptorForHandler = MapsKt.hashMapOf((Pair[])new Pair[0]);
        AnalyzeTryCatchBlocksKt.collectDecompiledTryDescriptors(decompiledTryDescriptorForStart, decompiledTryDescriptorForHandler, methodNode);
        HashMap newTryStartLabels = MapsKt.hashMapOf((Pair[])new Pair[0]);
        AnalyzeTryCatchBlocksKt.insertSaveRestoreStackMarkers(decompiledTryDescriptorForStart, methodNode, newTryStartLabels);
        AnalyzeTryCatchBlocksKt.transformTryCatchBlocks(methodNode, newTryStartLabels);
    }

    /*
     * WARNING - void declaration
     */
    private static final void transformTryCatchBlocks(MethodNode methodNode, HashMap<LabelNode, LabelNode> newTryStartLabels) {
        List list2;
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        Iterable iterable = methodNode.tryCatchBlocks;
        MethodNode methodNode2 = methodNode;
        void var3_4 = $receiver$iv;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void tcb;
            TryCatchBlockNode tryCatchBlockNode = (TryCatchBlockNode)item$iv$iv;
            list2 = destination$iv$iv;
            LabelNode newTryStartLabel = newTryStartLabels.get(tcb.start);
            TryCatchBlockNode tryCatchBlockNode2 = newTryStartLabel == null ? tcb : new TryCatchBlockNode(newTryStartLabel, tcb.end, tcb.handler, tcb.type);
            list2.add(tryCatchBlockNode2);
        }
        methodNode2.tryCatchBlocks = list2 = (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final void insertSaveRestoreStackMarkers(Map<LabelNode, DecompiledTryDescriptor> decompiledTryDescriptorForStart, MethodNode methodNode, Map<LabelNode, LabelNode> newTryStartLabels) {
        HashSet doneTryStartLabels = SetsKt.hashSetOf((Object[])new LabelNode[0]);
        HashSet doneHandlerLabels = SetsKt.hashSetOf((Object[])new LabelNode[0]);
        for (DecompiledTryDescriptor decompiledTryDescriptor : decompiledTryDescriptorForStart.values()) {
            Object it;
            void $receiver;
            DecompiledTryDescriptor decompiledTryDescriptor2 = decompiledTryDescriptor;
            if (!doneTryStartLabels.contains($receiver.getTryStartLabel())) {
                AbstractInsnNode nopNode;
                AbstractInsnNode finger$iv;
                doneTryStartLabels.add($receiver.getTryStartLabel());
                AbstractInsnNode abstractInsnNode = (AbstractInsnNode)$receiver.getTryStartLabel();
                for (finger$iv = $receiver$iv.getNext(); finger$iv != null && !UtilKt.hasOpcode(it = finger$iv); finger$iv = finger$iv.getNext()) {
                }
                if (finger$iv == null) {
                    Intrinsics.throwNpe();
                }
                boolean $receiver$iv = nopNode.getOpcode() == 0;
                if (_Assertions.ENABLED && !$receiver$iv) {
                    it = methodNode.instructions.indexOf(nopNode) + ": try block should start with NOP";
                    throw (Throwable)((Object)new AssertionError(it));
                }
                LabelNode newTryStartLabel = new LabelNode(new Label());
                Map<LabelNode, LabelNode> $i$a$1$assert = newTryStartLabels;
                it = $receiver.getTryStartLabel();
                LabelNode $i$a$1$findNextOrNull = newTryStartLabel;
                $i$a$1$assert.put((LabelNode)it, $i$a$1$findNextOrNull);
                methodNode.instructions.insertBefore(nopNode, (AbstractInsnNode)PseudoInsn.SAVE_STACK_BEFORE_TRY.createInsnNode());
                methodNode.instructions.insertBefore(nopNode, (AbstractInsnNode)newTryStartLabel);
                methodNode.instructions.insert(nopNode, (AbstractInsnNode)PseudoInsn.RESTORE_STACK_IN_TRY_CATCH.createInsnNode());
            }
            for (LabelNode handlerStartLabel : $receiver.getHandlerStartLabels()) {
                AbstractInsnNode storeNode;
                AbstractInsnNode it2;
                AbstractInsnNode finger$iv;
                if (doneHandlerLabels.contains(handlerStartLabel)) continue;
                doneHandlerLabels.add(handlerStartLabel);
                it = (AbstractInsnNode)handlerStartLabel;
                for (finger$iv = $receiver$iv.getNext(); finger$iv != null && !UtilKt.hasOpcode(it2 = finger$iv); finger$iv = finger$iv.getNext()) {
                }
                if (finger$iv == null) {
                    Intrinsics.throwNpe();
                }
                boolean bl = storeNode.getOpcode() == 58;
                if (_Assertions.ENABLED && !bl) {
                    String string = methodNode.instructions.indexOf(storeNode) + ": handler should start with ASTORE";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                methodNode.instructions.insert(storeNode, (AbstractInsnNode)PseudoInsn.RESTORE_STACK_IN_TRY_CATCH.createInsnNode());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void collectDecompiledTryDescriptors(Map<LabelNode, DecompiledTryDescriptor> decompiledTryDescriptorForStart, Map<LabelNode, DecompiledTryDescriptor> decompiledTryDescriptorForHandler, MethodNode methodNode) {
        for (TryCatchBlockNode tcb : methodNode.tryCatchBlocks) {
            void $receiver;
            Object object;
            void key$iv;
            DecompiledTryDescriptor $receiver$iv;
            if (AnalyzeTryCatchBlocksKt.isDefaultHandlerNode(tcb)) {
                boolean bl = decompiledTryDescriptorForHandler.containsKey(tcb.start);
                if (_Assertions.ENABLED && !bl) {
                    StringBuilder stringBuilder = new StringBuilder();
                    TryCatchBlockNode tryCatchBlockNode = tcb;
                    Intrinsics.checkExpressionValueIsNotNull((Object)tryCatchBlockNode, (String)"tcb");
                    String string = stringBuilder.append(AnalyzeTryCatchBlocksKt.debugString(methodNode, tryCatchBlockNode)).append(": default handler should occur after some regular handler").toString();
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
            }
            Map<LabelNode, DecompiledTryDescriptor> $i$a$1$assert = decompiledTryDescriptorForHandler;
            Intrinsics.checkExpressionValueIsNotNull((Object)tcb.handler, (String)"tcb.handler");
            Object value$iv = $receiver$iv.get(key$iv);
            if (value$iv == null) {
                Object object2;
                void key$iv2;
                void $receiver$iv2;
                Map<LabelNode, DecompiledTryDescriptor> map2 = decompiledTryDescriptorForStart;
                Intrinsics.checkExpressionValueIsNotNull((Object)tcb.start, (String)"tcb.start");
                Object value$iv2 = $receiver$iv2.get(key$iv2);
                if (value$iv2 == null) {
                    LabelNode labelNode = tcb.start;
                    Intrinsics.checkExpressionValueIsNotNull((Object)labelNode, (String)"tcb.start");
                    DecompiledTryDescriptor answer$iv = new DecompiledTryDescriptor(labelNode);
                    $receiver$iv2.put(key$iv2, answer$iv);
                    object2 = answer$iv;
                } else {
                    object2 = value$iv2;
                }
                DecompiledTryDescriptor answer$iv = (DecompiledTryDescriptor)object2;
                $receiver$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            DecompiledTryDescriptor decompiledTryDescriptor = (DecompiledTryDescriptor)object;
            $receiver$iv = decompiledTryDescriptor;
            $receiver.getHandlerStartLabels().add(tcb.handler);
            if (!AnalyzeTryCatchBlocksKt.isDefaultHandlerNode(tcb)) continue;
            boolean bl = $receiver.getDefaultHandlerTcb() == null;
            if (_Assertions.ENABLED && !bl) {
                StringBuilder stringBuilder = new StringBuilder();
                TryCatchBlockNode tryCatchBlockNode = tcb;
                Intrinsics.checkExpressionValueIsNotNull((Object)tryCatchBlockNode, (String)"tcb");
                StringBuilder stringBuilder2 = stringBuilder.append(AnalyzeTryCatchBlocksKt.debugString(methodNode, tryCatchBlockNode)).append(": default handler is already found: ");
                TryCatchBlockNode tryCatchBlockNode2 = $receiver.getDefaultHandlerTcb();
                if (tryCatchBlockNode2 == null) {
                    Intrinsics.throwNpe();
                }
                String string = stringBuilder2.append(AnalyzeTryCatchBlocksKt.debugString(methodNode, tryCatchBlockNode2)).toString();
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            $receiver.setDefaultHandlerTcb(tcb);
        }
    }
}

