/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fileClasses;

import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.fileClasses.JvmFileClassInfo;
import org.jetbrains.kotlin.fileClasses.JvmMultifileClassPartInfo;
import org.jetbrains.kotlin.fileClasses.JvmSimpleFileClassInfo;
import org.jetbrains.kotlin.fileClasses.ParsedJvmFileClassAnnotations;
import org.jetbrains.kotlin.load.java.descriptors.UtilKt;
import org.jetbrains.kotlin.load.kotlin.PackagePartClassUtils;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtConstructorCalleeExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFileAnnotationList;
import org.jetbrains.kotlin.psi.KtLiteralStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedCallableMemberDescriptor;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\bH\u0007J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u0018\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u001f\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0000\u00a2\u0006\u0002\b\u001bJ\u0018\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u0018\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0012\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\"H\u0007J\u0014\u0010#\u001a\u0004\u0018\u00010\b2\b\u0010$\u001a\u0004\u0018\u00010%H\u0003J\u0010\u0010&\u001a\u00020\u00042\u0006\u0010!\u001a\u00020\"H\u0007J\u0018\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0007J\u0018\u0010-\u001a\u00020\b2\u0006\u0010.\u001a\u00020\b2\u0006\u0010/\u001a\u00020\bH\u0007J\u0017\u00100\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b1R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0006R\u0011\u0010\u000e\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000b\u00a8\u00062"}, d2={"Lorg/jetbrains/kotlin/fileClasses/JvmFileClassUtil;", "", "()V", "JVM_MULTIFILE_CLASS", "Lorg/jetbrains/kotlin/name/FqName;", "getJVM_MULTIFILE_CLASS", "()Lorg/jetbrains/kotlin/name/FqName;", "JVM_MULTIFILE_CLASS_SHORT", "", "Lorg/jetbrains/annotations/NotNull;", "getJVM_MULTIFILE_CLASS_SHORT", "()Ljava/lang/String;", "JVM_NAME", "getJVM_NAME", "JVM_NAME_SHORT", "getJVM_NAME_SHORT", "findAnnotationEntryOnFileNoResolve", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "shortName", "getDefaultFileClassInfo", "Lorg/jetbrains/kotlin/fileClasses/JvmFileClassInfo;", "getFacadeFqName", "jvmFileClassAnnotations", "Lorg/jetbrains/kotlin/fileClasses/ParsedJvmFileClassAnnotations;", "getFileClassInfo", "getFileClassInfo$frontend_java", "getFileClassInfoForAnnotation", "getFileClassInfoNoResolve", "getHiddenPartFqName", "getImplClassName", "Lorg/jetbrains/kotlin/name/Name;", "callable", "Lorg/jetbrains/kotlin/serialization/deserialization/descriptors/DeserializedCallableMemberDescriptor;", "getLiteralStringFromRestrictedConstExpression", "argumentExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "getPartFqNameForDeserializedCallable", "isFromMultifileClass", "", "declarationElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "manglePartName", "facadeName", "fileName", "parseJvmNameOnFileNoResolve", "parseJvmNameOnFileNoResolve$frontend_java", "frontend.java"})
public final class JvmFileClassUtil {
    @NotNull
    private static final FqName JVM_NAME;
    @NotNull
    private static final String JVM_NAME_SHORT;
    @NotNull
    private static final FqName JVM_MULTIFILE_CLASS;
    @NotNull
    private static final String JVM_MULTIFILE_CLASS_SHORT;
    public static final JvmFileClassUtil INSTANCE;

    @NotNull
    public final FqName getJVM_NAME() {
        return JVM_NAME;
    }

    @NotNull
    public final String getJVM_NAME_SHORT() {
        return JVM_NAME_SHORT;
    }

    @NotNull
    public final FqName getJVM_MULTIFILE_CLASS() {
        return JVM_MULTIFILE_CLASS;
    }

    @NotNull
    public final String getJVM_MULTIFILE_CLASS_SHORT() {
        return JVM_MULTIFILE_CLASS_SHORT;
    }

    @NotNull
    public final JvmFileClassInfo getFileClassInfo$frontend_java(@NotNull KtFile file2, @Nullable ParsedJvmFileClassAnnotations jvmFileClassAnnotations) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        return jvmFileClassAnnotations != null ? this.getFileClassInfoForAnnotation(file2, jvmFileClassAnnotations) : JvmFileClassUtil.getDefaultFileClassInfo(file2);
    }

    private final JvmFileClassInfo getFileClassInfoForAnnotation(KtFile file2, ParsedJvmFileClassAnnotations jvmFileClassAnnotations) {
        return jvmFileClassAnnotations.getMultipleFiles() ? (JvmFileClassInfo)new JvmMultifileClassPartInfo(this.getHiddenPartFqName(file2, jvmFileClassAnnotations), this.getFacadeFqName(file2, jvmFileClassAnnotations)) : (JvmFileClassInfo)new JvmSimpleFileClassInfo(this.getFacadeFqName(file2, jvmFileClassAnnotations), true);
    }

    @JvmStatic
    @NotNull
    public static final JvmFileClassInfo getDefaultFileClassInfo(@NotNull KtFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        FqName fqName2 = file2.getPackageFqName();
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"file.packageFqName");
        String string = file2.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.name");
        return new JvmSimpleFileClassInfo(PackagePartClassUtils.getPackagePartFqName(fqName2, string), false);
    }

    private final FqName getFacadeFqName(KtFile file2, ParsedJvmFileClassAnnotations jvmFileClassAnnotations) {
        FqName fqName2 = file2.getPackageFqName().child(Name.identifier(jvmFileClassAnnotations.getName()));
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"file.packageFqName.child\u2026leClassAnnotations.name))");
        return fqName2;
    }

    @JvmStatic
    @NotNull
    public static final FqName getPartFqNameForDeserializedCallable(@NotNull DeserializedCallableMemberDescriptor callable2) {
        Intrinsics.checkParameterIsNotNull((Object)callable2, (String)"callable");
        Name name2 = JvmFileClassUtil.getImplClassName(callable2);
        if (name2 == null) {
            String string = "No implClassName for " + callable2;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Name implClassName = name2;
        DeclarationDescriptor declarationDescriptor = callable2.getContainingDeclaration();
        if (declarationDescriptor == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor");
        }
        FqName packageFqName = ((PackageFragmentDescriptor)declarationDescriptor).getFqName();
        FqName fqName2 = packageFqName.child(implClassName);
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"packageFqName.child(implClassName)");
        return fqName2;
    }

    @JvmStatic
    @Nullable
    public static final Name getImplClassName(@NotNull DeserializedCallableMemberDescriptor callable2) {
        Intrinsics.checkParameterIsNotNull((Object)callable2, (String)"callable");
        return UtilKt.getImplClassNameForDeserialized(callable2);
    }

    private final FqName getHiddenPartFqName(KtFile file2, ParsedJvmFileClassAnnotations jvmFileClassAnnotations) {
        FqName fqName2 = file2.getPackageFqName();
        String string = jvmFileClassAnnotations.getName();
        String string2 = file2.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"file.name");
        FqName fqName3 = fqName2.child(Name.identifier(JvmFileClassUtil.manglePartName(string, string2)));
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName3, (String)"file.packageFqName.child\u2026ations.name, file.name)))");
        return fqName3;
    }

    @JvmStatic
    @NotNull
    public static final String manglePartName(@NotNull String facadeName, @NotNull String fileName) {
        Intrinsics.checkParameterIsNotNull((Object)facadeName, (String)"facadeName");
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        return facadeName + "__" + PackagePartClassUtils.getFilePartShortName(fileName);
    }

    @JvmStatic
    @NotNull
    public static final JvmFileClassInfo getFileClassInfoNoResolve(@NotNull KtFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        return INSTANCE.getFileClassInfo$frontend_java(file2, INSTANCE.parseJvmNameOnFileNoResolve$frontend_java(file2));
    }

    @Nullable
    public final ParsedJvmFileClassAnnotations parseJvmNameOnFileNoResolve$frontend_java(@NotNull KtFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        KtAnnotationEntry ktAnnotationEntry = JvmFileClassUtil.findAnnotationEntryOnFileNoResolve(file2, JVM_NAME_SHORT);
        if (ktAnnotationEntry == null) {
            return null;
        }
        KtAnnotationEntry jvmName = ktAnnotationEntry;
        Object object = (ValueArgument)CollectionsKt.firstOrNull(jvmName.getValueArguments());
        if (object == null || (object = object.getArgumentExpression()) == null) {
            return null;
        }
        Object nameExpr = object;
        String string = JvmFileClassUtil.getLiteralStringFromRestrictedConstExpression((KtExpression)nameExpr);
        if (string == null) {
            return null;
        }
        String name2 = string;
        if (!Name.isValidIdentifier(name2)) {
            return null;
        }
        String string2 = JVM_MULTIFILE_CLASS_SHORT;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"JVM_MULTIFILE_CLASS_SHORT");
        boolean isMultifileClassPart = JvmFileClassUtil.findAnnotationEntryOnFileNoResolve(file2, string2) != null;
        return new ParsedJvmFileClassAnnotations(name2, isMultifileClassPart);
    }

    @JvmStatic
    @Nullable
    public static final KtAnnotationEntry findAnnotationEntryOnFileNoResolve(@NotNull KtFile file2, @NotNull String shortName) {
        KtAnnotationEntry ktAnnotationEntry;
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)shortName, (String)"shortName");
        Object object = file2.getFileAnnotationList();
        if (object != null && (object = ((KtFileAnnotationList)object).getAnnotationEntries()) != null) {
            Object v2;
            block3: {
                Iterable $receiver$iv = (Iterable)object;
                for (Object element$iv : $receiver$iv) {
                    KtAnnotationEntry it = (KtAnnotationEntry)element$iv;
                    KtExpression ktExpression = it.getCalleeExpression();
                    if (!Intrinsics.areEqual((Object)(ktExpression != null && (ktExpression = ((KtConstructorCalleeExpression)ktExpression).getConstructorReferenceExpression()) != null ? ktExpression.getReferencedName() : null), (Object)shortName)) continue;
                    v2 = element$iv;
                    break block3;
                }
                v2 = null;
            }
            ktAnnotationEntry = v2;
        } else {
            ktAnnotationEntry = null;
        }
        return ktAnnotationEntry;
    }

    @JvmStatic
    private static final String getLiteralStringFromRestrictedConstExpression(KtExpression argumentExpression) {
        KtExpression ktExpression = argumentExpression;
        if (!(ktExpression instanceof KtStringTemplateExpression)) {
            ktExpression = null;
        }
        KtStringTemplateExpression ktStringTemplateExpression = (KtStringTemplateExpression)ktExpression;
        if (ktStringTemplateExpression == null) {
            return null;
        }
        KtStringTemplateExpression stringTemplate = ktStringTemplateExpression;
        KtStringTemplateEntry[] stringTemplateEntries = stringTemplate.getEntries();
        if (((Object[])stringTemplateEntries).length != 1) {
            return null;
        }
        KtStringTemplateEntry ktStringTemplateEntry = stringTemplateEntries[0];
        if (!(ktStringTemplateEntry instanceof KtLiteralStringTemplateEntry)) {
            ktStringTemplateEntry = null;
        }
        KtLiteralStringTemplateEntry ktLiteralStringTemplateEntry = (KtLiteralStringTemplateEntry)ktStringTemplateEntry;
        if (ktLiteralStringTemplateEntry == null) {
            return null;
        }
        KtLiteralStringTemplateEntry singleEntry = ktLiteralStringTemplateEntry;
        return singleEntry.getText();
    }

    @JvmStatic
    public static final boolean isFromMultifileClass(@NotNull KtElement declarationElement, @NotNull DeclarationDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull((Object)declarationElement, (String)"declarationElement");
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        if (DescriptorUtils.isTopLevelDeclaration(descriptor2)) {
            JvmFileClassInfo fileClassInfo = JvmFileClassUtil.getFileClassInfoNoResolve(declarationElement.getContainingKtFile());
            return fileClassInfo.getWithJvmMultifileClass();
        }
        return false;
    }

    private JvmFileClassUtil() {
        INSTANCE = this;
        JVM_NAME = new FqName("kotlin.jvm.JvmName");
        String string = JVM_NAME.shortName().asString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"JVM_NAME.shortName().asString()");
        JVM_NAME_SHORT = string;
        JVM_MULTIFILE_CLASS = new FqName("kotlin.jvm.JvmMultifileClass");
        JVM_MULTIFILE_CLASS_SHORT = JVM_MULTIFILE_CLASS.shortName().asString();
    }

    static {
        new JvmFileClassUtil();
    }
}

