/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.IntentionWrapper;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.inspections.IntentionBasedInspection;
import org.jetbrains.kotlin.idea.intentions.SpecifyTypeExplicitlyIntention;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.idea.quickfix.AddExclExclCallFix;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u00102\u0006\u0010\u0012\u001a\u00020\u0002H\u0016J\n\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\u0017\u0010\u0015\u001a\t\u0018\u00010\u0016\u00a2\u0006\u0002\b\u00172\u0006\u0010\u0012\u001a\u00020\u0002H\u0016R\u0014\u0010\u0007\u001a\u00020\bX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0012\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/HasPlatformTypeInspection;", "Lorg/jetbrains/kotlin/idea/inspections/IntentionBasedInspection;", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "publicAPIOnly", "", "reportPlatformArguments", "(ZZ)V", "problemHighlightType", "Lcom/intellij/codeInspection/ProblemHighlightType;", "getProblemHighlightType", "()Lcom/intellij/codeInspection/ProblemHighlightType;", "problemText", "", "getProblemText", "()Ljava/lang/String;", "additionalFixes", "", "Lcom/intellij/codeInspection/LocalQuickFix;", "element", "createOptionsPanel", "Ljavax/swing/JComponent;", "inspectionTarget", "Lcom/intellij/psi/PsiElement;", "Lorg/jetbrains/annotations/Nullable;", "idea"})
public final class HasPlatformTypeInspection
extends IntentionBasedInspection<KtCallableDeclaration> {
    @NotNull
    private final ProblemHighlightType problemHighlightType;
    @NotNull
    private final String problemText = "Declaration has platform type. Make the type explicit to prevent subtle bugs.";
    @JvmField
    public boolean publicAPIOnly;
    @JvmField
    public boolean reportPlatformArguments;

    @Override
    @NotNull
    protected ProblemHighlightType getProblemHighlightType() {
        return this.problemHighlightType;
    }

    @Override
    @NotNull
    protected String getProblemText() {
        return this.problemText;
    }

    @Override
    @Nullable
    public List<LocalQuickFix> additionalFixes(@NotNull KtCallableDeclaration element2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        KotlinType kotlinType = SpecifyTypeExplicitlyIntention.Companion.dangerousFlexibleTypeOrNull(element2, this.publicAPIOnly, this.reportPlatformArguments);
        if (kotlinType == null) {
            return null;
        }
        KotlinType type2 = kotlinType;
        if (TypeUtils.isNullableType(type2)) {
            PsiElement expression2;
            ASTNode aSTNode = element2.getNode().findChildByType((IElementType)KtTokens.EQ);
            PsiElement psiElement = aSTNode != null && (aSTNode = aSTNode.getPsi()) != null ? PsiUtilsKt.getNextSiblingIgnoringWhitespaceAndComments$default((PsiElement)aSTNode, false, 1, null) : (expression2 = null);
            if (!(expression2 == null || this.reportPlatformArguments && UtilsKt.isFlexibleRecursive(TypeUtils.makeNotNullable(type2)))) {
                return CollectionsKt.listOf((Object)new IntentionWrapper((IntentionAction)new AddExclExclCallFix(expression2), element2.getContainingFile()));
            }
        }
        return null;
    }

    @Override
    @Nullable
    public PsiElement inspectionTarget(@NotNull KtCallableDeclaration element2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        return element2.getNameIdentifier();
    }

    @Nullable
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        panel.addCheckbox("Apply only to public or protected members", "publicAPIOnly");
        panel.addCheckbox("Report for types with platform arguments", "reportPlatformArguments");
        return (JComponent)panel;
    }

    public HasPlatformTypeInspection(boolean publicAPIOnly, boolean reportPlatformArguments) {
        super(Reflection.getOrCreateKotlinClass(SpecifyTypeExplicitlyIntention.class), 1.INSTANCE, null, 4, null);
        this.publicAPIOnly = publicAPIOnly;
        this.reportPlatformArguments = reportPlatformArguments;
        this.problemHighlightType = ProblemHighlightType.WEAK_WARNING;
        this.problemText = "Declaration has platform type. Make the type explicit to prevent subtle bugs.";
    }

    public /* synthetic */ HasPlatformTypeInspection(boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        this(bl, bl2);
    }

    public HasPlatformTypeInspection() {
        this(false, false, 3, null);
    }
}

