/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.DescriptorWithRelation;
import org.jetbrains.kotlin.descriptors.EffectiveVisibility;
import org.jetbrains.kotlin.descriptors.EffectiveVisibilityKt;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u001e\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J \u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u0010\u001a\u00020\u0011J\u001a\u0010\u0017\u001a\u00020\u00062\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\b\b\u0002\u0010\u0010\u001a\u00020\u0011J\u0018\u0010\"\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/resolve/ExposedVisibilityChecker;", "", "trace", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "(Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;)V", "checkClassHeader", "", "klass", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "checkDeclarationWithVisibility", "modifierListOwner", "Lorg/jetbrains/kotlin/psi/KtModifierListOwner;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptorWithVisibility;", "visibility", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "checkFunction", "function", "Lorg/jetbrains/kotlin/psi/KtFunction;", "functionDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "checkMemberReceiver", "typeReference", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "memberDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "checkParameterBounds", "checkProperty", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "propertyDescriptor", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "checkSupertypes", "frontend"})
public final class ExposedVisibilityChecker {
    private final DiagnosticSink trace;

    public final boolean checkClassHeader(@NotNull KtClassOrObject klass2, @NotNull ClassDescriptor classDescriptor) {
        Intrinsics.checkParameterIsNotNull((Object)klass2, (String)"klass");
        Intrinsics.checkParameterIsNotNull((Object)classDescriptor, (String)"classDescriptor");
        boolean result2 = this.checkSupertypes(klass2, classDescriptor);
        result2 &= this.checkParameterBounds(klass2, classDescriptor);
        KtPrimaryConstructor ktPrimaryConstructor = klass2.getPrimaryConstructor();
        if (ktPrimaryConstructor == null) {
            return result2;
        }
        KtPrimaryConstructor constructor2 = ktPrimaryConstructor;
        ConstructorDescriptor constructorDescriptor = classDescriptor.getUnsubstitutedPrimaryConstructor();
        if (constructorDescriptor == null) {
            return result2;
        }
        ConstructorDescriptor constructorDescriptor2 = constructorDescriptor;
        KtFunction ktFunction = constructor2;
        FunctionDescriptor functionDescriptor = constructorDescriptor2;
        Intrinsics.checkExpressionValueIsNotNull((Object)functionDescriptor, (String)"constructorDescriptor");
        return result2 & ExposedVisibilityChecker.checkFunction$default(this, ktFunction, functionDescriptor, null, 4, null);
    }

    public final boolean checkDeclarationWithVisibility(@NotNull KtModifierListOwner modifierListOwner, @NotNull DeclarationDescriptorWithVisibility descriptor2, @NotNull Visibility visibility) {
        Intrinsics.checkParameterIsNotNull((Object)modifierListOwner, (String)"modifierListOwner");
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkParameterIsNotNull((Object)visibility, (String)"visibility");
        return modifierListOwner instanceof KtFunction && descriptor2 instanceof FunctionDescriptor ? this.checkFunction((KtFunction)modifierListOwner, (FunctionDescriptor)descriptor2, visibility) : (modifierListOwner instanceof KtProperty && descriptor2 instanceof PropertyDescriptor ? this.checkProperty((KtProperty)modifierListOwner, (PropertyDescriptor)descriptor2, visibility) : true);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean checkFunction(@NotNull KtFunction function2, @NotNull FunctionDescriptor functionDescriptor, @NotNull Visibility visibility) {
        void result2;
        void $receiver$iv;
        Object restricting;
        Intrinsics.checkParameterIsNotNull((Object)function2, (String)"function");
        Intrinsics.checkParameterIsNotNull((Object)functionDescriptor, (String)"functionDescriptor");
        Intrinsics.checkParameterIsNotNull((Object)visibility, (String)"visibility");
        EffectiveVisibility functionVisibility = EffectiveVisibilityKt.effectiveVisibility(functionDescriptor, visibility);
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        booleanRef.element = true;
        if (!(function2 instanceof KtConstructor)) {
            KotlinType kotlinType = functionDescriptor.getReturnType();
            Object object = restricting = kotlinType != null ? EffectiveVisibilityKt.leastPermissiveDescriptor(kotlinType, functionVisibility) : null;
            if (restricting != null) {
                PsiElement psiElement = function2.getNameIdentifier();
                if (psiElement == null) {
                    psiElement = function2;
                }
                this.trace.report(Errors.EXPOSED_FUNCTION_RETURN_TYPE.on(psiElement, functionVisibility, (DescriptorWithRelation)restricting, ((DescriptorWithRelation)restricting).effectiveVisibility()));
                result2.element = false;
            }
        }
        restricting = functionDescriptor.getValueParameters();
        int index$iv = 0;
        for (Object item$iv : $receiver$iv) {
            void parameterDescriptor;
            int n = index$iv++;
            ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)item$iv;
            int i = n;
            DescriptorWithRelation restricting2 = EffectiveVisibilityKt.leastPermissiveDescriptor(parameterDescriptor.getType(), functionVisibility);
            if (restricting2 == null || i >= function2.getValueParameters().size()) continue;
            this.trace.report(Errors.EXPOSED_PARAMETER_TYPE.on((KtParameter)((PsiElement)function2.getValueParameters().get(i)), functionVisibility, restricting2, restricting2.effectiveVisibility()));
            result2.element = false;
        }
        return result2.element & this.checkMemberReceiver(function2.getReceiverTypeReference(), functionDescriptor);
    }

    public static /* bridge */ /* synthetic */ boolean checkFunction$default(ExposedVisibilityChecker exposedVisibilityChecker, KtFunction ktFunction, FunctionDescriptor functionDescriptor, Visibility visibility, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: checkFunction");
        }
        if ((n & 4) != 0) {
            Visibility visibility2 = functionDescriptor.getVisibility();
            Intrinsics.checkExpressionValueIsNotNull((Object)visibility2, (String)"functionDescriptor.visibility");
            visibility = visibility2;
        }
        return exposedVisibilityChecker.checkFunction(ktFunction, functionDescriptor, visibility);
    }

    public final boolean checkProperty(@NotNull KtProperty property2, @NotNull PropertyDescriptor propertyDescriptor, @NotNull Visibility visibility) {
        Intrinsics.checkParameterIsNotNull((Object)property2, (String)"property");
        Intrinsics.checkParameterIsNotNull((Object)propertyDescriptor, (String)"propertyDescriptor");
        Intrinsics.checkParameterIsNotNull((Object)visibility, (String)"visibility");
        EffectiveVisibility propertyVisibility = EffectiveVisibilityKt.effectiveVisibility(propertyDescriptor, visibility);
        DescriptorWithRelation restricting = EffectiveVisibilityKt.leastPermissiveDescriptor(propertyDescriptor.getType(), propertyVisibility);
        boolean result2 = true;
        if (restricting != null) {
            PsiElement psiElement = property2.getNameIdentifier();
            if (psiElement == null) {
                psiElement = property2;
            }
            this.trace.report(Errors.EXPOSED_PROPERTY_TYPE.on(psiElement, propertyVisibility, restricting, restricting.effectiveVisibility()));
            result2 = false;
        }
        return result2 & this.checkMemberReceiver(property2.getReceiverTypeReference(), propertyDescriptor);
    }

    public static /* bridge */ /* synthetic */ boolean checkProperty$default(ExposedVisibilityChecker exposedVisibilityChecker, KtProperty ktProperty, PropertyDescriptor propertyDescriptor, Visibility visibility, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: checkProperty");
        }
        if ((n & 4) != 0) {
            Visibility visibility2 = propertyDescriptor.getVisibility();
            Intrinsics.checkExpressionValueIsNotNull((Object)visibility2, (String)"propertyDescriptor.visibility");
            visibility = visibility2;
        }
        return exposedVisibilityChecker.checkProperty(ktProperty, propertyDescriptor, visibility);
    }

    private final boolean checkMemberReceiver(KtTypeReference typeReference, CallableMemberDescriptor memberDescriptor) {
        if (typeReference == null) {
            return true;
        }
        ReceiverParameterDescriptor receiverParameterDescriptor = memberDescriptor.getExtensionReceiverParameter();
        if (receiverParameterDescriptor == null) {
            return true;
        }
        ReceiverParameterDescriptor receiverParameterDescriptor2 = receiverParameterDescriptor;
        EffectiveVisibility memberVisibility = EffectiveVisibilityKt.effectiveVisibility$default(memberDescriptor, null, 1, null);
        DescriptorWithRelation restricting = EffectiveVisibilityKt.leastPermissiveDescriptor(receiverParameterDescriptor2.getType(), memberVisibility);
        if (restricting != null) {
            this.trace.report(Errors.EXPOSED_RECEIVER_TYPE.on((KtTypeReference)((PsiElement)typeReference), memberVisibility, restricting, restricting.effectiveVisibility()));
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean checkSupertypes(KtClassOrObject klass2, ClassDescriptor classDescriptor) {
        void result2;
        void $receiver$iv;
        EffectiveVisibility classVisibility = EffectiveVisibilityKt.effectiveVisibility(classDescriptor);
        boolean isInterface = Intrinsics.areEqual((Object)((Object)classDescriptor.getKind()), (Object)((Object)ClassKind.INTERFACE));
        List<KtSuperTypeListEntry> delegationList = klass2.getSuperTypeListEntries();
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        booleanRef.element = true;
        Iterable iterable = classDescriptor.getTypeConstructor().getSupertypes();
        int index$iv = 0;
        for (Object item$iv : $receiver$iv) {
            DescriptorWithRelation restricting;
            ClassDescriptor superDescriptor;
            void superType;
            int n = index$iv++;
            KotlinType kotlinType = (KotlinType)item$iv;
            int i = n;
            if (i >= delegationList.size()) {
                return result2.element;
            }
            if (TypeUtils.getClassDescriptor((KotlinType)superType) == null) {
                continue;
            }
            boolean superIsInterface = Intrinsics.areEqual((Object)((Object)superDescriptor.getKind()), (Object)((Object)ClassKind.INTERFACE));
            if (superIsInterface != isInterface || (restricting = EffectiveVisibilityKt.leastPermissiveDescriptor((KotlinType)superType, classVisibility)) == null) continue;
            if (isInterface) {
                this.trace.report(Errors.EXPOSED_SUPER_INTERFACE.on((KtSuperTypeListEntry)((PsiElement)delegationList.get(i)), classVisibility, restricting, restricting.effectiveVisibility()));
            } else {
                this.trace.report(Errors.EXPOSED_SUPER_CLASS.on((KtSuperTypeListEntry)((PsiElement)delegationList.get(i)), classVisibility, restricting, restricting.effectiveVisibility()));
            }
            result2.element = false;
        }
        return result2.element;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean checkParameterBounds(KtClassOrObject klass2, ClassDescriptor classDescriptor) {
        void result2;
        void $receiver$iv;
        EffectiveVisibility classVisibility = EffectiveVisibilityKt.effectiveVisibility(classDescriptor);
        List<KtTypeParameter> typeParameterList = klass2.getTypeParameters();
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        booleanRef.element = true;
        Iterable iterable = classDescriptor.getDeclaredTypeParameters();
        int index$iv = 0;
        block0: for (Object item$iv : $receiver$iv) {
            void typeParameterDescriptor;
            int n = index$iv++;
            TypeParameterDescriptor typeParameterDescriptor2 = (TypeParameterDescriptor)item$iv;
            int i = n;
            if (i >= typeParameterList.size()) {
                return result2.element;
            }
            for (KotlinType upperBound : typeParameterDescriptor.getUpperBounds()) {
                DescriptorWithRelation restricting = EffectiveVisibilityKt.leastPermissiveDescriptor(upperBound, classVisibility);
                if (restricting == null) continue;
                this.trace.report(Errors.EXPOSED_TYPE_PARAMETER_BOUND.on((KtTypeParameter)((PsiElement)typeParameterList.get(i)), classVisibility, restricting, restricting.effectiveVisibility()));
                result2.element = false;
                continue block0;
            }
        }
        return result2.element;
    }

    public ExposedVisibilityChecker(@NotNull DiagnosticSink trace) {
        Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
        this.trace = trace;
    }

    public /* synthetic */ ExposedVisibilityChecker(DiagnosticSink diagnosticSink, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            DiagnosticSink diagnosticSink2 = DiagnosticSink.DO_NOTHING;
            Intrinsics.checkExpressionValueIsNotNull((Object)diagnosticSink2, (String)"DO_NOTHING");
            diagnosticSink = diagnosticSink2;
        }
        this(diagnosticSink);
    }

    public ExposedVisibilityChecker() {
        this(null, 1, null);
    }
}

