/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.beanValidation.highlighting;

import com.intellij.beanValidation.highlighting.checkers.BvChecker;
import com.intellij.beanValidation.highlighting.checkers.CheckAnnotationIsConstraint;
import com.intellij.beanValidation.highlighting.checkers.CheckClassIsConstraintAnnotation;
import com.intellij.beanValidation.highlighting.checkers.CheckMissingParameters;
import com.intellij.beanValidation.model.xml.BvMappingsDomElement;
import com.intellij.beanValidation.resources.BVBundle;
import com.intellij.beanValidation.resources.BVInspectionBundle;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.highlighting.BasicDomElementsInspection;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomHighlightingHelper;
import java.util.HashMap;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class BvConstraintMappingsInspection
extends BasicDomElementsInspection<BvMappingsDomElement> {
    private static final HashMap<String, BvChecker[]> CHECKERS = new HashMap();

    private static void register(String key, BvChecker ... checkers) {
        CHECKERS.put(key, checkers);
    }

    public BvConstraintMappingsInspection() {
        super(BvMappingsDomElement.class, new Class[0]);
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = BVInspectionBundle.message("model.inspection.group.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/beanValidation/highlighting/BvConstraintMappingsInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = BVBundle.message("constraints.config.inspection", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/beanValidation/highlighting/BvConstraintMappingsInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/beanValidation/highlighting/BvConstraintMappingsInspection", "getShortName"));
        }
        return string;
    }

    protected void checkDomElement(DomElement element, DomElementAnnotationHolder holder, DomHighlightingHelper helper) {
        GenericDomValue value;
        String checkerId;
        BvChecker[] checkers;
        super.checkDomElement(element, holder, helper);
        if (element instanceof GenericDomValue && (checkers = CHECKERS.get(checkerId = BvConstraintMappingsInspection.getCheckerId(value = (GenericDomValue)element))) != null) {
            for (BvChecker checker : checkers) {
                checker.check(value, holder, helper);
            }
        }
    }

    private static String getCheckerId(@NotNull GenericDomValue value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/beanValidation/highlighting/BvConstraintMappingsInspection", "getCheckerId"));
        }
        DomElement parent = value.getParent();
        return parent == null ? value.getXmlElementName() : parent.getXmlElementName() + "/" + value.getXmlElementName();
    }

    static {
        BvConstraintMappingsInspection.register("constraint/annotation", new CheckClassIsConstraintAnnotation(), new CheckMissingParameters());
        BvConstraintMappingsInspection.register("element/name", new CheckAnnotationIsConstraint());
    }
}

