/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coldFusion.model.psi.stubs;

import com.intellij.coldFusion.model.psi.CfmlComponent;
import com.intellij.coldFusion.model.psi.stubs.CfmlComponentIndex;
import com.intellij.coldFusion.model.psi.stubs.CfmlInterfaceIndex;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.indexing.FileBasedIndex;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CfmlIndex
implements Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.coldFusion.model.psi.stubs.CfmlIndex");
    private static final Key<GlobalSearchScope> MY_SCOPE_KEY = Key.create((String)"default.cfml.scope");
    private static final Map<Project, CfmlIndex> managers = new HashMap<Project, CfmlIndex>();
    private final Project project;

    private CfmlIndex(Project project) {
        this.project = project;
    }

    public static synchronized CfmlIndex getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/coldFusion/model/psi/stubs/CfmlIndex", "getInstance"));
        }
        CfmlIndex manager = managers.get(project);
        if (manager == null) {
            manager = new CfmlIndexManagerImpl(project);
            managers.put(project, manager);
            Disposer.register((Disposable)project, (Disposable)manager);
        }
        return manager;
    }

    public GlobalSearchScope getSearchScope() {
        GlobalSearchScope allScope = (GlobalSearchScope)this.project.getUserData(MY_SCOPE_KEY);
        if (allScope == null) {
            allScope = GlobalSearchScope.projectScope((Project)this.project);
            this.project.putUserData(MY_SCOPE_KEY, (Object)allScope);
        }
        return allScope;
    }

    @NotNull
    public Collection<CfmlComponent> getComponentsByName(@Nullable String name) {
        Collection<CfmlComponent> collection = this.getComponentsByNameInScope(name, this.getSearchScope());
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/psi/stubs/CfmlIndex", "getComponentsByName"));
        }
        return collection;
    }

    @NotNull
    public Collection<CfmlComponent> getInterfacesByName(@Nullable String name) {
        Collection<CfmlComponent> collection = this.getInterfacesByNameInScope(name, this.getSearchScope());
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/psi/stubs/CfmlIndex", "getInterfacesByName"));
        }
        return collection;
    }

    @NotNull
    public Collection<CfmlComponent> getComponentsByNameInScope(@Nullable String name, GlobalSearchScope scope) {
        if (name == null) {
            List<CfmlComponent> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/psi/stubs/CfmlIndex", "getComponentsByNameInScope"));
            }
            return list;
        }
        Collection cfmlComponents = StubIndex.getElements(CfmlComponentIndex.KEY, (Object)name.toLowerCase(), (Project)this.project, (GlobalSearchScope)scope, CfmlComponent.class);
        Collection<CfmlComponent> collection = CfmlIndex.workaroundIndexBug(cfmlComponents, CfmlComponent.class, CfmlComponentIndex.KEY);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/psi/stubs/CfmlIndex", "getComponentsByNameInScope"));
        }
        return collection;
    }

    @NotNull
    public Collection<CfmlComponent> getInterfacesByNameInScope(@Nullable String name, GlobalSearchScope scope) {
        if (name == null) {
            List<CfmlComponent> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/psi/stubs/CfmlIndex", "getInterfacesByNameInScope"));
            }
            return list;
        }
        Collection cfmlComponents = StubIndex.getElements(CfmlInterfaceIndex.KEY, (Object)name.toLowerCase(), (Project)this.project, (GlobalSearchScope)scope, CfmlComponent.class);
        Collection<CfmlComponent> collection = CfmlIndex.workaroundIndexBug(cfmlComponents, CfmlComponent.class, CfmlInterfaceIndex.KEY);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/psi/stubs/CfmlIndex", "getInterfacesByNameInScope"));
        }
        return collection;
    }

    @NotNull
    public Collection<String> getAllComponentsNames() {
        Collection collection = StubIndex.getInstance().getAllKeys(CfmlComponentIndex.KEY, this.project);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/psi/stubs/CfmlIndex", "getAllComponentsNames"));
        }
        return collection;
    }

    @NotNull
    public Collection<String> getAllInterfaceNames() {
        Collection collection = StubIndex.getInstance().getAllKeys(CfmlInterfaceIndex.KEY, this.project);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/psi/stubs/CfmlIndex", "getAllInterfaceNames"));
        }
        return collection;
    }

    public void dispose() {
        managers.remove(this.project);
    }

    private static <T extends PsiElement> Collection<T> workaroundIndexBug(Collection<T> items, Class<T> aClass, StubIndexKey key) {
        boolean ok = true;
        for (PsiElement element : items) {
            if (aClass.isInstance(element)) continue;
            CfmlIndex.rebuildFileIndex(element, key);
            ok = false;
            break;
        }
        if (ok) {
            return items;
        }
        THashSet result = new THashSet(items.size());
        for (PsiElement element : items) {
            if (aClass.isInstance(element)) {
                result.add(element);
                continue;
            }
            CfmlIndex.rebuildFileIndex(element, key);
        }
        return result;
    }

    public static void rebuildFileIndex(PsiElement element, StubIndexKey k) {
        VirtualFile faultyContainer = PsiUtilBase.getVirtualFile((PsiElement)element);
        LOG.warn("Wrong element " + element.getText() + " from " + faultyContainer + " in index: " + k);
        if (faultyContainer != null && faultyContainer.isValid()) {
            FileBasedIndex.getInstance().requestReindex(faultyContainer);
        }
    }

    private static class CfmlIndexManagerImpl
    extends CfmlIndex {
        private CfmlIndexManagerImpl(Project project) {
            super(project);
        }
    }
}

