/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jboss.jbpm.render;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.jboss.jbpm.annotation.AnnotationCoordinator;
import com.intellij.jboss.jbpm.model.ChartNode;
import com.intellij.jboss.jbpm.render.ChartNodeMainPanel;
import com.intellij.jboss.jbpm.render.ChartNodeRenderer;
import com.intellij.jboss.jbpm.render.RenderArgs;
import com.intellij.openapi.util.Condition;
import com.intellij.util.Function;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.JBUI;
import gnu.trove.THashMap;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Point;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChartRenderer {
    @NotNull
    private final List<ChartNodeRenderer> nodeRenderers;
    @NotNull
    private final Map<Collection<Class<?>>, List<RendererInvocation>> invocationsCache = new THashMap();

    public ChartRenderer() {
        this.nodeRenderers = Arrays.asList(ChartNodeRenderer.EP_NAME.getExtensions());
    }

    @Nullable
    public <T> JPanel createNodeComponent(ChartNode<T> node, DiagramBuilder builder, Point basePoint, JPanel wrapper) {
        List<RendererInvocation> invocations = this.getInvocationsList(node.getClassesWithAnnotationsForRendering());
        if (invocations.isEmpty()) {
            return null;
        }
        ChartNodeMainPanel panel = new ChartNodeMainPanel(new BorderLayout());
        panel.setBackground(new Color(1, 1, 1, 1));
        panel.setBorder((Border)JBUI.Borders.empty());
        RenderArgs<T> renderArgs = new RenderArgs<T>(node, builder, basePoint, wrapper, panel);
        for (RendererInvocation invocation : invocations) {
            invocation.invoke(renderArgs);
        }
        return panel;
    }

    private List<RendererInvocation> getInvocationsList(Collection<Class<?>> classes) {
        List<RendererInvocation> invocationList = this.invocationsCache.get(classes);
        if (invocationList == null) {
            invocationList = this.calculateInvocationsList(classes);
            this.invocationsCache.put(classes, invocationList);
        }
        return invocationList;
    }

    private List<RendererInvocation> calculateInvocationsList(final Collection<Class<?>> classes) {
        return JBIterable.from(this.nodeRenderers).transform((Function)new Function<ChartNodeRenderer, RendererInvocation>(){

            public RendererInvocation fun(ChartNodeRenderer renderer) {
                AnnotationCoordinator coordinator = new AnnotationCoordinator(renderer.getLayoutClass());
                Object annotation = coordinator.getAnnotation(classes);
                return annotation == null ? null : new RendererInvocation(annotation, renderer);
            }
        }).filter((Condition)new Condition<RendererInvocation>(){

            public boolean value(RendererInvocation invocation) {
                return invocation != null;
            }
        }).toList();
    }

    static class RendererInvocation<T, RenderOptions extends Annotation> {
        private final RenderOptions renderOptions;
        private final ChartNodeRenderer<T, RenderOptions> renderer;

        RendererInvocation(RenderOptions renderOptions, ChartNodeRenderer<T, RenderOptions> renderer) {
            this.renderOptions = renderOptions;
            this.renderer = renderer;
        }

        void invoke(RenderArgs<T> renderArgs) {
            this.renderer.renderComponent(this.renderOptions, renderArgs);
        }
    }
}

