/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jboss.jbpm.ui;

import com.intellij.diagram.DataProviderFactory;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramPresentationModel;
import com.intellij.diagram.Utils;
import com.intellij.jboss.jbpm.model.ChartDataModel;
import com.intellij.jboss.jbpm.model.ChartSource;
import com.intellij.jboss.jbpm.settings.ChartProvider;
import com.intellij.jboss.jbpm.ui.ChartBuilder;
import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DSelectionEvent;
import com.intellij.openapi.graph.view.Graph2DSelectionListener;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.uml.UmlGraphBuilder;
import com.intellij.uml.UmlVirtualFileSystem;
import com.intellij.uml.presentation.DiagramPresentationModelImpl;
import org.jetbrains.annotations.NotNull;

public class ChartBuilderFactory {
    private ChartBuilderFactory() {
    }

    public static <T> ChartBuilder<T> create(@NotNull Project project, @NotNull ChartProvider<T> provider, @NotNull ChartSource source) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/jboss/jbpm/ui/ChartBuilderFactory", "create"));
        }
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/jboss/jbpm/ui/ChartBuilderFactory", "create"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/jboss/jbpm/ui/ChartBuilderFactory", "create"));
        }
        Graph2D graph = GraphManager.getGraphManager().createGraph2D();
        Graph2DView view = GraphManager.getGraphManager().createGraph2DView(graph);
        DiagramPresentationModel presentationModel = provider.createPresentationModel(project, graph);
        if (presentationModel == null) {
            presentationModel = new DiagramPresentationModelImpl(graph, project, provider);
        }
        ChartDataModel<T> model = provider.createChartDataModel(project, source, presentationModel);
        final ChartBuilder builder = new ChartBuilder<T>(project, (ChartProvider)provider, graph, view, (ChartDataModel)model, presentationModel){};
        graph.addDataProvider((Object)"PROJECT", DataProviderFactory.create((Object)project));
        graph.addDataProvider((Object)"ORIGINAL_ELEMENT", DataProviderFactory.create((Object)source));
        graph.addDataProvider((Object)"GRAPH_BUILDER", DataProviderFactory.create((Object)((Object)builder)));
        model.putUserData(Utils.GRAPH_BUILDER, (Object)builder);
        VirtualFile file = source.getFile();
        if (file != null && file instanceof UmlVirtualFileSystem.UmlVirtualFile) {
            ((UmlVirtualFileSystem.UmlVirtualFile)file).addBuilder((DiagramBuilder)builder);
            builder.putUserData(UmlGraphBuilder.EDITOR_FILE, file);
        }
        graph.addGraph2DSelectionListener(new Graph2DSelectionListener(){

            public void onGraph2DSelectionEvent(Graph2DSelectionEvent e) {
                if (e.isNodeSelection()) {
                    builder.getGraphPresentationModel().onSelectionChanged(e);
                }
            }
        });
        return builder;
    }
}

