/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.openshift.cloud;

import com.intellij.javaee.openshift.cloud.OS3LocalTemplateDeploymentEditor;
import com.intellij.javaee.openshift.cloud.OS3ServerTemplateDeploymentEditor;
import com.intellij.javaee.openshift.cloud.OSCloudConfiguration;
import com.intellij.javaee.openshift.cloud.OSCloudType;
import com.intellij.javaee.openshift.cloud.OSDeploymentConfiguration;
import com.intellij.javaee.openshift.cloud.OSDeploymentEditor;
import com.intellij.javaee.openshift.cloud.OSEmptyDeploymentEditor;
import com.intellij.javaee.openshift.cloud.deploymentSource.OS3LocalTemplateDeploymentSource;
import com.intellij.javaee.openshift.cloud.deploymentSource.OS3ServerTemplateDeploymentSource;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.remoteServer.util.CloudDeploymentConfiguratorBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OSDeploymentConfigurator
extends CloudDeploymentConfiguratorBase<OSDeploymentConfiguration, OSCloudConfiguration> {
    public OSDeploymentConfigurator(Project project) {
        super(project, (ServerType)OSCloudType.getInstance());
    }

    @NotNull
    public OSDeploymentConfiguration createDefaultConfiguration(@NotNull DeploymentSource source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/javaee/openshift/cloud/OSDeploymentConfigurator", "createDefaultConfiguration"));
        }
        OSDeploymentConfiguration oSDeploymentConfiguration = new OSDeploymentConfiguration();
        if (oSDeploymentConfiguration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/openshift/cloud/OSDeploymentConfigurator", "createDefaultConfiguration"));
        }
        return oSDeploymentConfiguration;
    }

    @Nullable
    public SettingsEditor<OSDeploymentConfiguration> createEditor(@NotNull DeploymentSource source, @NotNull RemoteServer<OSCloudConfiguration> server) {
        boolean isOS3DeploymentSource;
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/javaee/openshift/cloud/OSDeploymentConfigurator", "createEditor"));
        }
        if (server == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "server", "com/intellij/javaee/openshift/cloud/OSDeploymentConfigurator", "createEditor"));
        }
        boolean isOS3 = ((OSCloudConfiguration)server.getConfiguration()).isOS3();
        boolean bl = isOS3DeploymentSource = source instanceof OS3LocalTemplateDeploymentSource || source instanceof OS3ServerTemplateDeploymentSource;
        if (isOS3) {
            if (source instanceof OS3LocalTemplateDeploymentSource) {
                return new OS3LocalTemplateDeploymentEditor(source.getFile(), server);
            }
            if (source instanceof OS3ServerTemplateDeploymentSource) {
                return new OS3ServerTemplateDeploymentEditor(server);
            }
        } else if (!isOS3DeploymentSource) {
            return new OSDeploymentEditor();
        }
        return new OSEmptyDeploymentEditor();
    }
}

