/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws;

import com.intellij.javaee.UriUtil;
import com.intellij.openapi.actionSystem.DataConstants;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Processor;
import com.intellij.ws.WSBundle;
import com.intellij.ws.WebServicesPluginSettings;
import com.intellij.ws.engines.axis2.Axis2Utils;
import com.intellij.ws.engines.cxf.CxfUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebServicesPluginConfigurable
implements SearchableConfigurable {
    private WebServicesPluginSettings myWebServicesPluginSettings;
    private JTextField myServerNameField;
    private JTextField myServerPortField;
    private JPanel myPanel;
    private JLabel serverNameText;
    private JLabel serverPortText;
    private TextFieldWithBrowseButton myPathToJWSDPField;
    private JLabel pathToJWSDPText;
    private JLabel pathToCXFText;
    private TextFieldWithBrowseButton myPathToCXFField;
    private JLabel pathToXmlBeansText;
    private TextFieldWithBrowseButton myPathToXmlBeansField;
    private JLabel pathToAxis2Text;
    private TextFieldWithBrowseButton myPathToAxis2Field;
    private JLabel pathToJBossWSText;
    private TextFieldWithBrowseButton myPathToJBossWSField;
    private JLabel pathToWebSphereText;
    private TextFieldWithBrowseButton myPathToWebSphereField;
    private JLabel webServiceUrlPathPrefixText;
    private JTextField myWebServiceUrlPathPrefixField;
    private JLabel maxMemorySizeText;
    private JTextField myMaxMemorySizeField;

    public WebServicesPluginConfigurable(WebServicesPluginSettings webServicesPluginSettings) {
        this.myWebServicesPluginSettings = webServicesPluginSettings;
        this.$$$setupUI$$$();
        this.webServiceUrlPathPrefixText.setLabelFor(this.myWebServiceUrlPathPrefixField);
        this.webServiceUrlPathPrefixText.setDisplayedMnemonic('t');
        this.serverNameText.setLabelFor(this.myServerNameField);
        this.serverNameText.setDisplayedMnemonic('n');
        this.serverPortText.setLabelFor(this.myServerPortField);
        this.serverPortText.setDisplayedMnemonic('p');
        this.pathToJWSDPText.setLabelFor(this.myPathToJWSDPField.getTextField());
        this.pathToJWSDPText.setDisplayedMnemonic('w');
        this.pathToAxis2Text.setLabelFor(this.myPathToAxis2Field.getTextField());
        this.pathToAxis2Text.setDisplayedMnemonic('a');
        this.pathToCXFText.setLabelFor(this.myPathToCXFField.getTextField());
        this.pathToCXFText.setDisplayedMnemonic('x');
        this.pathToJBossWSText.setLabelFor(this.myPathToJBossWSField.getTextField());
        this.pathToJBossWSText.setDisplayedMnemonic('j');
        this.pathToXmlBeansText.setLabelFor(this.myPathToXmlBeansField.getTextField());
        this.pathToXmlBeansText.setDisplayedMnemonic('b');
        this.pathToWebSphereText.setLabelFor(this.myPathToWebSphereField.getTextField());
        this.pathToWebSphereText.setDisplayedMnemonic('h');
        this.maxMemorySizeText.setLabelFor(this.myMaxMemorySizeField);
        this.maxMemorySizeText.setDisplayedMnemonic('m');
        WebServicesPluginConfigurable.configureSelectPath(this.myPathToJWSDPField, WSBundle.message("choose.glassfish.or.jaxws.ri.or.jwsdp.directory.dialog.title", new Object[0]), (Processor<VirtualFile>)((Processor)t -> {
            boolean standAloneJWSDP;
            boolean bl = standAloneJWSDP = t.findChild("jaxb") != null;
            if (!standAloneJWSDP) {
                VirtualFile libFile = t.findChild("lib");
                if (libFile != null) {
                    VirtualFile child = libFile.findChild("appserv-ws.jar");
                    if (child == null) {
                        child = libFile.findChild("webservices-tools.jar");
                    }
                    if (child == null) {
                        child = libFile.findChild("jaxws-rt.jar");
                    }
                    return child != null;
                }
                libFile = t.findChild("glassfish");
                if (libFile != null && (libFile = libFile.findChild("modules")) != null) {
                    return libFile.findChild("webservices-osgi.jar") != null && libFile.findChild("endorsed") != null;
                }
            }
            return standAloneJWSDP;
        }));
        WebServicesPluginConfigurable.configureSelectPath(this.myPathToAxis2Field, WSBundle.message("choose.axis.2.directory.dialog.title", new Object[0]), (Processor<VirtualFile>)((Processor)t -> {
            VirtualFile libFile = t.findChild("lib");
            if (libFile == null || !libFile.isDirectory()) {
                return false;
            }
            for (VirtualFile f : libFile.getChildren()) {
                if (!Axis2Utils.isAxis2JarFile(f.getName())) continue;
                return true;
            }
            return false;
        }));
        WebServicesPluginConfigurable.configureSelectPath(this.myPathToCXFField, WSBundle.message("choose.xfire.directory.dialog.title", new Object[0]), (Processor<VirtualFile>)((Processor)t -> CxfUtils.isCxfHome(t)));
        WebServicesPluginConfigurable.configureSelectPath(this.myPathToXmlBeansField, WSBundle.message("choose.xml.beans.directory.dialog.title", new Object[0]), (Processor<VirtualFile>)((Processor)t -> {
            VirtualFile child = t.findChild("lib");
            return child != null && child.findChild("xbean.jar") != null;
        }));
        WebServicesPluginConfigurable.configureSelectPath(this.myPathToJBossWSField, WSBundle.message("choose.jboss.application.server.directory.with.jboss.ws.installed.dialog.title", new Object[0]), (Processor<VirtualFile>)((Processor)t -> {
            VirtualFile libFile = t.findChild("client");
            if (libFile == null || !libFile.isDirectory()) {
                return false;
            }
            return libFile.findChild("jbossws-client.jar") != null || libFile.findChild("jbossws-native-client.jar") != null;
        }));
        WebServicesPluginConfigurable.configureSelectPath(this.myPathToWebSphereField, WSBundle.message("choose.web.sphere.path.dialog.title", new Object[0]), (Processor<VirtualFile>)((Processor)t -> t.findChild("runtimes") != null && t.findChild("bin") != null));
    }

    private static void configureSelectPath(final TextFieldWithBrowseButton pathToJWSDP, final String title, final Processor<VirtualFile> acceptanceProcessor) {
        pathToJWSDP.getButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileChooserDescriptor fileChooserDescriptor = new FileChooserDescriptor(false, true, false, false, false, false){

                    public boolean isFileSelectable(VirtualFile virtualFile) {
                        return acceptanceProcessor.process((Object)virtualFile);
                    }
                };
                fileChooserDescriptor.setTitle(title);
                Project project = null;
                for (Window mostRecentFocusedWindow = WindowManagerEx.getInstanceEx().getMostRecentFocusedWindow(); !(mostRecentFocusedWindow == null || mostRecentFocusedWindow instanceof DataProvider && (project = (Project)((DataProvider)mostRecentFocusedWindow).getData(DataConstants.PROJECT)) != null); mostRecentFocusedWindow = (Window)mostRecentFocusedWindow.getParent()) {
                }
                String lastPathToJWSDP = pathToJWSDP.getText();
                VirtualFile file = lastPathToJWSDP != null && lastPathToJWSDP.length() > 0 ? UriUtil.findRelativeFile((String)lastPathToJWSDP, null) : null;
                VirtualFile[] virtualFiles = FileChooser.chooseFiles((FileChooserDescriptor)fileChooserDescriptor, (Project)project, (VirtualFile)file);
                if (virtualFiles.length == 1) {
                    pathToJWSDP.setText(virtualFiles[0].getPresentableUrl());
                }
            }
        });
    }

    @NonNls
    public String getDisplayName() {
        return "Web Services";
    }

    @Nullable
    @NonNls
    public String getHelpTopic() {
        return "reference.settings.ide.settings.webservices";
    }

    @NotNull
    public String getId() {
        String string = this.getHelpTopic();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/WebServicesPluginConfigurable", "getId"));
        }
        return string;
    }

    public JComponent createComponent() {
        return this.myPanel;
    }

    public boolean isModified() {
        return !this.myWebServicesPluginSettings.getHostName().equals(this.myServerNameField.getText()) || !this.myWebServicesPluginSettings.getHostPort().equals(this.myServerPortField.getText()) || !this.myWebServicesPluginSettings.getWebServicesUrlPathPrefix().equals(this.myWebServiceUrlPathPrefixField.getText()) || WebServicesPluginConfigurable.checkValueChanged(this.myWebServicesPluginSettings.getJwsdpPath(), this.myPathToJWSDPField) || WebServicesPluginConfigurable.checkValueChanged(this.myWebServicesPluginSettings.getCXFPath(), this.myPathToCXFField) || WebServicesPluginConfigurable.checkValueChanged(this.myWebServicesPluginSettings.getXmlBeansPath(), this.myPathToXmlBeansField) || WebServicesPluginConfigurable.checkValueChanged(this.myWebServicesPluginSettings.getAxis2Path(), this.myPathToAxis2Field) || WebServicesPluginConfigurable.checkValueChanged(this.myWebServicesPluginSettings.getJBossWSPath(), this.myPathToJBossWSField) || WebServicesPluginConfigurable.checkValueChanged(this.myWebServicesPluginSettings.getWebSphereWSPath(), this.myPathToWebSphereField) || this.myWebServicesPluginSettings.getMemorySizeToLaunchVM() != WebServicesPluginConfigurable.parseIntNoException(this.myMaxMemorySizeField.getText());
    }

    private static boolean checkValueChanged(String path, TextFieldWithBrowseButton pathUIField) {
        return path != null && !path.equals(pathUIField.getText()) || path == null && pathUIField.getText().length() > 0;
    }

    private static int parseIntNoException(String text) {
        try {
            return Integer.parseInt(text.trim());
        }
        catch (NumberFormatException ex) {
            return 25;
        }
    }

    public void apply() throws ConfigurationException {
        String text;
        try {
            text = this.myServerPortField.getText();
            Integer.parseInt(text);
            this.myWebServicesPluginSettings.setHostPort(text);
        }
        catch (NumberFormatException ex) {
            throw new ConfigurationException("Port should be numeric");
        }
        try {
            text = this.myServerNameField.getText();
            new URL("http://" + text);
            this.myWebServicesPluginSettings.setHostName(text);
        }
        catch (MalformedURLException ex) {
            throw new ConfigurationException("Invalid url");
        }
        this.myWebServicesPluginSettings.setJwsdpPath(WebServicesPluginConfigurable.getPath(this.myPathToJWSDPField));
        this.myWebServicesPluginSettings.setCXFPath(WebServicesPluginConfigurable.getPath(this.myPathToCXFField));
        this.myWebServicesPluginSettings.setXmlBeansPath(WebServicesPluginConfigurable.getPath(this.myPathToXmlBeansField));
        this.myWebServicesPluginSettings.setAxis2Path(WebServicesPluginConfigurable.getPath(this.myPathToAxis2Field));
        this.myWebServicesPluginSettings.setJBossWSPath(WebServicesPluginConfigurable.getPath(this.myPathToJBossWSField));
        this.myWebServicesPluginSettings.setWebSphereWSPath(WebServicesPluginConfigurable.getPath(this.myPathToWebSphereField));
        text = this.myWebServiceUrlPathPrefixField.getText().trim();
        text = StringUtil.trimEnd((String)text, (String)"/");
        if (text.length() > 0 && !text.startsWith("/")) {
            text = "/" + text;
        }
        this.myWebServicesPluginSettings.setWebServicesUrlPathPrefix(text);
        this.myWebServicesPluginSettings.setMemorySizeToLaunchVM(WebServicesPluginConfigurable.parseIntNoException(this.myMaxMemorySizeField.getText()));
    }

    @Nullable
    private static String getPath(TextFieldWithBrowseButton field) throws ConfigurationException {
        String path = field.getText().trim();
        if (!StringUtil.isEmptyOrSpaces((String)path) && !new File(path).exists()) {
            throw new ConfigurationException("Directory \"" + path + "\" does not exist");
        }
        return StringUtil.nullize((String)path);
    }

    public void reset() {
        this.myServerNameField.setText(this.myWebServicesPluginSettings.getHostName());
        this.myServerPortField.setText(this.myWebServicesPluginSettings.getHostPort());
        this.myPathToJWSDPField.setText(StringUtil.notNullize((String)this.myWebServicesPluginSettings.getJwsdpPath()));
        this.myPathToCXFField.setText(StringUtil.notNullize((String)this.myWebServicesPluginSettings.getCXFPath()));
        this.myPathToXmlBeansField.setText(StringUtil.notNullize((String)this.myWebServicesPluginSettings.getXmlBeansPath()));
        this.myPathToAxis2Field.setText(StringUtil.notNullize((String)this.myWebServicesPluginSettings.getAxis2Path()));
        this.myPathToJBossWSField.setText(StringUtil.notNullize((String)this.myWebServicesPluginSettings.getJBossWSPath()));
        this.myPathToWebSphereField.setText(StringUtil.notNullize((String)this.myWebServicesPluginSettings.getWebSphereWSPath()));
        this.myWebServiceUrlPathPrefixField.setText(StringUtil.notNullize((String)this.myWebServicesPluginSettings.getWebServicesUrlPathPrefix()));
        this.myMaxMemorySizeField.setText(String.valueOf(this.myWebServicesPluginSettings.getMemorySizeToLaunchVM()));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JLabel jLabel;
        JTextField jTextField2;
        JLabel jLabel2;
        JTextField jTextField3;
        JLabel jLabel3;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JLabel jLabel4;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        JLabel jLabel5;
        TextFieldWithBrowseButton textFieldWithBrowseButton3;
        JLabel jLabel6;
        TextFieldWithBrowseButton textFieldWithBrowseButton4;
        JLabel jLabel7;
        TextFieldWithBrowseButton textFieldWithBrowseButton5;
        JLabel jLabel8;
        TextFieldWithBrowseButton textFieldWithBrowseButton6;
        JLabel jLabel9;
        JTextField jTextField4;
        JLabel jLabel10;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(5, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        this.maxMemorySizeText = jLabel10 = new JLabel();
        jLabel10.setText("Maximum VM heap size when launching tools (Mb):");
        jLabel10.setToolTipText(ResourceBundle.getBundle("com/intellij/ws/WSBundle").getString("max.vm.memory.size.when.launching.tools"));
        jPanel.add((Component)jLabel10, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myMaxMemorySizeField = jTextField4 = new JTextField();
        jTextField4.setToolTipText(ResourceBundle.getBundle("com/intellij/ws/WSBundle").getString("max.vm.memory.size.when.launching.tools"));
        jPanel.add((Component)jTextField4, new GridConstraints(4, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("html.disable", Boolean.FALSE);
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)"External engines:", (int)0, (int)0, null, null));
        this.pathToJWSDPText = jLabel9 = new JLabel();
        this.$$$loadLabelText$$$(jLabel9, ResourceBundle.getBundle("com/intellij/ws/WSBundle").getString("glassfish.jax.ws.2.x.ri.metro.1.x.jwsdp.2.0"));
        jLabel9.setToolTipText(ResourceBundle.getBundle("com/intellij/ws/WSBundle").getString("jwsdp.path.tooltip"));
        jPanel2.add((Component)jLabel9, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPathToJWSDPField = textFieldWithBrowseButton6 = new TextFieldWithBrowseButton();
        textFieldWithBrowseButton6.setToolTipText(ResourceBundle.getBundle("com/intellij/ws/WSBundle").getString("jwsdp.path.tooltip"));
        jPanel2.add((Component)textFieldWithBrowseButton6, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.pathToCXFText = jLabel8 = new JLabel();
        this.$$$loadLabelText$$$(jLabel8, ResourceBundle.getBundle("com/intellij/ws/WSBundle").getString("cxf.display.name"));
        jLabel8.setToolTipText(ResourceBundle.getBundle("com/intellij/ws/WSBundle").getString("xfire.path.tooltip"));
        jPanel2.add((Component)jLabel8, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPathToCXFField = textFieldWithBrowseButton5 = new TextFieldWithBrowseButton();
        textFieldWithBrowseButton5.setToolTipText(ResourceBundle.getBundle("com/intellij/ws/WSBundle").getString("xfire.path.tooltip"));
        jPanel2.add((Component)textFieldWithBrowseButton5, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.pathToXmlBeansText = jLabel7 = new JLabel();
        jLabel7.setText("Xml Beans");
        jLabel7.setToolTipText(ResourceBundle.getBundle("com/intellij/ws/WSBundle").getString("xml.beans.path.tooltip"));
        jPanel2.add((Component)jLabel7, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPathToXmlBeansField = textFieldWithBrowseButton4 = new TextFieldWithBrowseButton();
        textFieldWithBrowseButton4.setToolTipText(ResourceBundle.getBundle("com/intellij/ws/WSBundle").getString("xml.beans.path.tooltip"));
        jPanel2.add((Component)textFieldWithBrowseButton4, new GridConstraints(4, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.pathToAxis2Text = jLabel6 = new JLabel();
        this.$$$loadLabelText$$$(jLabel6, ResourceBundle.getBundle("com/intellij/ws/WSBundle").getString("axis2.display.name"));
        jLabel6.setToolTipText(ResourceBundle.getBundle("com/intellij/ws/WSBundle").getString("axis2.path.tooltip"));
        jPanel2.add((Component)jLabel6, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPathToAxis2Field = textFieldWithBrowseButton3 = new TextFieldWithBrowseButton();
        textFieldWithBrowseButton3.setToolTipText(ResourceBundle.getBundle("com/intellij/ws/WSBundle").getString("axis2.path.tooltip"));
        jPanel2.add((Component)textFieldWithBrowseButton3, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.pathToJBossWSText = jLabel5 = new JLabel();
        jLabel5.setText("JBoss");
        jLabel5.setToolTipText(ResourceBundle.getBundle("com/intellij/ws/WSBundle").getString("jbossws.path.tooltip"));
        jPanel2.add((Component)jLabel5, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPathToJBossWSField = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        textFieldWithBrowseButton2.setToolTipText(ResourceBundle.getBundle("com/intellij/ws/WSBundle").getString("jbossws.path.tooltip"));
        jPanel2.add((Component)textFieldWithBrowseButton2, new GridConstraints(3, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.pathToWebSphereText = jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("com/intellij/ws/WSBundle").getString("websphere.platform.name"));
        jLabel4.setToolTipText(ResourceBundle.getBundle("com/intellij/ws/WSBundle").getString("websphere.path.tooltip"));
        jPanel2.add((Component)jLabel4, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPathToWebSphereField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        textFieldWithBrowseButton.setToolTipText(ResourceBundle.getBundle("com/intellij/ws/WSBundle").getString("websphere.path.tooltip"));
        jPanel2.add((Component)textFieldWithBrowseButton, new GridConstraints(5, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.webServiceUrlPathPrefixText = jLabel3 = new JLabel();
        jLabel3.setText("Prefix path for web services URL:");
        jLabel3.setToolTipText(ResourceBundle.getBundle("com/intellij/ws/WSBundle").getString("webservice.url.path.prefix"));
        jPanel.add((Component)jLabel3, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myWebServiceUrlPathPrefixField = jTextField3 = new JTextField();
        jTextField3.setToolTipText(ResourceBundle.getBundle("com/intellij/ws/WSBundle").getString("webservice.url.path.prefix"));
        jPanel.add((Component)jTextField3, new GridConstraints(3, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.serverPortText = jLabel2 = new JLabel();
        jLabel2.setText("Server port:");
        jLabel2.setToolTipText(ResourceBundle.getBundle("com/intellij/ws/WSBundle").getString("webservice.serverport.tooltip"));
        jPanel.add((Component)jLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myServerPortField = jTextField2 = new JTextField();
        jTextField2.setToolTipText(ResourceBundle.getBundle("com/intellij/ws/WSBundle").getString("webservice.serverport.tooltip"));
        jPanel.add((Component)jTextField2, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.serverNameText = jLabel = new JLabel();
        jLabel.setText("Server name:");
        jLabel.setToolTipText(ResourceBundle.getBundle("com/intellij/ws/WSBundle").getString("webservice.servername.tooltip"));
        jPanel.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myServerNameField = jTextField = new JTextField();
        jTextField.setText("");
        jTextField.setToolTipText(ResourceBundle.getBundle("com/intellij/ws/WSBundle").getString("webservice.servername.tooltip"));
        jPanel.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

