/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiTypeElement;
import com.intellij.util.IncorrectOperationException;
import com.intellij.ws.WSBundle;
import com.intellij.ws.engines.jwsdp.JWSDPWSEngine;
import com.intellij.ws.inspections.BaseWebServicesInspection;
import java.util.ArrayList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class OneWayWebMethodInspection
extends BaseWebServicesInspection {
    @Override
    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/inspections/OneWayWebMethodInspection", "getDefaultLevel"));
        }
        return highlightDisplayLevel;
    }

    @NotNull
    public String getDisplayName() {
        String string = WSBundle.message("webservices.inspections.oneway.operation.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/inspections/OneWayWebMethodInspection", "getDisplayName"));
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        String string = WSBundle.message("webservices.inspections.oneway.operation.short.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/inspections/OneWayWebMethodInspection", "getShortName"));
        }
        return string;
    }

    @Override
    protected final void doCheckClass(PsiClass c, ProblemsHolder problemsHolder) {
    }

    @Override
    protected final void checkMember(ProblemsHolder problemsHolder, PsiMember member) {
        PsiTypeElement returnTypeElement;
        PsiMethod method;
        PsiAnnotation annotation;
        if (member instanceof PsiMethod && (annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)(method = (PsiMethod)member), JWSDPWSEngine.wsOneWayMethodSet)) != null && (returnTypeElement = method.getReturnTypeElement()) != null && !returnTypeElement.getText().equals("void")) {
            ArrayList<Object> quickfixes = new ArrayList<Object>(2);
            quickfixes.add(new RemoveElementFix((PsiElement)annotation));
            quickfixes.add(new ReplaceTypeElementFix((PsiElement)returnTypeElement, "void"));
            problemsHolder.registerProblem((PsiElement)returnTypeElement, WSBundle.message("webservices.inspections.oneway.operation.problem", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, quickfixes.toArray(new LocalQuickFix[quickfixes.size()]));
        }
    }

    private static class RemoveElementFix
    implements LocalQuickFix {
        private final PsiElement annotation;

        public RemoveElementFix(@NotNull PsiElement annotation) {
            if (annotation == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "com/intellij/ws/inspections/OneWayWebMethodInspection$RemoveElementFix", "<init>"));
            }
            this.annotation = annotation;
        }

        @NotNull
        public String getFamilyName() {
            String string = WSBundle.message("webservices.inspections.oneway.operation.remove.annotation.fix.name", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/inspections/OneWayWebMethodInspection$RemoveElementFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ws/inspections/OneWayWebMethodInspection$RemoveElementFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/ws/inspections/OneWayWebMethodInspection$RemoveElementFix", "applyFix"));
            }
            PsiElement psiElement = descriptor.getPsiElement();
            if (psiElement == null) {
                return;
            }
            if (!FileModificationService.getInstance().prepareFileForWrite(psiElement.getContainingFile())) {
                return;
            }
            try {
                this.annotation.delete();
            }
            catch (IncorrectOperationException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class ReplaceTypeElementFix
    implements LocalQuickFix {
        private final PsiElement annotation;
        private final String text;

        public ReplaceTypeElementFix(@NotNull PsiElement annotation, @NotNull String text) {
            if (annotation == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "com/intellij/ws/inspections/OneWayWebMethodInspection$ReplaceTypeElementFix", "<init>"));
            }
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/ws/inspections/OneWayWebMethodInspection$ReplaceTypeElementFix", "<init>"));
            }
            this.annotation = annotation;
            this.text = text;
        }

        @NotNull
        public String getFamilyName() {
            String string = WSBundle.message("webservices.inspections.oneway.operation.replace.returntype.with.void.fix.name", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/inspections/OneWayWebMethodInspection$ReplaceTypeElementFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ws/inspections/OneWayWebMethodInspection$ReplaceTypeElementFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/ws/inspections/OneWayWebMethodInspection$ReplaceTypeElementFix", "applyFix"));
            }
            PsiElement psiElement = descriptor.getPsiElement();
            if (psiElement == null) {
                return;
            }
            if (!FileModificationService.getInstance().prepareFileForWrite(psiElement.getContainingFile())) {
                return;
            }
            try {
                PsiElementFactory psiElementFactory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
                PsiTypeElement replacement = psiElementFactory.createTypeElement(psiElementFactory.createTypeFromText(this.text, psiElement));
                this.annotation.replace((PsiElement)replacement);
            }
            catch (IncorrectOperationException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

