/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.transparent.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VirtualFile;
import net.sourceforge.transparent.TransparentVcs;
import net.sourceforge.transparent.actions.SynchronousAction;
import org.jetbrains.annotations.NonNls;

public class AddAction
extends SynchronousAction {
    @NonNls
    private static final String ACTION_NAME = "Add File";

    @Override
    protected String getActionName(AnActionEvent e) {
        return ACTION_NAME;
    }

    @Override
    protected boolean isEnabled(VirtualFile file, Project project) {
        return AddAction.getFileStatus(project, file) == FileStatus.UNKNOWN;
    }

    @Override
    protected void perform(VirtualFile file, Project project) {
        try {
            TransparentVcs.getInstance(project).add2NewFile(file);
        }
        catch (VcsException e) {
            AbstractVcsHelper.getInstance((Project)project).showError(e, "Add File failure");
        }
        VcsDirtyScopeManager mgr = VcsDirtyScopeManager.getInstance((Project)project);
        mgr.fileDirty(file);
        file.refresh(true, true);
    }
}

