/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.junit5;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.Filter;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.TagFilter;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;

public class JUnit5TestRunnerUtil {
    public static final String DISABLED_ANNO = "org.junit.jupiter.api.Disabled";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static LauncherDiscoveryRequest buildRequest(String[] suiteClassNames, String[] packageNameRef) {
        if (suiteClassNames.length == 0) {
            return null;
        }
        LauncherDiscoveryRequestBuilder builder = LauncherDiscoveryRequestBuilder.request();
        if (suiteClassNames.length == 1 && suiteClassNames[0].charAt(0) == '@') {
            try (BufferedReader reader = new BufferedReader(new FileReader(suiteClassNames[0].substring(1)));){
                String line;
                String packageName = reader.readLine();
                if (packageName == null) {
                    LauncherDiscoveryRequest launcherDiscoveryRequest = null;
                    return launcherDiscoveryRequest;
                }
                String tagName = reader.readLine();
                ArrayList<DiscoverySelector> selectors = new ArrayList<DiscoverySelector>();
                while ((line = reader.readLine()) != null) {
                    selectors.add(JUnit5TestRunnerUtil.createSelector(line));
                }
                packageNameRef[0] = packageName.length() == 0 ? "<default package>" : packageName;
                LauncherDiscoveryRequestBuilder launcherDiscoveryRequestBuilder = builder = selectors.isEmpty() ? builder.selectors(new DiscoverySelector[]{DiscoverySelectors.selectPackage((String)packageName)}) : builder.selectors(selectors);
                if (tagName != null && !tagName.isEmpty()) {
                    builder = builder.filters(new Filter[]{TagFilter.includeTags((String[])new String[]{tagName})});
                }
                LauncherDiscoveryRequest launcherDiscoveryRequest = builder.build();
                return launcherDiscoveryRequest;
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(1);
                return null;
            }
        }
        boolean disableDisabledCondition = JUnit5TestRunnerUtil.isDisabledConditionDisabled(suiteClassNames[0]);
        if (disableDisabledCondition) {
            builder = builder.configurationParameter("junit.conditions.deactivate", "org.junit.*DisabledCondition");
        }
        return builder.selectors(new DiscoverySelector[]{JUnit5TestRunnerUtil.createSelector(suiteClassNames[0])}).build();
    }

    public static boolean isDisabledConditionDisabled(String name) {
        int commaIdx = name.indexOf(",");
        boolean disableDisabledCondition = true;
        if (commaIdx < 0) {
            try {
                ClassLoader loader = JUnit5TestRunnerUtil.class.getClassLoader();
                Class<?> aClass = Class.forName(name, false, loader);
                Class<?> disabledAnnotation = Class.forName(DISABLED_ANNO, false, loader);
                disableDisabledCondition = AnnotationUtils.findAnnotation(aClass, disabledAnnotation).isPresent();
            }
            catch (ClassNotFoundException e) {
                disableDisabledCondition = false;
            }
        }
        return disableDisabledCondition;
    }

    protected static DiscoverySelector createSelector(String line) {
        if (line.contains(",")) {
            return DiscoverySelectors.selectMethod((String)line.replaceFirst(",", "#"));
        }
        return DiscoverySelectors.selectClass((String)line);
    }
}

