/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.xrp.collapsetag;

import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.IncorrectOperationException;
import com.sixrr.xrp.collapsetag.CollapseEmptyTagPredicate;
import com.sixrr.xrp.intention.Intention;
import com.sixrr.xrp.intention.PsiElementPredicate;
import com.sixrr.xrp.psi.XMLMutationUtils;
import org.jetbrains.annotations.NotNull;

public class CollapseEmptyTagIntention
extends Intention {
    @NotNull
    public String getText() {
        if ("Collapse Empty Tag" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/xrp/collapsetag/CollapseEmptyTagIntention", "getText"));
        }
        return "Collapse Empty Tag";
    }

    @NotNull
    public String getFamilyName() {
        if ("Collapse Empty Tag" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/xrp/collapsetag/CollapseEmptyTagIntention", "getFamilyName"));
        }
        return "Collapse Empty Tag";
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        CollapseEmptyTagPredicate collapseEmptyTagPredicate = new CollapseEmptyTagPredicate();
        if (collapseEmptyTagPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/xrp/collapsetag/CollapseEmptyTagIntention", "getElementPredicate"));
        }
        return collapseEmptyTagPredicate;
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        IElementType tokenType;
        PsiElement child;
        PsiElement[] children;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/sixrr/xrp/collapsetag/CollapseEmptyTagIntention", "processIntention"));
        }
        XmlTag tag = (XmlTag)element;
        int textLength = tag.getTextLength();
        StringBuffer newTagBuffer = new StringBuffer(textLength);
        PsiElement[] psiElementArray = children = tag.getChildren();
        int n = psiElementArray.length;
        for (int i = 0; !(i >= n || (child = psiElementArray[i]) instanceof XmlToken && (tokenType = ((XmlToken)child).getTokenType()).equals(XmlTokenType.XML_TAG_END)); ++i) {
            String text = child.getText();
            newTagBuffer.append(text);
        }
        newTagBuffer.append("/>");
        String newTag = newTagBuffer.toString();
        XMLMutationUtils.replaceTag(tag, newTag);
    }
}

