/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.cloudfoundry.cloud;

import com.intellij.facet.FacetManager;
import com.intellij.javaee.cloudfoundry.CFDeploymentType;
import com.intellij.javaee.cloudfoundry.agent.CFAppFogInfra;
import com.intellij.javaee.cloudfoundry.agent.service.CFAppServices;
import com.intellij.javaee.cloudfoundry.agent.service.CFAppServicesDomainImpl;
import com.intellij.javaee.cloudfoundry.agent.service.CFAppServicesImpl;
import com.intellij.javaee.cloudfoundry.agent.service.CFServicesDomainImpl;
import com.intellij.javaee.cloudfoundry.agent.settings.CFAppSettings;
import com.intellij.javaee.cloudfoundry.agent.settings.CFAppSettingsImpl;
import com.intellij.javaee.cloudfoundry.agent.settings.CFAppSettingsRangeImpl;
import com.intellij.javaee.cloudfoundry.cloud.CFManifest;
import com.intellij.javaee.cloudfoundry.cloud.CFServerConfiguration;
import com.intellij.javaee.deployment.ArtifactDeploymentSource;
import com.intellij.javaee.ui.packaging.WebApplicationArtifactType;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.remoteServer.configuration.deployment.DeploymentConfigurationBase;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.util.xmlb.annotations.Transient;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CFDeploymentConfiguration
extends DeploymentConfigurationBase<CFDeploymentConfiguration> {
    private CFDeploymentType myType;
    private boolean myDefaultDomain = true;
    private String myDomain;
    private String myInfra;
    private boolean myDebug = false;
    private CFAppSettingsImpl myAppSettings;
    private CFAppServicesImpl myAppServices;
    private CFAppServicesDomainImpl myAppServicesDomain;
    private CFAppSettingsRangeImpl myAppSettingsRange;
    private CFServicesDomainImpl myServicesDomain;
    private CFManifest myManifest = new CFManifest();

    public CFDeploymentType getType() {
        return this.myType;
    }

    public void setType(CFDeploymentType type) {
        this.myType = type;
    }

    public boolean isDebug() {
        return this.myDebug;
    }

    public void setDebug(boolean debug) {
        this.myDebug = debug;
    }

    public CFAppSettingsImpl getAppSettings() {
        return this.myAppSettings;
    }

    public void setAppSettings(CFAppSettingsImpl appSettings) {
        this.myAppSettings = appSettings;
    }

    public CFAppServicesImpl getAppServices() {
        return this.myAppServices;
    }

    public void setAppServices(CFAppServicesImpl appServices) {
        this.myAppServices = appServices;
    }

    public String getInfra() {
        return this.myInfra;
    }

    public void setInfra(String infra) {
        this.myInfra = infra;
    }

    public boolean isDefaultDomain() {
        return this.myDefaultDomain;
    }

    public void setDefaultDomain(boolean defaultDomain) {
        this.myDefaultDomain = defaultDomain;
    }

    public String getDomain() {
        return this.myDomain;
    }

    public void setDomain(String domain) {
        this.myDomain = domain;
    }

    public CFAppSettingsRangeImpl getAppSettingsRange() {
        return this.myAppSettingsRange;
    }

    public void setAppSettingsRange(CFAppSettingsRangeImpl appSettingsRange) {
        this.myAppSettingsRange = appSettingsRange;
    }

    public CFAppServicesDomainImpl getAppServicesDomain() {
        return this.myAppServicesDomain;
    }

    public void setAppServicesDomain(CFAppServicesDomainImpl appServicesDomain) {
        this.myAppServicesDomain = appServicesDomain;
    }

    public CFServicesDomainImpl getServicesDomain() {
        return this.myServicesDomain;
    }

    public void setServicesDomain(CFServicesDomainImpl servicesDomain) {
        this.myServicesDomain = servicesDomain;
    }

    public static boolean isDefaultDomainAvailable(CFServerConfiguration configuration, String infra) {
        return configuration.getDefaultDomain() != null || configuration.isAppFog() && CFDeploymentConfiguration.getAppFogInfra(infra) != null;
    }

    @Transient
    public CFAppFogInfra getAppFogInfra() {
        return CFDeploymentConfiguration.getAppFogInfra(this.getInfra());
    }

    private static CFAppFogInfra getAppFogInfra(String infra) {
        for (CFAppFogInfra appFogInfra : CFAppFogInfra.values()) {
            if (!appFogInfra.getInfra().equals(infra)) continue;
            return appFogInfra;
        }
        return null;
    }

    @Transient
    public void setApplicationServices(CFAppServices appServices) {
        this.setAppServices(new CFAppServicesImpl(appServices));
    }

    @Transient
    public CFAppSettings getApplicationSettings() {
        CFAppSettingsImpl result = this.getAppSettings();
        if (result == null) {
            result = new CFAppSettingsImpl();
        }
        return result;
    }

    @Transient
    public CFAppServices getApplicationServices() {
        CFAppServicesImpl result = this.getAppServices();
        if (result == null) {
            result = new CFAppServicesImpl();
        }
        return result;
    }

    @Transient
    public CFDeploymentType getDeploymentType(DeploymentSource deploymentSource, final Project project) {
        CFDeploymentType type = this.getType();
        if (type != null) {
            return type;
        }
        final Artifact artifact = this.getArtifact(deploymentSource);
        if (artifact != null && artifact.getArtifactType() instanceof WebApplicationArtifactType) {
            Boolean hasSpringFacet = (Boolean)new ReadAction<Boolean>(){

                protected void run(@NotNull Result<Boolean> result) throws Throwable {
                    if (result == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/javaee/cloudfoundry/cloud/CFDeploymentConfiguration$1", "run"));
                    }
                    Set modules = ArtifactUtil.getModulesIncludedInArtifacts(Collections.singleton(artifact), (Project)project);
                    for (Module module : modules) {
                        Collection springFacets = FacetManager.getInstance((Module)module).getFacetsByType(SpringFacet.FACET_TYPE_ID);
                        if (springFacets.isEmpty()) continue;
                        result.setResult((Object)true);
                        return;
                    }
                    result.setResult((Object)false);
                }
            }.execute().getResultObject();
            return hasSpringFacet != false ? CFDeploymentType.SPRING_WEB : CFDeploymentType.JAVA_WEB;
        }
        return CFDeploymentType.STANDALONE;
    }

    @Transient
    @Nullable
    public Artifact getArtifact(DeploymentSource deploymentSource) {
        return deploymentSource instanceof ArtifactDeploymentSource ? ((ArtifactDeploymentSource)deploymentSource).getArtifact() : null;
    }

    public CFManifest getManifest() {
        return this.myManifest;
    }

    public void setManifest(CFManifest manifest) {
        this.myManifest = manifest;
    }
}

