/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.inspections;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.BDDFrameworkType;
import org.jetbrains.plugins.cucumber.CucumberBundle;
import org.jetbrains.plugins.cucumber.CucumberJvmExtensionPoint;
import org.jetbrains.plugins.cucumber.OptionalStepDefinitionExtensionPoint;
import org.jetbrains.plugins.cucumber.StepDefinitionCreator;
import org.jetbrains.plugins.cucumber.inspections.model.CreateStepDefinitionFileModel;
import org.jetbrains.plugins.cucumber.inspections.ui.CreateStepDefinitionFileDialog;
import org.jetbrains.plugins.cucumber.psi.GherkinFile;
import org.jetbrains.plugins.cucumber.psi.GherkinStep;
import org.jetbrains.plugins.cucumber.steps.CucumberStepsIndex;

public abstract class CucumberCreateStepFixBase
implements LocalQuickFix {
    protected abstract void createStepOrSteps(GherkinStep var1, @Nullable Pair<PsiFile, BDDFrameworkType> var2);

    @NotNull
    public String getFamilyName() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/inspections/CucumberCreateStepFixBase", "getFamilyName"));
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/cucumber/inspections/CucumberCreateStepFixBase", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/plugins/cucumber/inspections/CucumberCreateStepFixBase", "applyFix"));
        }
        final GherkinStep step = (GherkinStep)descriptor.getPsiElement();
        GherkinFile featureFile = (GherkinFile)step.getContainingFile();
        final ArrayList pairs = ContainerUtil.newArrayList(CucumberCreateStepFixBase.getStepDefinitionContainers(featureFile));
        if (!pairs.isEmpty()) {
            pairs.add(0, null);
            JBPopupFactory popupFactory = JBPopupFactory.getInstance();
            ListPopup popupStep = popupFactory.createListPopup((ListPopupStep)new BaseListPopupStep<Pair<PsiFile, BDDFrameworkType>>(CucumberBundle.message("choose.step.definition.file", new Object[0]), (List)ContainerUtil.newArrayList((Iterable)pairs)){

                public boolean isSpeedSearchEnabled() {
                    return true;
                }

                @NotNull
                public String getTextFor(Pair<PsiFile, BDDFrameworkType> value) {
                    if (value == null) {
                        String string = CucumberBundle.message("create.new.file", new Object[0]);
                        if (string == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/inspections/CucumberCreateStepFixBase$1", "getTextFor"));
                        }
                        return string;
                    }
                    VirtualFile file = ((PsiFile)value.getFirst()).getVirtualFile();
                    assert (file != null);
                    CucumberStepsIndex stepsIndex = CucumberStepsIndex.getInstance(((PsiFile)value.getFirst()).getProject());
                    StepDefinitionCreator stepDefinitionCreator = stepsIndex.getExtensionMap().get(value.getSecond()).getStepDefinitionCreator();
                    String string = stepDefinitionCreator.getStepDefinitionFilePath((PsiFile)value.getFirst());
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/inspections/CucumberCreateStepFixBase$1", "getTextFor"));
                    }
                    return string;
                }

                public Icon getIconFor(Pair<PsiFile, BDDFrameworkType> value) {
                    return value == null ? AllIcons.Actions.CreateFromUsage : ((PsiFile)value.getFirst()).getIcon(0);
                }

                public PopupStep onChosen(Pair<PsiFile, BDDFrameworkType> selectedValue, boolean finalChoice) {
                    return this.doFinalStep(() -> CucumberCreateStepFixBase.this.createStepOrSteps(step, selectedValue));
                }
            });
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                popupStep.showCenteredInCurrentWindow(step.getProject());
            } else {
                new WriteCommandAction.Simple(step.getProject(), new PsiFile[0]){

                    protected void run() throws Throwable {
                        CucumberCreateStepFixBase.this.createStepOrSteps(step, (Pair<PsiFile, BDDFrameworkType>)((Pair)pairs.get(1)));
                    }
                }.execute();
            }
        } else {
            this.createFileOrStepDefinition(step, null);
        }
    }

    public static Set<Pair<PsiFile, BDDFrameworkType>> getStepDefinitionContainers(@NotNull GherkinFile featureFile) {
        if (featureFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "featureFile", "org/jetbrains/plugins/cucumber/inspections/CucumberCreateStepFixBase", "getStepDefinitionContainers"));
        }
        Set<Pair<PsiFile, BDDFrameworkType>> result = CucumberStepsIndex.getInstance(featureFile.getProject()).getStepDefinitionContainers(featureFile);
        CucumberStepsIndex stepsIndex = CucumberStepsIndex.getInstance(featureFile.getProject());
        for (Pair<PsiFile, BDDFrameworkType> item : result) {
            if (stepsIndex.getExtensionMap().get(item.getSecond()) != null) continue;
            result.remove(item);
        }
        return result;
    }

    private void createStepDefinitionFile(final GherkinStep step) {
        PsiFile featureFile = step.getContainingFile();
        assert (featureFile != null);
        final CreateStepDefinitionFileModel model = CucumberCreateStepFixBase.askUserForFilePath(step);
        if (model == null) {
            return;
        }
        String filePath = FileUtil.toSystemDependentName((String)model.getFilePath());
        final BDDFrameworkType frameworkType = model.getSelectedFileType();
        if (LocalFileSystem.getInstance().findFileByPath(filePath) == null) {
            final String parentDirPath = model.getDirectory().getVirtualFile().getPath();
            ApplicationManager.getApplication().invokeLater(() -> new WriteCommandAction.Simple(step.getProject(), CucumberBundle.message("cucumber.quick.fix.create.step.command.name.create", new Object[0]), new PsiFile[0]){

                protected void run() throws Throwable {
                    VirtualFile parentDir = VfsUtil.createDirectories((String)parentDirPath);
                    Project project = this.getProject();
                    assert (project != null);
                    PsiDirectory parentPsiDir = PsiManager.getInstance((Project)project).findDirectory(parentDir);
                    assert (parentPsiDir != null);
                    PsiFile newFile = CucumberStepsIndex.getInstance(step.getProject()).createStepDefinitionFile(model.getDirectory(), model.getFileName(), frameworkType);
                    Pair pair = Pair.create((Object)newFile, (Object)frameworkType);
                    CucumberCreateStepFixBase.this.createStepDefinition(step, (Pair<PsiFile, BDDFrameworkType>)pair);
                }
            }.execute());
        } else {
            Messages.showErrorDialog((Project)step.getProject(), (String)CucumberBundle.message("cucumber.quick.fix.create.step.error.already.exist.msg", filePath), (String)CucumberBundle.message("cucumber.quick.fix.create.step.file.name.title", new Object[0]));
        }
    }

    protected void createFileOrStepDefinition(final GherkinStep step, final @Nullable Pair<PsiFile, BDDFrameworkType> fileAndFrameworkType) {
        if (fileAndFrameworkType == null) {
            this.createStepDefinitionFile(step);
        } else {
            new WriteCommandAction.Simple(step.getProject(), new PsiFile[0]){

                protected void run() throws Throwable {
                    CucumberCreateStepFixBase.this.createStepDefinition(step, (Pair<PsiFile, BDDFrameworkType>)fileAndFrameworkType);
                }
            }.execute();
        }
    }

    @Nullable
    private static CreateStepDefinitionFileModel askUserForFilePath(@NotNull GherkinStep step) {
        if (step == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "step", "org/jetbrains/plugins/cucumber/inspections/CucumberCreateStepFixBase", "askUserForFilePath"));
        }
        InputValidator validator = new InputValidator(){

            public boolean checkInput(String filePath) {
                return !StringUtil.isEmpty((String)filePath);
            }

            public boolean canClose(String fileName) {
                return true;
            }
        };
        HashMap supportedFileTypesAndDefaultFileNames = new HashMap();
        HashMap fileTypeToDefaultDirectoryMap = new HashMap();
        for (CucumberJvmExtensionPoint e : (CucumberJvmExtensionPoint[])Extensions.getExtensions(CucumberJvmExtensionPoint.EP_NAME)) {
            if (e instanceof OptionalStepDefinitionExtensionPoint && !((OptionalStepDefinitionExtensionPoint)e).participateInStepDefinitionCreation(step)) continue;
            supportedFileTypesAndDefaultFileNames.put(e.getStepFileType(), e.getStepDefinitionCreator().getDefaultStepFileName(step));
            fileTypeToDefaultDirectoryMap.put(e.getStepFileType(), e.getStepDefinitionCreator().getDefaultStepDefinitionFolder(step));
        }
        CreateStepDefinitionFileModel model = new CreateStepDefinitionFileModel(step.getProject(), (Map<BDDFrameworkType, String>)supportedFileTypesAndDefaultFileNames, (Map<BDDFrameworkType, PsiDirectory>)fileTypeToDefaultDirectoryMap);
        CreateStepDefinitionFileDialog createStepDefinitionFileDialog = new CreateStepDefinitionFileDialog(step.getProject(), model, validator);
        if (createStepDefinitionFileDialog.showAndGet()) {
            return model;
        }
        return null;
    }

    protected void createStepDefinition(GherkinStep step, @NotNull Pair<PsiFile, BDDFrameworkType> fileAndFrameworkType) {
        if (fileAndFrameworkType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileAndFrameworkType", "org/jetbrains/plugins/cucumber/inspections/CucumberCreateStepFixBase", "createStepDefinition"));
        }
        if (!FileModificationService.getInstance().prepareFileForWrite((PsiFile)fileAndFrameworkType.first)) {
            return;
        }
        CucumberStepsIndex stepsIndex = CucumberStepsIndex.getInstance(step.getProject());
        StepDefinitionCreator stepDefCreator = stepsIndex.getExtensionMap().get(fileAndFrameworkType.getSecond()).getStepDefinitionCreator();
        stepDefCreator.createStepDefinition(step, (PsiFile)fileAndFrameworkType.first);
    }
}

