/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.steps;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.cucumber.CucumberJvmExtensionPoint;
import org.jetbrains.plugins.cucumber.psi.GherkinStep;
import org.jetbrains.plugins.cucumber.steps.AbstractStepDefinition;

public abstract class AbstractCucumberExtension
implements CucumberJvmExtensionPoint {
    @Override
    public List<PsiElement> resolveStep(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/cucumber/steps/AbstractCucumberExtension", "resolveStep"));
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module == null) {
            return Collections.emptyList();
        }
        Set<String> stepVariants = this.getAllPossibleStepVariants(element);
        List<AbstractStepDefinition> stepDefinitions = this.loadStepsFor(element.getContainingFile(), module);
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        block0: for (AbstractStepDefinition stepDefinition : stepDefinitions) {
            for (String s : stepVariants) {
                if (!stepDefinition.matches(s) || !stepDefinition.supportsStep(element)) continue;
                result.add(stepDefinition.getElement());
                continue block0;
            }
        }
        return result;
    }

    protected Set<String> getAllPossibleStepVariants(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/cucumber/steps/AbstractCucumberExtension", "getAllPossibleStepVariants"));
        }
        if (element instanceof GherkinStep) {
            return ((GherkinStep)element).getSubstitutedNameList();
        }
        return Collections.emptySet();
    }

    @Override
    public void flush(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/cucumber/steps/AbstractCucumberExtension", "flush"));
        }
    }

    @Override
    public void reset(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/cucumber/steps/AbstractCucumberExtension", "reset"));
        }
    }

    @Override
    public Object getDataObject(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/cucumber/steps/AbstractCucumberExtension", "getDataObject"));
        }
        return null;
    }
}

