/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.thymeleaf.highlighting;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.thymeleaf.highlighting.fixes.DeclareThymeleafVarInCommentFix;
import com.intellij.thymeleaf.lang.psi.ThymesELSelectExpression;
import com.intellij.thymeleaf.lang.psi.ThymesELVariable;
import com.intellij.thymeleaf.lang.psi.ThymesOgnlExpression;
import com.intellij.thymeleaf.lang.psi.ThymesVisitor;
import com.intellij.thymeleaf.resources.ThymeleafBundle;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ThymeleafVariablesResolveInspection
extends XmlSuppressableInspectionTool {
    @NonNls
    public static final String SHORT_NAME = "ThymeleafVariablesResolveInspection";

    @NotNull
    public String getGroupDisplayName() {
        String string = ThymeleafBundle.message("thymeleaf.inspection.group", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/thymeleaf/highlighting/ThymeleafVariablesResolveInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getDisplayName() {
        String string = ThymeleafBundle.message("ThymeleafVariablesResolveInspection.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/thymeleaf/highlighting/ThymeleafVariablesResolveInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if (SHORT_NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/thymeleaf/highlighting/ThymeleafVariablesResolveInspection", "getShortName"));
        }
        return SHORT_NAME;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/thymeleaf/highlighting/ThymeleafVariablesResolveInspection", "buildVisitor"));
        }
        ThymesVisitor thymesVisitor = new ThymesVisitor(){

            @Override
            public void visitELVariable(@NotNull ThymesELVariable variable) {
                if (variable == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/thymeleaf/highlighting/ThymeleafVariablesResolveInspection$1", "visitELVariable"));
                }
                PsiReference reference = variable.getReference();
                if (reference == null || reference.isSoft()) {
                    return;
                }
                PsiElement results = reference.resolve();
                if (results == null) {
                    holder.registerProblem((PsiElement)variable, ThymeleafBundle.message("ThymeleafVariablesResolveInspection.cannot.resolve.variable", variable.getText()), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.getFixes(variable));
                }
            }

            public LocalQuickFix[] getFixes(ThymesELVariable variable) {
                PsiElement parent = variable.getParent();
                if (parent instanceof ThymesELSelectExpression || parent instanceof ThymesOgnlExpression) {
                    return new LocalQuickFix[]{new DeclareThymeleafVarInCommentFix(variable.getText())};
                }
                return LocalQuickFix.EMPTY_ARRAY;
            }
        };
        if (thymesVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/thymeleaf/highlighting/ThymeleafVariablesResolveInspection", "buildVisitor"));
        }
        return thymesVisitor;
    }
}

